// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Customized accelerator properties payload.
 */
@Fluent
public final class CustomizedAcceleratorProperties {
    /*
     * State of the customized accelerator.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private CustomizedAcceleratorProvisioningState provisioningState;

    /*
     * Type of the customized accelerator.
     */
    @JsonProperty(value = "acceleratorType")
    private CustomizedAcceleratorType acceleratorType;

    /*
     * The displayName property.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The description property.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The iconUrl property.
     */
    @JsonProperty(value = "iconUrl")
    private String iconUrl;

    /*
     * The acceleratorTags property.
     */
    @JsonProperty(value = "acceleratorTags")
    private List<String> acceleratorTags;

    /*
     * Imports references all imports that this accelerator/fragment depends upon.
     */
    @JsonProperty(value = "imports", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> imports;

    /*
     * The gitRepository property.
     */
    @JsonProperty(value = "gitRepository", required = true)
    private AcceleratorGitRepository gitRepository;

    /**
     * Creates an instance of CustomizedAcceleratorProperties class.
     */
    public CustomizedAcceleratorProperties() {
    }

    /**
     * Get the provisioningState property: State of the customized accelerator.
     * 
     * @return the provisioningState value.
     */
    public CustomizedAcceleratorProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the acceleratorType property: Type of the customized accelerator.
     * 
     * @return the acceleratorType value.
     */
    public CustomizedAcceleratorType acceleratorType() {
        return this.acceleratorType;
    }

    /**
     * Set the acceleratorType property: Type of the customized accelerator.
     * 
     * @param acceleratorType the acceleratorType value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withAcceleratorType(CustomizedAcceleratorType acceleratorType) {
        this.acceleratorType = acceleratorType;
        return this;
    }

    /**
     * Get the displayName property: The displayName property.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The displayName property.
     * 
     * @param displayName the displayName value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the iconUrl property: The iconUrl property.
     * 
     * @return the iconUrl value.
     */
    public String iconUrl() {
        return this.iconUrl;
    }

    /**
     * Set the iconUrl property: The iconUrl property.
     * 
     * @param iconUrl the iconUrl value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    /**
     * Get the acceleratorTags property: The acceleratorTags property.
     * 
     * @return the acceleratorTags value.
     */
    public List<String> acceleratorTags() {
        return this.acceleratorTags;
    }

    /**
     * Set the acceleratorTags property: The acceleratorTags property.
     * 
     * @param acceleratorTags the acceleratorTags value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withAcceleratorTags(List<String> acceleratorTags) {
        this.acceleratorTags = acceleratorTags;
        return this;
    }

    /**
     * Get the imports property: Imports references all imports that this accelerator/fragment depends upon.
     * 
     * @return the imports value.
     */
    public List<String> imports() {
        return this.imports;
    }

    /**
     * Get the gitRepository property: The gitRepository property.
     * 
     * @return the gitRepository value.
     */
    public AcceleratorGitRepository gitRepository() {
        return this.gitRepository;
    }

    /**
     * Set the gitRepository property: The gitRepository property.
     * 
     * @param gitRepository the gitRepository value to set.
     * @return the CustomizedAcceleratorProperties object itself.
     */
    public CustomizedAcceleratorProperties withGitRepository(AcceleratorGitRepository gitRepository) {
        this.gitRepository = gitRepository;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (gitRepository() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property gitRepository in model CustomizedAcceleratorProperties"));
        } else {
            gitRepository().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomizedAcceleratorProperties.class);
}
