// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Validation result for configuration service settings.
 */
@Fluent
public final class ConfigurationServiceGitPropertyValidateResult {
    /*
     * Indicate if the configuration service settings are valid
     */
    @JsonProperty(value = "isValid")
    private Boolean isValid;

    /*
     * The detail validation results
     */
    @JsonProperty(value = "gitReposValidationResult")
    private List<ValidationMessages> gitReposValidationResult;

    /**
     * Creates an instance of ConfigurationServiceGitPropertyValidateResult class.
     */
    public ConfigurationServiceGitPropertyValidateResult() {
    }

    /**
     * Get the isValid property: Indicate if the configuration service settings are valid.
     * 
     * @return the isValid value.
     */
    public Boolean isValid() {
        return this.isValid;
    }

    /**
     * Set the isValid property: Indicate if the configuration service settings are valid.
     * 
     * @param isValid the isValid value to set.
     * @return the ConfigurationServiceGitPropertyValidateResult object itself.
     */
    public ConfigurationServiceGitPropertyValidateResult withIsValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    /**
     * Get the gitReposValidationResult property: The detail validation results.
     * 
     * @return the gitReposValidationResult value.
     */
    public List<ValidationMessages> gitReposValidationResult() {
        return this.gitReposValidationResult;
    }

    /**
     * Set the gitReposValidationResult property: The detail validation results.
     * 
     * @param gitReposValidationResult the gitReposValidationResult value to set.
     * @return the ConfigurationServiceGitPropertyValidateResult object itself.
     */
    public ConfigurationServiceGitPropertyValidateResult
        withGitReposValidationResult(List<ValidationMessages> gitReposValidationResult) {
        this.gitReposValidationResult = gitReposValidationResult;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (gitReposValidationResult() != null) {
            gitReposValidationResult().forEach(e -> e.validate());
        }
    }
}
