// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Buildpack Binding Launch Properties.
 */
@Fluent
public final class BuildpackBindingLaunchProperties {
    /*
     * Non-sensitive properties for launchProperties
     */
    @JsonProperty(value = "properties")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> properties;

    /*
     * Sensitive properties for launchProperties
     */
    @JsonProperty(value = "secrets")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> secrets;

    /**
     * Creates an instance of BuildpackBindingLaunchProperties class.
     */
    public BuildpackBindingLaunchProperties() {
    }

    /**
     * Get the properties property: Non-sensitive properties for launchProperties.
     * 
     * @return the properties value.
     */
    public Map<String, String> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Non-sensitive properties for launchProperties.
     * 
     * @param properties the properties value to set.
     * @return the BuildpackBindingLaunchProperties object itself.
     */
    public BuildpackBindingLaunchProperties withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the secrets property: Sensitive properties for launchProperties.
     * 
     * @return the secrets value.
     */
    public Map<String, String> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: Sensitive properties for launchProperties.
     * 
     * @param secrets the secrets value to set.
     * @return the BuildpackBindingLaunchProperties object itself.
     */
    public BuildpackBindingLaunchProperties withSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
