// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appplatform.fluent.models.SupportedApmTypeInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Supported APM types payload.
 */
@Fluent
public final class SupportedApmTypes {
    /*
     * Collection of the supported APM type
     */
    @JsonProperty(value = "value")
    private List<SupportedApmTypeInner> value;

    /*
     * URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of SupportedApmTypes class.
     */
    public SupportedApmTypes() {
    }

    /**
     * Get the value property: Collection of the supported APM type.
     * 
     * @return the value value.
     */
    public List<SupportedApmTypeInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of the supported APM type.
     * 
     * @param value the value value to set.
     * @return the SupportedApmTypes object itself.
     */
    public SupportedApmTypes withValue(List<SupportedApmTypeInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SupportedApmTypes object itself.
     */
    public SupportedApmTypes withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
