// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * HTTPGetAction describes an action based on HTTP Get requests.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("HTTPGetAction")
@Fluent
public final class HttpGetAction extends ProbeAction {
    /*
     * Path to access on the HTTP server.
     */
    @JsonProperty(value = "path")
    private String path;

    /*
     * Scheme to use for connecting to the host. Defaults to HTTP.
     * 
     * Possible enum values:
     * - `"HTTP"` means that the scheme used will be http://
     * - `"HTTPS"` means that the scheme used will be https://
     */
    @JsonProperty(value = "scheme")
    private HttpSchemeType scheme;

    /**
     * Creates an instance of HttpGetAction class.
     */
    public HttpGetAction() {
    }

    /**
     * Get the path property: Path to access on the HTTP server.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: Path to access on the HTTP server.
     * 
     * @param path the path value to set.
     * @return the HttpGetAction object itself.
     */
    public HttpGetAction withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the scheme property: Scheme to use for connecting to the host. Defaults to HTTP.
     * 
     * Possible enum values:
     * - `"HTTP"` means that the scheme used will be http://
     * - `"HTTPS"` means that the scheme used will be https://.
     * 
     * @return the scheme value.
     */
    public HttpSchemeType scheme() {
        return this.scheme;
    }

    /**
     * Set the scheme property: Scheme to use for connecting to the host. Defaults to HTTP.
     * 
     * Possible enum values:
     * - `"HTTP"` means that the scheme used will be http://
     * - `"HTTPS"` means that the scheme used will be https://.
     * 
     * @param scheme the scheme value to set.
     * @return the HttpGetAction object itself.
     */
    public HttpGetAction withScheme(HttpSchemeType scheme) {
        this.scheme = scheme;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
