// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Property of git.
 */
@Fluent
public final class ConfigServerGitProperty {
    /*
     * Repositories of git.
     */
    @JsonProperty(value = "repositories")
    private List<GitPatternRepository> repositories;

    /*
     * URI of the repository
     */
    @JsonProperty(value = "uri", required = true)
    private String uri;

    /*
     * Label of the repository
     */
    @JsonProperty(value = "label")
    private String label;

    /*
     * Searching path of the repository
     */
    @JsonProperty(value = "searchPaths")
    private List<String> searchPaths;

    /*
     * Username of git repository basic auth.
     */
    @JsonProperty(value = "username")
    private String username;

    /*
     * Password of git repository basic auth.
     */
    @JsonProperty(value = "password")
    private String password;

    /*
     * Public sshKey of git repository.
     */
    @JsonProperty(value = "hostKey")
    private String hostKey;

    /*
     * SshKey algorithm of git repository.
     */
    @JsonProperty(value = "hostKeyAlgorithm")
    private String hostKeyAlgorithm;

    /*
     * Private sshKey algorithm of git repository.
     */
    @JsonProperty(value = "privateKey")
    private String privateKey;

    /*
     * Strict host key checking or not.
     */
    @JsonProperty(value = "strictHostKeyChecking")
    private Boolean strictHostKeyChecking;

    /**
     * Creates an instance of ConfigServerGitProperty class.
     */
    public ConfigServerGitProperty() {
    }

    /**
     * Get the repositories property: Repositories of git.
     * 
     * @return the repositories value.
     */
    public List<GitPatternRepository> repositories() {
        return this.repositories;
    }

    /**
     * Set the repositories property: Repositories of git.
     * 
     * @param repositories the repositories value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withRepositories(List<GitPatternRepository> repositories) {
        this.repositories = repositories;
        return this;
    }

    /**
     * Get the uri property: URI of the repository.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: URI of the repository.
     * 
     * @param uri the uri value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the label property: Label of the repository.
     * 
     * @return the label value.
     */
    public String label() {
        return this.label;
    }

    /**
     * Set the label property: Label of the repository.
     * 
     * @param label the label value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the searchPaths property: Searching path of the repository.
     * 
     * @return the searchPaths value.
     */
    public List<String> searchPaths() {
        return this.searchPaths;
    }

    /**
     * Set the searchPaths property: Searching path of the repository.
     * 
     * @param searchPaths the searchPaths value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withSearchPaths(List<String> searchPaths) {
        this.searchPaths = searchPaths;
        return this;
    }

    /**
     * Get the username property: Username of git repository basic auth.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: Username of git repository basic auth.
     * 
     * @param username the username value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: Password of git repository basic auth.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: Password of git repository basic auth.
     * 
     * @param password the password value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the hostKey property: Public sshKey of git repository.
     * 
     * @return the hostKey value.
     */
    public String hostKey() {
        return this.hostKey;
    }

    /**
     * Set the hostKey property: Public sshKey of git repository.
     * 
     * @param hostKey the hostKey value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withHostKey(String hostKey) {
        this.hostKey = hostKey;
        return this;
    }

    /**
     * Get the hostKeyAlgorithm property: SshKey algorithm of git repository.
     * 
     * @return the hostKeyAlgorithm value.
     */
    public String hostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    /**
     * Set the hostKeyAlgorithm property: SshKey algorithm of git repository.
     * 
     * @param hostKeyAlgorithm the hostKeyAlgorithm value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withHostKeyAlgorithm(String hostKeyAlgorithm) {
        this.hostKeyAlgorithm = hostKeyAlgorithm;
        return this;
    }

    /**
     * Get the privateKey property: Private sshKey algorithm of git repository.
     * 
     * @return the privateKey value.
     */
    public String privateKey() {
        return this.privateKey;
    }

    /**
     * Set the privateKey property: Private sshKey algorithm of git repository.
     * 
     * @param privateKey the privateKey value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    /**
     * Get the strictHostKeyChecking property: Strict host key checking or not.
     * 
     * @return the strictHostKeyChecking value.
     */
    public Boolean strictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    /**
     * Set the strictHostKeyChecking property: Strict host key checking or not.
     * 
     * @param strictHostKeyChecking the strictHostKeyChecking value to set.
     * @return the ConfigServerGitProperty object itself.
     */
    public ConfigServerGitProperty withStrictHostKeyChecking(Boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (repositories() != null) {
            repositories().forEach(e -> e.validate());
        }
        if (uri() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property uri in model ConfigServerGitProperty"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConfigServerGitProperty.class);
}
