// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * State of the Application Live View.
 */
public final class ApplicationLiveViewProvisioningState
    extends ExpandableStringEnum<ApplicationLiveViewProvisioningState> {
    /**
     * Static value Creating for ApplicationLiveViewProvisioningState.
     */
    public static final ApplicationLiveViewProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for ApplicationLiveViewProvisioningState.
     */
    public static final ApplicationLiveViewProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Succeeded for ApplicationLiveViewProvisioningState.
     */
    public static final ApplicationLiveViewProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for ApplicationLiveViewProvisioningState.
     */
    public static final ApplicationLiveViewProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Deleting for ApplicationLiveViewProvisioningState.
     */
    public static final ApplicationLiveViewProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Canceled for ApplicationLiveViewProvisioningState.
     */
    public static final ApplicationLiveViewProvisioningState CANCELED = fromString("Canceled");

    /**
     * Creates a new instance of ApplicationLiveViewProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ApplicationLiveViewProvisioningState() {
    }

    /**
     * Creates or finds a ApplicationLiveViewProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ApplicationLiveViewProvisioningState.
     */
    @JsonCreator
    public static ApplicationLiveViewProvisioningState fromString(String name) {
        return fromString(name, ApplicationLiveViewProvisioningState.class);
    }

    /**
     * Gets known ApplicationLiveViewProvisioningState values.
     * 
     * @return known ApplicationLiveViewProvisioningState values.
     */
    public static Collection<ApplicationLiveViewProvisioningState> values() {
        return values(ApplicationLiveViewProvisioningState.class);
    }
}
