// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Validation result for container registry properties.
 */
@Fluent
public final class ContainerRegistryValidateResultInner {
    /*
     * Indicate if the container registry properties are valid
     */
    @JsonProperty(value = "isValid")
    private Boolean isValid;

    /*
     * Detailed validation messages.
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * Creates an instance of ContainerRegistryValidateResultInner class.
     */
    public ContainerRegistryValidateResultInner() {
    }

    /**
     * Get the isValid property: Indicate if the container registry properties are valid.
     * 
     * @return the isValid value.
     */
    public Boolean isValid() {
        return this.isValid;
    }

    /**
     * Set the isValid property: Indicate if the container registry properties are valid.
     * 
     * @param isValid the isValid value to set.
     * @return the ContainerRegistryValidateResultInner object itself.
     */
    public ContainerRegistryValidateResultInner withIsValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    /**
     * Get the message property: Detailed validation messages.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Detailed validation messages.
     * 
     * @param message the message value to set.
     * @return the ContainerRegistryValidateResultInner object itself.
     */
    public ContainerRegistryValidateResultInner withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
