// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Dev Tool Portal properties payload.
 */
@Fluent
public final class DevToolPortalProperties {
    /*
     * State of the Dev Tool Portal.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private DevToolPortalProvisioningState provisioningState;

    /*
     * Collection of components belong to Dev Tool Portal.
     */
    @JsonProperty(value = "components", access = JsonProperty.Access.WRITE_ONLY)
    private List<DevToolPortalComponent> components;

    /*
     * Indicates whether the resource exposes public endpoint
     */
    @JsonProperty(value = "public")
    private Boolean publicProperty;

    /*
     * URL of the resource, exposed when 'public' is true.
     */
    @JsonProperty(value = "url", access = JsonProperty.Access.WRITE_ONLY)
    private String url;

    /*
     * Single sign-on related configuration
     */
    @JsonProperty(value = "ssoProperties")
    private DevToolPortalSsoProperties ssoProperties;

    /*
     * Settings for Dev Tool Portal
     */
    @JsonProperty(value = "features")
    private DevToolPortalFeatureSettings features;

    /**
     * Creates an instance of DevToolPortalProperties class.
     */
    public DevToolPortalProperties() {
    }

    /**
     * Get the provisioningState property: State of the Dev Tool Portal.
     * 
     * @return the provisioningState value.
     */
    public DevToolPortalProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the components property: Collection of components belong to Dev Tool Portal.
     * 
     * @return the components value.
     */
    public List<DevToolPortalComponent> components() {
        return this.components;
    }

    /**
     * Get the publicProperty property: Indicates whether the resource exposes public endpoint.
     * 
     * @return the publicProperty value.
     */
    public Boolean publicProperty() {
        return this.publicProperty;
    }

    /**
     * Set the publicProperty property: Indicates whether the resource exposes public endpoint.
     * 
     * @param publicProperty the publicProperty value to set.
     * @return the DevToolPortalProperties object itself.
     */
    public DevToolPortalProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    /**
     * Get the url property: URL of the resource, exposed when 'public' is true.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Get the ssoProperties property: Single sign-on related configuration.
     * 
     * @return the ssoProperties value.
     */
    public DevToolPortalSsoProperties ssoProperties() {
        return this.ssoProperties;
    }

    /**
     * Set the ssoProperties property: Single sign-on related configuration.
     * 
     * @param ssoProperties the ssoProperties value to set.
     * @return the DevToolPortalProperties object itself.
     */
    public DevToolPortalProperties withSsoProperties(DevToolPortalSsoProperties ssoProperties) {
        this.ssoProperties = ssoProperties;
        return this;
    }

    /**
     * Get the features property: Settings for Dev Tool Portal.
     * 
     * @return the features value.
     */
    public DevToolPortalFeatureSettings features() {
        return this.features;
    }

    /**
     * Set the features property: Settings for Dev Tool Portal.
     * 
     * @param features the features value to set.
     * @return the DevToolPortalProperties object itself.
     */
    public DevToolPortalProperties withFeatures(DevToolPortalFeatureSettings features) {
        this.features = features;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (components() != null) {
            components().forEach(e -> e.validate());
        }
        if (ssoProperties() != null) {
            ssoProperties().validate();
        }
        if (features() != null) {
            features().validate();
        }
    }
}
