// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The ApplicationAcceleratorComponent model.
 */
@Fluent
public final class ApplicationAcceleratorComponent {
    /*
     * The name property.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The resourceRequests property.
     */
    @JsonProperty(value = "resourceRequests")
    private ApplicationAcceleratorResourceRequests resourceRequests;

    /*
     * The instances property.
     */
    @JsonProperty(value = "instances", access = JsonProperty.Access.WRITE_ONLY)
    private List<ApplicationAcceleratorInstance> instances;

    /**
     * Creates an instance of ApplicationAcceleratorComponent class.
     */
    public ApplicationAcceleratorComponent() {
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the resourceRequests property: The resourceRequests property.
     * 
     * @return the resourceRequests value.
     */
    public ApplicationAcceleratorResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Set the resourceRequests property: The resourceRequests property.
     * 
     * @param resourceRequests the resourceRequests value to set.
     * @return the ApplicationAcceleratorComponent object itself.
     */
    public ApplicationAcceleratorComponent
        withResourceRequests(ApplicationAcceleratorResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    /**
     * Get the instances property: The instances property.
     * 
     * @return the instances value.
     */
    public List<ApplicationAcceleratorInstance> instances() {
        return this.instances;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }
}
