// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appplatform.models.StorageProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Storage resource payload.
 */
@Fluent
public final class StorageResourceInner extends ProxyResource {
    /*
     * Properties of the storage resource payload.
     */
    @JsonProperty(value = "properties")
    private StorageProperties properties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Creates an instance of StorageResourceInner class.
     */
    public StorageResourceInner() {
    }

    /**
     * Get the properties property: Properties of the storage resource payload.
     * 
     * @return the properties value.
     */
    public StorageProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the storage resource payload.
     * 
     * @param properties the properties value to set.
     * @return the StorageResourceInner object itself.
     */
    public StorageResourceInner withProperties(StorageProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
