// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appplatform.models.BuildServiceProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Build service resource payload.
 */
@Fluent
public final class BuildServiceInner extends ProxyResource {
    /*
     * Properties of the build resource
     */
    @JsonProperty(value = "properties")
    private BuildServiceProperties properties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Creates an instance of BuildServiceInner class.
     */
    public BuildServiceInner() {
    }

    /**
     * Get the properties property: Properties of the build resource.
     * 
     * @return the properties value.
     */
    public BuildServiceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the build resource.
     * 
     * @param properties the properties value to set.
     * @return the BuildServiceInner object itself.
     */
    public BuildServiceInner withProperties(BuildServiceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
