// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.appplatform.models.SupportedRuntimeVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The AvailableRuntimeVersions model.
 */
@Immutable
public final class AvailableRuntimeVersionsInner {
    /*
     * A list of all supported runtime versions.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<SupportedRuntimeVersion> value;

    /**
     * Creates an instance of AvailableRuntimeVersionsInner class.
     */
    public AvailableRuntimeVersionsInner() {
    }

    /**
     * Get the value property: A list of all supported runtime versions.
     * 
     * @return the value value.
     */
    public List<SupportedRuntimeVersion> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
