// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Ingress configuration payload for Azure Spring Apps resource.
 */
@Fluent
public final class IngressConfig {
    /*
     * Ingress read time out in seconds.
     */
    @JsonProperty(value = "readTimeoutInSeconds")
    private Integer readTimeoutInSeconds;

    /**
     * Creates an instance of IngressConfig class.
     */
    public IngressConfig() {
    }

    /**
     * Get the readTimeoutInSeconds property: Ingress read time out in seconds.
     * 
     * @return the readTimeoutInSeconds value.
     */
    public Integer readTimeoutInSeconds() {
        return this.readTimeoutInSeconds;
    }

    /**
     * Set the readTimeoutInSeconds property: Ingress read time out in seconds.
     * 
     * @param readTimeoutInSeconds the readTimeoutInSeconds value to set.
     * @return the IngressConfig object itself.
     */
    public IngressConfig withReadTimeoutInSeconds(Integer readTimeoutInSeconds) {
        this.readTimeoutInSeconds = readTimeoutInSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
