// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Spring Cloud Gateway properties payload.
 */
@Fluent
public final class GatewayProperties {
    /*
     * State of the Spring Cloud Gateway.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private GatewayProvisioningState provisioningState;

    /*
     * Indicates whether the Spring Cloud Gateway exposes endpoint.
     */
    @JsonProperty(value = "public")
    private Boolean publicProperty;

    /*
     * URL of the Spring Cloud Gateway, exposed when 'public' is true.
     */
    @JsonProperty(value = "url", access = JsonProperty.Access.WRITE_ONLY)
    private String url;

    /*
     * Indicate if only https is allowed.
     */
    @JsonProperty(value = "httpsOnly")
    private Boolean httpsOnly;

    /*
     * Single sign-on related configuration
     */
    @JsonProperty(value = "ssoProperties")
    private SsoProperties ssoProperties;

    /*
     * API metadata property for Spring Cloud Gateway
     */
    @JsonProperty(value = "apiMetadataProperties")
    private GatewayApiMetadataProperties apiMetadataProperties;

    /*
     * Cross-Origin Resource Sharing property
     */
    @JsonProperty(value = "corsProperties")
    private GatewayCorsProperties corsProperties;

    /*
     * Client-Certification Authentication.
     */
    @JsonProperty(value = "clientAuth")
    private GatewayPropertiesClientAuth clientAuth;

    /*
     * Collection of ApmReferences in service level
     */
    @JsonProperty(value = "apms")
    private List<ApmReference> apms;

    /*
     * Environment variables of Spring Cloud Gateway
     */
    @JsonProperty(value = "environmentVariables")
    private GatewayPropertiesEnvironmentVariables environmentVariables;

    /*
     * The requested resource quantity for required CPU and Memory.
     */
    @JsonProperty(value = "resourceRequests")
    private GatewayResourceRequests resourceRequests;

    /*
     * Collection of instances belong to Spring Cloud Gateway.
     */
    @JsonProperty(value = "instances", access = JsonProperty.Access.WRITE_ONLY)
    private List<GatewayInstance> instances;

    /*
     * Properties of the Spring Cloud Gateway Operator.
     */
    @JsonProperty(value = "operatorProperties", access = JsonProperty.Access.WRITE_ONLY)
    private GatewayOperatorProperties operatorProperties;

    /**
     * Creates an instance of GatewayProperties class.
     */
    public GatewayProperties() {
    }

    /**
     * Get the provisioningState property: State of the Spring Cloud Gateway.
     * 
     * @return the provisioningState value.
     */
    public GatewayProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the publicProperty property: Indicates whether the Spring Cloud Gateway exposes endpoint.
     * 
     * @return the publicProperty value.
     */
    public Boolean publicProperty() {
        return this.publicProperty;
    }

    /**
     * Set the publicProperty property: Indicates whether the Spring Cloud Gateway exposes endpoint.
     * 
     * @param publicProperty the publicProperty value to set.
     * @return the GatewayProperties object itself.
     */
    public GatewayProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    /**
     * Get the url property: URL of the Spring Cloud Gateway, exposed when 'public' is true.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Get the httpsOnly property: Indicate if only https is allowed.
     * 
     * @return the httpsOnly value.
     */
    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    /**
     * Set the httpsOnly property: Indicate if only https is allowed.
     * 
     * @param httpsOnly the httpsOnly value to set.
     * @return the GatewayProperties object itself.
     */
    public GatewayProperties withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    /**
     * Get the ssoProperties property: Single sign-on related configuration.
     * 
     * @return the ssoProperties value.
     */
    public SsoProperties ssoProperties() {
        return this.ssoProperties;
    }

    /**
     * Set the ssoProperties property: Single sign-on related configuration.
     * 
     * @param ssoProperties the ssoProperties value to set.
     * @return the GatewayProperties object itself.
     */
    public GatewayProperties withSsoProperties(SsoProperties ssoProperties) {
        this.ssoProperties = ssoProperties;
        return this;
    }

    /**
     * Get the apiMetadataProperties property: API metadata property for Spring Cloud Gateway.
     * 
     * @return the apiMetadataProperties value.
     */
    public GatewayApiMetadataProperties apiMetadataProperties() {
        return this.apiMetadataProperties;
    }

    /**
     * Set the apiMetadataProperties property: API metadata property for Spring Cloud Gateway.
     * 
     * @param apiMetadataProperties the apiMetadataProperties value to set.
     * @return the GatewayProperties object itself.
     */
    public GatewayProperties withApiMetadataProperties(GatewayApiMetadataProperties apiMetadataProperties) {
        this.apiMetadataProperties = apiMetadataProperties;
        return this;
    }

    /**
     * Get the corsProperties property: Cross-Origin Resource Sharing property.
     * 
     * @return the corsProperties value.
     */
    public GatewayCorsProperties corsProperties() {
        return this.corsProperties;
    }

    /**
     * Set the corsProperties property: Cross-Origin Resource Sharing property.
     * 
     * @param corsProperties the corsProperties value to set.
     * @return the GatewayProperties object itself.
     */
    public GatewayProperties withCorsProperties(GatewayCorsProperties corsProperties) {
        this.corsProperties = corsProperties;
        return this;
    }

    /**
     * Get the clientAuth property: Client-Certification Authentication.
     * 
     * @return the clientAuth value.
     */
    public GatewayPropertiesClientAuth clientAuth() {
        return this.clientAuth;
    }

    /**
     * Set the clientAuth property: Client-Certification Authentication.
     * 
     * @param clientAuth the clientAuth value to set.
     * @return the GatewayProperties object itself.
     */
    public GatewayProperties withClientAuth(GatewayPropertiesClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    /**
     * Get the apms property: Collection of ApmReferences in service level.
     * 
     * @return the apms value.
     */
    public List<ApmReference> apms() {
        return this.apms;
    }

    /**
     * Set the apms property: Collection of ApmReferences in service level.
     * 
     * @param apms the apms value to set.
     * @return the GatewayProperties object itself.
     */
    public GatewayProperties withApms(List<ApmReference> apms) {
        this.apms = apms;
        return this;
    }

    /**
     * Get the environmentVariables property: Environment variables of Spring Cloud Gateway.
     * 
     * @return the environmentVariables value.
     */
    public GatewayPropertiesEnvironmentVariables environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables property: Environment variables of Spring Cloud Gateway.
     * 
     * @param environmentVariables the environmentVariables value to set.
     * @return the GatewayProperties object itself.
     */
    public GatewayProperties withEnvironmentVariables(GatewayPropertiesEnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory.
     * 
     * @return the resourceRequests value.
     */
    public GatewayResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Set the resourceRequests property: The requested resource quantity for required CPU and Memory.
     * 
     * @param resourceRequests the resourceRequests value to set.
     * @return the GatewayProperties object itself.
     */
    public GatewayProperties withResourceRequests(GatewayResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    /**
     * Get the instances property: Collection of instances belong to Spring Cloud Gateway.
     * 
     * @return the instances value.
     */
    public List<GatewayInstance> instances() {
        return this.instances;
    }

    /**
     * Get the operatorProperties property: Properties of the Spring Cloud Gateway Operator.
     * 
     * @return the operatorProperties value.
     */
    public GatewayOperatorProperties operatorProperties() {
        return this.operatorProperties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ssoProperties() != null) {
            ssoProperties().validate();
        }
        if (apiMetadataProperties() != null) {
            apiMetadataProperties().validate();
        }
        if (corsProperties() != null) {
            corsProperties().validate();
        }
        if (clientAuth() != null) {
            clientAuth().validate();
        }
        if (apms() != null) {
            apms().forEach(e -> e.validate());
        }
        if (environmentVariables() != null) {
            environmentVariables().validate();
        }
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
        if (operatorProperties() != null) {
            operatorProperties().validate();
        }
    }
}
