// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The DevToolPortalComponent model.
 */
@Immutable
public final class DevToolPortalComponent {
    /*
     * The name property.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The requested resource quantity for required CPU and Memory.
     */
    @JsonProperty(value = "resourceRequests", access = JsonProperty.Access.WRITE_ONLY)
    private DevToolPortalResourceRequests resourceRequests;

    /*
     * Collection of instances belong to Dev Tool Portal.
     */
    @JsonProperty(value = "instances", access = JsonProperty.Access.WRITE_ONLY)
    private List<DevToolPortalInstance> instances;

    /**
     * Creates an instance of DevToolPortalComponent class.
     */
    public DevToolPortalComponent() {
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory.
     * 
     * @return the resourceRequests value.
     */
    public DevToolPortalResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Get the instances property: Collection of instances belong to Dev Tool Portal.
     * 
     * @return the instances value.
     */
    public List<DevToolPortalInstance> instances() {
        return this.instances;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }
}
