// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appplatform.fluent.models.CustomizedAcceleratorResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The CustomizedAcceleratorResourceCollection model.
 */
@Fluent
public final class CustomizedAcceleratorResourceCollection {
    /*
     * The value property.
     */
    @JsonProperty(value = "value")
    private List<CustomizedAcceleratorResourceInner> value;

    /*
     * The nextLink property.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of CustomizedAcceleratorResourceCollection class.
     */
    public CustomizedAcceleratorResourceCollection() {
    }

    /**
     * Get the value property: The value property.
     * 
     * @return the value value.
     */
    public List<CustomizedAcceleratorResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     * 
     * @param value the value value to set.
     * @return the CustomizedAcceleratorResourceCollection object itself.
     */
    public CustomizedAcceleratorResourceCollection withValue(List<CustomizedAcceleratorResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The nextLink property.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The nextLink property.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CustomizedAcceleratorResourceCollection object itself.
     */
    public CustomizedAcceleratorResourceCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
