// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Properties of certificate imported from key vault.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("ContentCertificate")
@Fluent
public final class ContentCertificateProperties extends CertificateProperties {
    /*
     * The content of uploaded certificate.
     */
    @JsonProperty(value = "content")
    private String content;

    /**
     * Creates an instance of ContentCertificateProperties class.
     */
    public ContentCertificateProperties() {
    }

    /**
     * Get the content property: The content of uploaded certificate.
     * 
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of uploaded certificate.
     * 
     * @param content the content value to set.
     * @return the ContentCertificateProperties object itself.
     */
    public ContentCertificateProperties withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
