// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * App resource properties payload.
 */
@Fluent
public final class AppResourceProperties {
    /*
     * Indicates whether the App exposes public endpoint
     */
    @JsonProperty(value = "public")
    private Boolean publicProperty;

    /*
     * URL of the App
     */
    @JsonProperty(value = "url", access = JsonProperty.Access.WRITE_ONLY)
    private String url;

    /*
     * Collection of addons
     */
    @JsonProperty(value = "addonConfigs")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Map<String, Object>> addonConfigs;

    /*
     * Provisioning state of the App
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private AppResourceProvisioningState provisioningState;

    /*
     * Fully qualified dns Name.
     */
    @JsonProperty(value = "fqdn", access = JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    /*
     * Indicate if only https is allowed.
     */
    @JsonProperty(value = "httpsOnly")
    private Boolean httpsOnly;

    /*
     * Temporary disk settings
     */
    @JsonProperty(value = "temporaryDisk")
    private TemporaryDisk temporaryDisk;

    /*
     * Persistent disk settings
     */
    @JsonProperty(value = "persistentDisk")
    private PersistentDisk persistentDisk;

    /*
     * List of custom persistent disks
     */
    @JsonProperty(value = "customPersistentDisks")
    private List<CustomPersistentDiskResource> customPersistentDisks;

    /*
     * Indicate if end to end TLS is enabled.
     */
    @JsonProperty(value = "enableEndToEndTLS")
    private Boolean enableEndToEndTls;

    /*
     * Collection of loaded certificates
     */
    @JsonProperty(value = "loadedCertificates")
    private List<LoadedCertificate> loadedCertificates;

    /*
     * Additional App settings in vnet injection instance
     */
    @JsonProperty(value = "vnetAddons")
    private AppVNetAddons vnetAddons;

    /*
     * App ingress settings payload.
     */
    @JsonProperty(value = "ingressSettings")
    private IngressSettings ingressSettings;

    /**
     * Creates an instance of AppResourceProperties class.
     */
    public AppResourceProperties() {
    }

    /**
     * Get the publicProperty property: Indicates whether the App exposes public endpoint.
     * 
     * @return the publicProperty value.
     */
    public Boolean publicProperty() {
        return this.publicProperty;
    }

    /**
     * Set the publicProperty property: Indicates whether the App exposes public endpoint.
     * 
     * @param publicProperty the publicProperty value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    /**
     * Get the url property: URL of the App.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Get the addonConfigs property: Collection of addons.
     * 
     * @return the addonConfigs value.
     */
    public Map<String, Map<String, Object>> addonConfigs() {
        return this.addonConfigs;
    }

    /**
     * Set the addonConfigs property: Collection of addons.
     * 
     * @param addonConfigs the addonConfigs value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withAddonConfigs(Map<String, Map<String, Object>> addonConfigs) {
        this.addonConfigs = addonConfigs;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the App.
     * 
     * @return the provisioningState value.
     */
    public AppResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the fqdn property: Fully qualified dns Name.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the httpsOnly property: Indicate if only https is allowed.
     * 
     * @return the httpsOnly value.
     */
    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    /**
     * Set the httpsOnly property: Indicate if only https is allowed.
     * 
     * @param httpsOnly the httpsOnly value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    /**
     * Get the temporaryDisk property: Temporary disk settings.
     * 
     * @return the temporaryDisk value.
     */
    public TemporaryDisk temporaryDisk() {
        return this.temporaryDisk;
    }

    /**
     * Set the temporaryDisk property: Temporary disk settings.
     * 
     * @param temporaryDisk the temporaryDisk value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withTemporaryDisk(TemporaryDisk temporaryDisk) {
        this.temporaryDisk = temporaryDisk;
        return this;
    }

    /**
     * Get the persistentDisk property: Persistent disk settings.
     * 
     * @return the persistentDisk value.
     */
    public PersistentDisk persistentDisk() {
        return this.persistentDisk;
    }

    /**
     * Set the persistentDisk property: Persistent disk settings.
     * 
     * @param persistentDisk the persistentDisk value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withPersistentDisk(PersistentDisk persistentDisk) {
        this.persistentDisk = persistentDisk;
        return this;
    }

    /**
     * Get the customPersistentDisks property: List of custom persistent disks.
     * 
     * @return the customPersistentDisks value.
     */
    public List<CustomPersistentDiskResource> customPersistentDisks() {
        return this.customPersistentDisks;
    }

    /**
     * Set the customPersistentDisks property: List of custom persistent disks.
     * 
     * @param customPersistentDisks the customPersistentDisks value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withCustomPersistentDisks(List<CustomPersistentDiskResource> customPersistentDisks) {
        this.customPersistentDisks = customPersistentDisks;
        return this;
    }

    /**
     * Get the enableEndToEndTls property: Indicate if end to end TLS is enabled.
     * 
     * @return the enableEndToEndTls value.
     */
    public Boolean enableEndToEndTls() {
        return this.enableEndToEndTls;
    }

    /**
     * Set the enableEndToEndTls property: Indicate if end to end TLS is enabled.
     * 
     * @param enableEndToEndTls the enableEndToEndTls value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withEnableEndToEndTls(Boolean enableEndToEndTls) {
        this.enableEndToEndTls = enableEndToEndTls;
        return this;
    }

    /**
     * Get the loadedCertificates property: Collection of loaded certificates.
     * 
     * @return the loadedCertificates value.
     */
    public List<LoadedCertificate> loadedCertificates() {
        return this.loadedCertificates;
    }

    /**
     * Set the loadedCertificates property: Collection of loaded certificates.
     * 
     * @param loadedCertificates the loadedCertificates value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withLoadedCertificates(List<LoadedCertificate> loadedCertificates) {
        this.loadedCertificates = loadedCertificates;
        return this;
    }

    /**
     * Get the vnetAddons property: Additional App settings in vnet injection instance.
     * 
     * @return the vnetAddons value.
     */
    public AppVNetAddons vnetAddons() {
        return this.vnetAddons;
    }

    /**
     * Set the vnetAddons property: Additional App settings in vnet injection instance.
     * 
     * @param vnetAddons the vnetAddons value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withVnetAddons(AppVNetAddons vnetAddons) {
        this.vnetAddons = vnetAddons;
        return this;
    }

    /**
     * Get the ingressSettings property: App ingress settings payload.
     * 
     * @return the ingressSettings value.
     */
    public IngressSettings ingressSettings() {
        return this.ingressSettings;
    }

    /**
     * Set the ingressSettings property: App ingress settings payload.
     * 
     * @param ingressSettings the ingressSettings value to set.
     * @return the AppResourceProperties object itself.
     */
    public AppResourceProperties withIngressSettings(IngressSettings ingressSettings) {
        this.ingressSettings = ingressSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (temporaryDisk() != null) {
            temporaryDisk().validate();
        }
        if (persistentDisk() != null) {
            persistentDisk().validate();
        }
        if (customPersistentDisks() != null) {
            customPersistentDisks().forEach(e -> e.validate());
        }
        if (loadedCertificates() != null) {
            loadedCertificates().forEach(e -> e.validate());
        }
        if (vnetAddons() != null) {
            vnetAddons().validate();
        }
        if (ingressSettings() != null) {
            ingressSettings().validate();
        }
    }
}
