// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appplatform.fluent.models.ApmResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Object that includes an array of APM resources and a possible link for next set.
 */
@Fluent
public final class ApmResourceCollection {
    /*
     * Collection of APM resources
     */
    @JsonProperty(value = "value")
    private List<ApmResourceInner> value;

    /*
     * URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of ApmResourceCollection class.
     */
    public ApmResourceCollection() {
    }

    /**
     * Get the value property: Collection of APM resources.
     * 
     * @return the value value.
     */
    public List<ApmResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of APM resources.
     * 
     * @param value the value value to set.
     * @return the ApmResourceCollection object itself.
     */
    public ApmResourceCollection withValue(List<ApmResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL client should use to fetch the next page (per server side paging).
     * It's null for now, added for future use.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ApmResourceCollection object itself.
     */
    public ApmResourceCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
