// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The AcceleratorGitRepository model.
 */
@Fluent
public final class AcceleratorGitRepository {
    /*
     * Git repository URL for the accelerator.
     */
    @JsonProperty(value = "url", required = true)
    private String url;

    /*
     * Interval for checking for updates to Git or image repository.
     */
    @JsonProperty(value = "intervalInSeconds")
    private Integer intervalInSeconds;

    /*
     * Git repository branch to be used.
     */
    @JsonProperty(value = "branch")
    private String branch;

    /*
     * Git repository commit to be used.
     */
    @JsonProperty(value = "commit")
    private String commit;

    /*
     * Git repository tag to be used.
     */
    @JsonProperty(value = "gitTag")
    private String gitTag;

    /*
     * Properties of the auth setting payload.
     */
    @JsonProperty(value = "authSetting", required = true)
    private AcceleratorAuthSetting authSetting;

    /*
     * Folder path inside the git repository to consider as the root of the accelerator or fragment.
     */
    @JsonProperty(value = "subPath")
    private String subPath;

    /**
     * Creates an instance of AcceleratorGitRepository class.
     */
    public AcceleratorGitRepository() {
    }

    /**
     * Get the url property: Git repository URL for the accelerator.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: Git repository URL for the accelerator.
     * 
     * @param url the url value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the intervalInSeconds property: Interval for checking for updates to Git or image repository.
     * 
     * @return the intervalInSeconds value.
     */
    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    /**
     * Set the intervalInSeconds property: Interval for checking for updates to Git or image repository.
     * 
     * @param intervalInSeconds the intervalInSeconds value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withIntervalInSeconds(Integer intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    /**
     * Get the branch property: Git repository branch to be used.
     * 
     * @return the branch value.
     */
    public String branch() {
        return this.branch;
    }

    /**
     * Set the branch property: Git repository branch to be used.
     * 
     * @param branch the branch value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    /**
     * Get the commit property: Git repository commit to be used.
     * 
     * @return the commit value.
     */
    public String commit() {
        return this.commit;
    }

    /**
     * Set the commit property: Git repository commit to be used.
     * 
     * @param commit the commit value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withCommit(String commit) {
        this.commit = commit;
        return this;
    }

    /**
     * Get the gitTag property: Git repository tag to be used.
     * 
     * @return the gitTag value.
     */
    public String gitTag() {
        return this.gitTag;
    }

    /**
     * Set the gitTag property: Git repository tag to be used.
     * 
     * @param gitTag the gitTag value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withGitTag(String gitTag) {
        this.gitTag = gitTag;
        return this;
    }

    /**
     * Get the authSetting property: Properties of the auth setting payload.
     * 
     * @return the authSetting value.
     */
    public AcceleratorAuthSetting authSetting() {
        return this.authSetting;
    }

    /**
     * Set the authSetting property: Properties of the auth setting payload.
     * 
     * @param authSetting the authSetting value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withAuthSetting(AcceleratorAuthSetting authSetting) {
        this.authSetting = authSetting;
        return this;
    }

    /**
     * Get the subPath property: Folder path inside the git repository to consider as the root of the accelerator or
     * fragment.
     * 
     * @return the subPath value.
     */
    public String subPath() {
        return this.subPath;
    }

    /**
     * Set the subPath property: Folder path inside the git repository to consider as the root of the accelerator or
     * fragment.
     * 
     * @param subPath the subPath value to set.
     * @return the AcceleratorGitRepository object itself.
     */
    public AcceleratorGitRepository withSubPath(String subPath) {
        this.subPath = subPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (url() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property url in model AcceleratorGitRepository"));
        }
        if (authSetting() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property authSetting in model AcceleratorGitRepository"));
        } else {
            authSetting().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AcceleratorGitRepository.class);
}
