// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Supported server version.
 */
@Fluent
public final class SupportedServerVersionInner {
    /*
     * The raw server version value which could be passed to deployment CRUD operations.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * The server name.
     */
    @JsonProperty(value = "server")
    private String server;

    /*
     * The Server version.
     */
    @JsonProperty(value = "version")
    private String version;

    /**
     * Creates an instance of SupportedServerVersionInner class.
     */
    public SupportedServerVersionInner() {
    }

    /**
     * Get the value property: The raw server version value which could be passed to deployment CRUD operations.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The raw server version value which could be passed to deployment CRUD operations.
     * 
     * @param value the value value to set.
     * @return the SupportedServerVersionInner object itself.
     */
    public SupportedServerVersionInner withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the server property: The server name.
     * 
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Set the server property: The server name.
     * 
     * @param server the server value to set.
     * @return the SupportedServerVersionInner object itself.
     */
    public SupportedServerVersionInner withServer(String server) {
        this.server = server;
        return this;
    }

    /**
     * Get the version property: The Server version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The Server version.
     * 
     * @param version the version value to set.
     * @return the SupportedServerVersionInner object itself.
     */
    public SupportedServerVersionInner withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
