// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appplatform.models.BindingResourceProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Binding resource payload.
 */
@Fluent
public final class BindingResourceInner extends ProxyResource {
    /*
     * Properties of the Binding resource
     */
    @JsonProperty(value = "properties")
    private BindingResourceProperties properties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Creates an instance of BindingResourceInner class.
     */
    public BindingResourceInner() {
    }

    /**
     * Get the properties property: Properties of the Binding resource.
     * 
     * @return the properties value.
     */
    public BindingResourceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the Binding resource.
     * 
     * @param properties the properties value to set.
     * @return the BindingResourceInner object itself.
     */
    public BindingResourceInner withProperties(BindingResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
