// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appplatform.fluent.models.GatewayRouteConfigResourceInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in GatewayRouteConfigsClient.
 */
public interface GatewayRouteConfigsClient {
    /**
     * Get the Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Spring Cloud Gateway route configs along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<GatewayRouteConfigResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName,
        String gatewayName, String routeConfigName);

    /**
     * Get the Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Spring Cloud Gateway route configs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GatewayRouteConfigResourceInner> getAsync(String resourceGroupName, String serviceName, String gatewayName,
        String routeConfigName);

    /**
     * Get the Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Spring Cloud Gateway route configs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<GatewayRouteConfigResourceInner> getWithResponse(String resourceGroupName, String serviceName,
        String gatewayName, String routeConfigName, Context context);

    /**
     * Get the Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Spring Cloud Gateway route configs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayRouteConfigResourceInner get(String resourceGroupName, String serviceName, String gatewayName,
        String routeConfigName);

    /**
     * Create the default Spring Cloud Gateway route configs or update the existing Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param gatewayRouteConfigResource The Spring Cloud Gateway route config for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return spring Cloud Gateway route config resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName,
        String gatewayName, String routeConfigName, GatewayRouteConfigResourceInner gatewayRouteConfigResource);

    /**
     * Create the default Spring Cloud Gateway route configs or update the existing Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param gatewayRouteConfigResource The Spring Cloud Gateway route config for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of spring Cloud Gateway route config resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GatewayRouteConfigResourceInner>, GatewayRouteConfigResourceInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String serviceName, String gatewayName, String routeConfigName,
        GatewayRouteConfigResourceInner gatewayRouteConfigResource);

    /**
     * Create the default Spring Cloud Gateway route configs or update the existing Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param gatewayRouteConfigResource The Spring Cloud Gateway route config for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of spring Cloud Gateway route config resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayRouteConfigResourceInner>, GatewayRouteConfigResourceInner> beginCreateOrUpdate(
        String resourceGroupName, String serviceName, String gatewayName, String routeConfigName,
        GatewayRouteConfigResourceInner gatewayRouteConfigResource);

    /**
     * Create the default Spring Cloud Gateway route configs or update the existing Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param gatewayRouteConfigResource The Spring Cloud Gateway route config for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of spring Cloud Gateway route config resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayRouteConfigResourceInner>, GatewayRouteConfigResourceInner> beginCreateOrUpdate(
        String resourceGroupName, String serviceName, String gatewayName, String routeConfigName,
        GatewayRouteConfigResourceInner gatewayRouteConfigResource, Context context);

    /**
     * Create the default Spring Cloud Gateway route configs or update the existing Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param gatewayRouteConfigResource The Spring Cloud Gateway route config for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return spring Cloud Gateway route config resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GatewayRouteConfigResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName,
        String gatewayName, String routeConfigName, GatewayRouteConfigResourceInner gatewayRouteConfigResource);

    /**
     * Create the default Spring Cloud Gateway route configs or update the existing Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param gatewayRouteConfigResource The Spring Cloud Gateway route config for the create or update operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return spring Cloud Gateway route config resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayRouteConfigResourceInner createOrUpdate(String resourceGroupName, String serviceName, String gatewayName,
        String routeConfigName, GatewayRouteConfigResourceInner gatewayRouteConfigResource);

    /**
     * Create the default Spring Cloud Gateway route configs or update the existing Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param gatewayRouteConfigResource The Spring Cloud Gateway route config for the create or update operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return spring Cloud Gateway route config resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayRouteConfigResourceInner createOrUpdate(String resourceGroupName, String serviceName, String gatewayName,
        String routeConfigName, GatewayRouteConfigResourceInner gatewayRouteConfigResource, Context context);

    /**
     * Delete the Spring Cloud Gateway route config.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName,
        String gatewayName, String routeConfigName);

    /**
     * Delete the Spring Cloud Gateway route config.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName,
        String gatewayName, String routeConfigName);

    /**
     * Delete the Spring Cloud Gateway route config.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String gatewayName,
        String routeConfigName);

    /**
     * Delete the Spring Cloud Gateway route config.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String gatewayName,
        String routeConfigName, Context context);

    /**
     * Delete the Spring Cloud Gateway route config.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String gatewayName, String routeConfigName);

    /**
     * Delete the Spring Cloud Gateway route config.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String gatewayName, String routeConfigName);

    /**
     * Delete the Spring Cloud Gateway route config.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String serviceName, String gatewayName, String routeConfigName,
        Context context);

    /**
     * Handle requests to list all Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of Spring Cloud Gateway route config resources and a possible link for next
     * set as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<GatewayRouteConfigResourceInner> listAsync(String resourceGroupName, String serviceName,
        String gatewayName);

    /**
     * Handle requests to list all Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of Spring Cloud Gateway route config resources and a possible link for next
     * set as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GatewayRouteConfigResourceInner> list(String resourceGroupName, String serviceName,
        String gatewayName);

    /**
     * Handle requests to list all Spring Cloud Gateway route configs.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return object that includes an array of Spring Cloud Gateway route config resources and a possible link for next
     * set as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<GatewayRouteConfigResourceInner> list(String resourceGroupName, String serviceName,
        String gatewayName, Context context);
}
