// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appplatform.fluent.models.CertificateResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Collection compose of certificate resources list and a possible link for next page. */
@Fluent
public final class CertificateResourceCollection {
    /*
     * The certificate resources list.
     */
    @JsonProperty(value = "value")
    private List<CertificateResourceInner> value;

    /*
     * The link to next page of certificate list.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: The certificate resources list.
     *
     * @return the value value.
     */
    public List<CertificateResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The certificate resources list.
     *
     * @param value the value value to set.
     * @return the CertificateResourceCollection object itself.
     */
    public CertificateResourceCollection withValue(List<CertificateResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to next page of certificate list.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to next page of certificate list.
     *
     * @param nextLink the nextLink value to set.
     * @return the CertificateResourceCollection object itself.
     */
    public CertificateResourceCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
