// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Test keys payload. */
@Fluent
public final class TestKeys {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(TestKeys.class);

    /*
     * Primary key
     */
    @JsonProperty(value = "primaryKey")
    private String primaryKey;

    /*
     * Secondary key
     */
    @JsonProperty(value = "secondaryKey")
    private String secondaryKey;

    /*
     * Primary test endpoint
     */
    @JsonProperty(value = "primaryTestEndpoint")
    private String primaryTestEndpoint;

    /*
     * Secondary test endpoint
     */
    @JsonProperty(value = "secondaryTestEndpoint")
    private String secondaryTestEndpoint;

    /*
     * Indicates whether the test endpoint feature enabled or not
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /**
     * Get the primaryKey property: Primary key.
     *
     * @return the primaryKey value.
     */
    public String primaryKey() {
        return this.primaryKey;
    }

    /**
     * Set the primaryKey property: Primary key.
     *
     * @param primaryKey the primaryKey value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    /**
     * Get the secondaryKey property: Secondary key.
     *
     * @return the secondaryKey value.
     */
    public String secondaryKey() {
        return this.secondaryKey;
    }

    /**
     * Set the secondaryKey property: Secondary key.
     *
     * @param secondaryKey the secondaryKey value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    /**
     * Get the primaryTestEndpoint property: Primary test endpoint.
     *
     * @return the primaryTestEndpoint value.
     */
    public String primaryTestEndpoint() {
        return this.primaryTestEndpoint;
    }

    /**
     * Set the primaryTestEndpoint property: Primary test endpoint.
     *
     * @param primaryTestEndpoint the primaryTestEndpoint value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withPrimaryTestEndpoint(String primaryTestEndpoint) {
        this.primaryTestEndpoint = primaryTestEndpoint;
        return this;
    }

    /**
     * Get the secondaryTestEndpoint property: Secondary test endpoint.
     *
     * @return the secondaryTestEndpoint value.
     */
    public String secondaryTestEndpoint() {
        return this.secondaryTestEndpoint;
    }

    /**
     * Set the secondaryTestEndpoint property: Secondary test endpoint.
     *
     * @param secondaryTestEndpoint the secondaryTestEndpoint value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withSecondaryTestEndpoint(String secondaryTestEndpoint) {
        this.secondaryTestEndpoint = secondaryTestEndpoint;
        return this;
    }

    /**
     * Get the enabled property: Indicates whether the test endpoint feature enabled or not.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether the test endpoint feature enabled or not.
     *
     * @param enabled the enabled value to set.
     * @return the TestKeys object itself.
     */
    public TestKeys withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
