/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.ListQueuesSegmentResponse;
import com.azure.storage.queue.implementation.models.ServicesGetPropertiesHeaders;
import com.azure.storage.queue.implementation.models.ServicesGetStatisticsHeaders;
import com.azure.storage.queue.implementation.models.ServicesListQueuesSegmentHeaders;
import com.azure.storage.queue.implementation.models.ServicesListQueuesSegmentNextHeaders;
import com.azure.storage.queue.implementation.models.ServicesSetPropertiesHeaders;
import com.azure.storage.queue.models.QueueItem;
import com.azure.storage.queue.models.QueueServiceProperties;
import com.azure.storage.queue.models.QueueServiceStatistics;
import com.azure.storage.queue.models.QueueStorageException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private final ServicesService service;
    private final AzureQueueStorageImpl client;

    ServicesImpl(AzureQueueStorageImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, queueServiceProperties, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, queueServiceProperties, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId) {
        return this.setPropertiesWithResponseAsync(queueServiceProperties, timeout, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(QueueServiceProperties queueServiceProperties, Integer timeout, String requestId, Context context) {
        return this.setPropertiesWithResponseAsync(queueServiceProperties, timeout, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, QueueServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, QueueServiceProperties>> getPropertiesWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), "service", "properties", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceProperties> getPropertiesAsync(Integer timeout, String requestId) {
        return this.getPropertiesWithResponseAsync(timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((QueueServiceProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceProperties> getPropertiesAsync(Integer timeout, String requestId, Context context) {
        return this.getPropertiesWithResponseAsync(timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((QueueServiceProperties)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, QueueServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getStatistics(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetStatisticsHeaders, QueueServiceStatistics>> getStatisticsWithResponseAsync(Integer timeout, String requestId, Context context) {
        String restype = "service";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatistics(this.client.getUrl(), "service", "stats", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceStatistics> getStatisticsAsync(Integer timeout, String requestId) {
        return this.getStatisticsWithResponseAsync(timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((QueueServiceStatistics)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueServiceStatistics> getStatisticsAsync(Integer timeout, String requestId, Context context) {
        return this.getStatisticsWithResponseAsync(timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((QueueServiceStatistics)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listQueuesSegment(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), (Object)((ServicesListQueuesSegmentHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentSinglePageAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.listQueuesSegment(this.client.getUrl(), "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), (Object)((ServicesListQueuesSegmentHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueItem> listQueuesSegmentAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId) {
        return new PagedFlux(() -> this.listQueuesSegmentSinglePageAsync(prefix, marker, maxresults, include, timeout, requestId), nextLink -> this.listQueuesSegmentNextSinglePageAsync((String)nextLink, requestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueItem> listQueuesSegmentAsync(String prefix, String marker, Integer maxresults, List<String> include, Integer timeout, String requestId, Context context) {
        return new PagedFlux(() -> this.listQueuesSegmentSinglePageAsync(prefix, marker, maxresults, include, timeout, requestId, context), nextLink -> this.listQueuesSegmentNextSinglePageAsync((String)nextLink, requestId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentNextSinglePageAsync(String nextLink, String requestId) {
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listQueuesSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), (Object)((ServicesListQueuesSegmentNextHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<QueueItem>> listQueuesSegmentNextSinglePageAsync(String nextLink, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.listQueuesSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(), requestId, "application/xml", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueuesSegmentResponse)res.getValue()).getQueueItems(), ((ListQueuesSegmentResponse)res.getValue()).getNextMarker(), (Object)((ServicesListQueuesSegmentNextHeaders)res.getDeserializedHeaders())));
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageSer")
    public static interface ServicesService {
        @Put(value="/")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") QueueServiceProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesGetPropertiesHeaders, QueueServiceProperties>> getProperties(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesGetStatisticsHeaders, QueueServiceStatistics>> getStatistics(@HostParam(value="url") String var1, @QueryParam(value="restype") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesListQueuesSegmentHeaders, ListQueuesSegmentResponse>> listQueuesSegment(@HostParam(value="url") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<ResponseBase<ServicesListQueuesSegmentNextHeaders, ListQueuesSegmentResponse>> listQueuesSegmentNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

