/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class UserDelegationKey
implements XmlSerializable<UserDelegationKey> {
    private String signedObjectId;
    private String signedTenantId;
    private OffsetDateTime signedStart;
    private OffsetDateTime signedExpiry;
    private String signedService;
    private String signedVersion;
    private String value;

    public String getSignedObjectId() {
        return this.signedObjectId;
    }

    public UserDelegationKey setSignedObjectId(String signedObjectId) {
        this.signedObjectId = signedObjectId;
        return this;
    }

    public String getSignedTenantId() {
        return this.signedTenantId;
    }

    public UserDelegationKey setSignedTenantId(String signedTenantId) {
        this.signedTenantId = signedTenantId;
        return this;
    }

    public OffsetDateTime getSignedStart() {
        return this.signedStart;
    }

    public UserDelegationKey setSignedStart(OffsetDateTime signedStart) {
        this.signedStart = signedStart;
        return this;
    }

    public OffsetDateTime getSignedExpiry() {
        return this.signedExpiry;
    }

    public UserDelegationKey setSignedExpiry(OffsetDateTime signedExpiry) {
        this.signedExpiry = signedExpiry;
        return this;
    }

    public String getSignedService() {
        return this.signedService;
    }

    public UserDelegationKey setSignedService(String signedService) {
        this.signedService = signedService;
        return this;
    }

    public String getSignedVersion() {
        return this.signedVersion;
    }

    public UserDelegationKey setSignedVersion(String signedVersion) {
        this.signedVersion = signedVersion;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public UserDelegationKey setValue(String value) {
        this.value = value;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "UserDelegationKey" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("SignedOid", this.signedObjectId);
        xmlWriter.writeStringElement("SignedTid", this.signedTenantId);
        xmlWriter.writeStringElement("SignedStart", this.signedStart == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.signedStart));
        xmlWriter.writeStringElement("SignedExpiry", this.signedExpiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.signedExpiry));
        xmlWriter.writeStringElement("SignedService", this.signedService);
        xmlWriter.writeStringElement("SignedVersion", this.signedVersion);
        xmlWriter.writeStringElement("Value", this.value);
        return xmlWriter.writeEndElement();
    }

    public static UserDelegationKey fromXml(XmlReader xmlReader) throws XMLStreamException {
        return UserDelegationKey.fromXml(xmlReader, null);
    }

    public static UserDelegationKey fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "UserDelegationKey" : rootElementName;
        return (UserDelegationKey)xmlReader.readObject(finalRootElementName, reader -> {
            UserDelegationKey deserializedUserDelegationKey = new UserDelegationKey();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SignedOid".equals(elementName.getLocalPart())) {
                    deserializedUserDelegationKey.signedObjectId = reader.getStringElement();
                    continue;
                }
                if ("SignedTid".equals(elementName.getLocalPart())) {
                    deserializedUserDelegationKey.signedTenantId = reader.getStringElement();
                    continue;
                }
                if ("SignedStart".equals(elementName.getLocalPart())) {
                    deserializedUserDelegationKey.signedStart = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("SignedExpiry".equals(elementName.getLocalPart())) {
                    deserializedUserDelegationKey.signedExpiry = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("SignedService".equals(elementName.getLocalPart())) {
                    deserializedUserDelegationKey.signedService = reader.getStringElement();
                    continue;
                }
                if ("SignedVersion".equals(elementName.getLocalPart())) {
                    deserializedUserDelegationKey.signedVersion = reader.getStringElement();
                    continue;
                }
                if ("Value".equals(elementName.getLocalPart())) {
                    deserializedUserDelegationKey.value = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedUserDelegationKey;
        });
    }
}

