/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.storage.file.share.models.ShareSmbSettingsEncryptionInTransit;
import com.azure.storage.file.share.models.SmbMultichannel;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareSmbSettings
implements XmlSerializable<ShareSmbSettings> {
    private SmbMultichannel multichannel;
    private ShareSmbSettingsEncryptionInTransit encryptionInTransit;

    public SmbMultichannel getMultichannel() {
        return this.multichannel;
    }

    public ShareSmbSettings setMultichannel(SmbMultichannel multichannel) {
        this.multichannel = multichannel;
        return this;
    }

    public ShareSmbSettingsEncryptionInTransit getEncryptionInTransit() {
        return this.encryptionInTransit;
    }

    public ShareSmbSettings setEncryptionInTransit(ShareSmbSettingsEncryptionInTransit encryptionInTransit) {
        this.encryptionInTransit = encryptionInTransit;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "SMB" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml((XmlSerializable)this.multichannel, "Multichannel");
        xmlWriter.writeXml((XmlSerializable)this.encryptionInTransit, "EncryptionInTransit");
        return xmlWriter.writeEndElement();
    }

    public static ShareSmbSettings fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareSmbSettings.fromXml(xmlReader, null);
    }

    public static ShareSmbSettings fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "SMB" : rootElementName;
        return (ShareSmbSettings)xmlReader.readObject(finalRootElementName, reader -> {
            ShareSmbSettings deserializedShareSmbSettings = new ShareSmbSettings();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Multichannel".equals(elementName.getLocalPart())) {
                    deserializedShareSmbSettings.multichannel = SmbMultichannel.fromXml(reader, "Multichannel");
                    continue;
                }
                if ("EncryptionInTransit".equals(elementName.getLocalPart())) {
                    deserializedShareSmbSettings.encryptionInTransit = ShareSmbSettingsEncryptionInTransit.fromXml(reader, "EncryptionInTransit");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareSmbSettings;
        });
    }
}

