/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.storage.file.share.models.ShareNfsSettings;
import com.azure.storage.file.share.models.ShareSmbSettings;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareProtocolSettings
implements XmlSerializable<ShareProtocolSettings> {
    private ShareSmbSettings smb;
    private ShareNfsSettings nfs;

    public ShareSmbSettings getSmb() {
        return this.smb;
    }

    public ShareProtocolSettings setSmb(ShareSmbSettings smb) {
        this.smb = smb;
        return this;
    }

    public ShareNfsSettings getNfs() {
        return this.nfs;
    }

    public ShareProtocolSettings setNfs(ShareNfsSettings nfs) {
        this.nfs = nfs;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "ProtocolSettings" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml((XmlSerializable)this.smb, "SMB");
        xmlWriter.writeXml((XmlSerializable)this.nfs, "NFS");
        return xmlWriter.writeEndElement();
    }

    public static ShareProtocolSettings fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareProtocolSettings.fromXml(xmlReader, null);
    }

    public static ShareProtocolSettings fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "ProtocolSettings" : rootElementName;
        return (ShareProtocolSettings)xmlReader.readObject(finalRootElementName, reader -> {
            ShareProtocolSettings deserializedShareProtocolSettings = new ShareProtocolSettings();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SMB".equals(elementName.getLocalPart())) {
                    deserializedShareProtocolSettings.smb = ShareSmbSettings.fromXml(reader, "SMB");
                    continue;
                }
                if ("NFS".equals(elementName.getLocalPart())) {
                    deserializedShareProtocolSettings.nfs = ShareNfsSettings.fromXml(reader, "NFS");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareProtocolSettings;
        });
    }
}

