/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.util;

import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.TimeAndFormat;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.models.UserDelegationKey;
import com.azure.storage.file.share.sas.ShareFileSasPermission;
import com.azure.storage.file.share.sas.ShareSasPermission;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.function.Consumer;

public class ShareSasImplUtil {
    private static final String SAS_FILE_CONSTANT = "f";
    private static final String SAS_SHARE_CONSTANT = "s";
    private static final ClientLogger LOGGER = new ClientLogger(ShareSasImplUtil.class);
    private static final String VERSION = (String)Configuration.getGlobalConfiguration().get("AZURE_STORAGE_SAS_SERVICE_VERSION", (Object)ShareServiceVersion.getLatest().getVersion());
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String shareName;
    private String filePath;
    private String resource;
    private String identifier;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private String delegatedUserObjectId;

    public ShareSasImplUtil(ShareServiceSasSignatureValues sasValues, String shareName) {
        this(sasValues, shareName, null);
    }

    public ShareSasImplUtil(ShareServiceSasSignatureValues sasValues, String shareName, String filePath) {
        Objects.requireNonNull(sasValues);
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.shareName = shareName;
        this.filePath = filePath;
        this.identifier = sasValues.getIdentifier();
        this.cacheControl = sasValues.getCacheControl();
        this.contentDisposition = sasValues.getContentDisposition();
        this.contentEncoding = sasValues.getContentEncoding();
        this.contentLanguage = sasValues.getContentLanguage();
        this.contentType = sasValues.getContentType();
        this.delegatedUserObjectId = sasValues.getDelegatedUserObjectId();
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials, Context context) {
        return this.generateSas(storageSharedKeyCredentials, null, context);
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials, Consumer<String> stringToSignHandler, Context context) {
        StorageImplUtils.assertNotNull((String)"storageSharedKeyCredentials", (Object)storageSharedKeyCredentials);
        this.ensureState();
        String canonicalName = this.getCanonicalName(storageSharedKeyCredentials.getAccountName());
        String stringToSign = this.stringToSign(canonicalName);
        StorageImplUtils.logStringToSign((ClientLogger)LOGGER, (String)stringToSign, (Context)context);
        String signature = storageSharedKeyCredentials.computeHmac256(stringToSign);
        if (stringToSignHandler != null) {
            stringToSignHandler.accept(stringToSign);
        }
        return this.encode(null, signature);
    }

    public String generateUserDelegationSas(UserDelegationKey delegationKey, String accountName, Consumer<String> stringToSignHandler, Context context) {
        StorageImplUtils.assertNotNull((String)"delegationKey", (Object)delegationKey);
        StorageImplUtils.assertNotNull((String)"accountName", (Object)accountName);
        this.ensureState();
        String canonicalName = this.getCanonicalName(accountName);
        String stringToSign = this.stringToSign(delegationKey, canonicalName);
        StorageImplUtils.logStringToSign((ClientLogger)LOGGER, (String)stringToSign, (Context)context);
        String signature = StorageImplUtils.computeHMac256((String)delegationKey.getValue(), (String)stringToSign);
        if (stringToSignHandler != null) {
            stringToSignHandler.accept(stringToSign);
        }
        return this.encode(delegationKey, signature);
    }

    private String encode(UserDelegationKey userDelegationKey, String signature) {
        StringBuilder sb = new StringBuilder();
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sv", (Object)VERSION);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"spr", (Object)this.protocol);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"st", (Object)SasImplUtils.formatQueryParameterDate((TimeAndFormat)new TimeAndFormat(this.startTime, null)));
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"se", (Object)SasImplUtils.formatQueryParameterDate((TimeAndFormat)new TimeAndFormat(this.expiryTime, null)));
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sip", (Object)this.sasIpRange);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"si", (Object)this.identifier);
        if (userDelegationKey != null) {
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"skoid", (Object)userDelegationKey.getSignedObjectId());
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sktid", (Object)userDelegationKey.getSignedTenantId());
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"skt", (Object)SasImplUtils.formatQueryParameterDate((TimeAndFormat)new TimeAndFormat(userDelegationKey.getSignedStart(), null)));
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"ske", (Object)SasImplUtils.formatQueryParameterDate((TimeAndFormat)new TimeAndFormat(userDelegationKey.getSignedExpiry(), null)));
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sks", (Object)userDelegationKey.getSignedService());
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"skv", (Object)userDelegationKey.getSignedVersion());
            SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sduoid", (Object)this.delegatedUserObjectId);
        }
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sr", (Object)this.resource);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sp", (Object)this.permissions);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sig", (Object)signature);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rscc", (Object)this.cacheControl);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rscd", (Object)this.contentDisposition);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rsce", (Object)this.contentEncoding);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rscl", (Object)this.contentLanguage);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rsct", (Object)this.contentType);
        return sb.toString();
    }

    private void ensureState() {
        if (this.identifier == null && (this.expiryTime == null || this.permissions == null)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("If identifier is not set, expiry time and permissions must be set"));
        }
        this.resource = CoreUtils.isNullOrEmpty((CharSequence)this.filePath) ? SAS_SHARE_CONSTANT : SAS_FILE_CONSTANT;
        if (this.permissions != null) {
            switch (this.resource) {
                case "f": {
                    this.permissions = ShareFileSasPermission.parse(this.permissions).toString();
                    break;
                }
                case "s": {
                    this.permissions = ShareSasPermission.parse(this.permissions).toString();
                    break;
                }
                default: {
                    LOGGER.info("Not re-parsing permissions. Resource type '{}' is unknown.", new Object[]{this.resource});
                }
            }
        }
    }

    private String getCanonicalName(String account) {
        return !CoreUtils.isNullOrEmpty((CharSequence)this.filePath) ? "/file/" + account + "/" + this.shareName + "/" + this.filePath.replace('\\', '/') : "/file/" + account + "/" + this.shareName;
    }

    private String stringToSign(String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION == null ? "" : VERSION, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }

    private String stringToSign(UserDelegationKey key, String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, key.getSignedObjectId() == null ? "" : key.getSignedObjectId(), key.getSignedTenantId() == null ? "" : key.getSignedTenantId(), key.getSignedStart() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedStart()), key.getSignedExpiry() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedExpiry()), key.getSignedService() == null ? "" : key.getSignedService(), key.getSignedVersion() == null ? "" : key.getSignedVersion(), "", this.delegatedUserObjectId == null ? "" : this.delegatedUserObjectId, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION == null ? "" : VERSION, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }
}

