/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.azure.storage.file.share.models.ShareRootSquash;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SharesGetPropertiesHeaders {
    private Long xMsShareIncludedBurstIops;
    private LeaseStatusType xMsLeaseStatus;
    private Boolean xMsSharePaidBurstingEnabled;
    private LeaseStateType xMsLeaseState;
    private DateTimeRfc1123 lastModified;
    private Long xMsShareMaxBurstCreditsForIops;
    private DateTimeRfc1123 xMsAccessTierChangeTime;
    private Integer xMsShareProvisionedIngressMbps;
    private Integer xMsShareProvisionedBandwidthMibps;
    private Integer xMsShareQuota;
    private Long xMsSharePaidBurstingMaxBandwidthMibps;
    private String xMsAccessTier;
    private String xMsEnabledProtocols;
    private LeaseDurationType xMsLeaseDuration;
    private Boolean xMsEnableSmbDirectoryLease;
    private String xMsRequestId;
    private String xMsAccessTierTransitionState;
    private DateTimeRfc1123 xMsShareNextAllowedQuotaDowngradeTime;
    private Integer xMsShareProvisionedIops;
    private String xMsVersion;
    private DateTimeRfc1123 xMsShareNextAllowedProvisionedBandwidthDowngradeTime;
    private ShareRootSquash xMsRootSquash;
    private Boolean xMsEnableSnapshotVirtualDirectoryAccess;
    private Map<String, String> xMsMeta;
    private DateTimeRfc1123 xMsShareNextAllowedProvisionedIopsDowngradeTime;
    private DateTimeRfc1123 date;
    private Long xMsSharePaidBurstingMaxIops;
    private String eTag;
    private Integer xMsShareProvisionedEgressMbps;
    private static final HttpHeaderName X_MS_SHARE_INCLUDED_BURST_IOPS = HttpHeaderName.fromString((String)"x-ms-share-included-burst-iops");
    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString((String)"x-ms-lease-status");
    private static final HttpHeaderName X_MS_SHARE_PAID_BURSTING_ENABLED = HttpHeaderName.fromString((String)"x-ms-share-paid-bursting-enabled");
    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString((String)"x-ms-lease-state");
    private static final HttpHeaderName X_MS_SHARE_MAX_BURST_CREDITS_FOR_IOPS = HttpHeaderName.fromString((String)"x-ms-share-max-burst-credits-for-iops");
    private static final HttpHeaderName X_MS_ACCESS_TIER_CHANGE_TIME = HttpHeaderName.fromString((String)"x-ms-access-tier-change-time");
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_INGRESS_MBPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-ingress-mbps");
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_BANDWIDTH_MIBPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-bandwidth-mibps");
    private static final HttpHeaderName X_MS_SHARE_QUOTA = HttpHeaderName.fromString((String)"x-ms-share-quota");
    private static final HttpHeaderName X_MS_SHARE_PAID_BURSTING_MAX_BANDWIDTH_MIBPS = HttpHeaderName.fromString((String)"x-ms-share-paid-bursting-max-bandwidth-mibps");
    private static final HttpHeaderName X_MS_ACCESS_TIER = HttpHeaderName.fromString((String)"x-ms-access-tier");
    private static final HttpHeaderName X_MS_ENABLED_PROTOCOLS = HttpHeaderName.fromString((String)"x-ms-enabled-protocols");
    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString((String)"x-ms-lease-duration");
    private static final HttpHeaderName X_MS_ENABLE_SMB_DIRECTORY_LEASE = HttpHeaderName.fromString((String)"x-ms-enable-smb-directory-lease");
    private static final HttpHeaderName X_MS_ACCESS_TIER_TRANSITION_STATE = HttpHeaderName.fromString((String)"x-ms-access-tier-transition-state");
    private static final HttpHeaderName X_MS_SHARE_NEXT_ALLOWED_QUOTA_DOWNGRADE_TIME = HttpHeaderName.fromString((String)"x-ms-share-next-allowed-quota-downgrade-time");
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_IOPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-iops");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_BANDWIDTH_DOWNGRADE_TIME = HttpHeaderName.fromString((String)"x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time");
    private static final HttpHeaderName X_MS_ROOT_SQUASH = HttpHeaderName.fromString((String)"x-ms-root-squash");
    private static final HttpHeaderName X_MS_ENABLE_SNAPSHOT_VIRTUAL_DIRECTORY_ACCESS = HttpHeaderName.fromString((String)"x-ms-enable-snapshot-virtual-directory-access");
    private static final HttpHeaderName X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_IOPS_DOWNGRADE_TIME = HttpHeaderName.fromString((String)"x-ms-share-next-allowed-provisioned-iops-downgrade-time");
    private static final HttpHeaderName X_MS_SHARE_PAID_BURSTING_MAX_IOPS = HttpHeaderName.fromString((String)"x-ms-share-paid-bursting-max-iops");
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_EGRESS_MBPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-egress-mbps");

    public SharesGetPropertiesHeaders(HttpHeaders rawHeaders) {
        String xMsShareIncludedBurstIops = rawHeaders.getValue(X_MS_SHARE_INCLUDED_BURST_IOPS);
        this.xMsShareIncludedBurstIops = xMsShareIncludedBurstIops != null ? Long.valueOf(Long.parseLong(xMsShareIncludedBurstIops)) : null;
        String xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS);
        this.xMsLeaseStatus = xMsLeaseStatus != null ? LeaseStatusType.fromString(xMsLeaseStatus) : null;
        String xMsSharePaidBurstingEnabled = rawHeaders.getValue(X_MS_SHARE_PAID_BURSTING_ENABLED);
        this.xMsSharePaidBurstingEnabled = xMsSharePaidBurstingEnabled != null ? Boolean.valueOf(Boolean.parseBoolean(xMsSharePaidBurstingEnabled)) : null;
        String xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE);
        this.xMsLeaseState = xMsLeaseState != null ? LeaseStateType.fromString(xMsLeaseState) : null;
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        String xMsShareMaxBurstCreditsForIops = rawHeaders.getValue(X_MS_SHARE_MAX_BURST_CREDITS_FOR_IOPS);
        this.xMsShareMaxBurstCreditsForIops = xMsShareMaxBurstCreditsForIops != null ? Long.valueOf(Long.parseLong(xMsShareMaxBurstCreditsForIops)) : null;
        String xMsAccessTierChangeTime = rawHeaders.getValue(X_MS_ACCESS_TIER_CHANGE_TIME);
        this.xMsAccessTierChangeTime = xMsAccessTierChangeTime != null ? new DateTimeRfc1123(xMsAccessTierChangeTime) : null;
        String xMsShareProvisionedIngressMbps = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_INGRESS_MBPS);
        this.xMsShareProvisionedIngressMbps = xMsShareProvisionedIngressMbps != null ? Integer.valueOf(Integer.parseInt(xMsShareProvisionedIngressMbps)) : null;
        String xMsShareProvisionedBandwidthMibps = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_BANDWIDTH_MIBPS);
        this.xMsShareProvisionedBandwidthMibps = xMsShareProvisionedBandwidthMibps != null ? Integer.valueOf(Integer.parseInt(xMsShareProvisionedBandwidthMibps)) : null;
        String xMsShareQuota = rawHeaders.getValue(X_MS_SHARE_QUOTA);
        this.xMsShareQuota = xMsShareQuota != null ? Integer.valueOf(Integer.parseInt(xMsShareQuota)) : null;
        String xMsSharePaidBurstingMaxBandwidthMibps = rawHeaders.getValue(X_MS_SHARE_PAID_BURSTING_MAX_BANDWIDTH_MIBPS);
        this.xMsSharePaidBurstingMaxBandwidthMibps = xMsSharePaidBurstingMaxBandwidthMibps != null ? Long.valueOf(Long.parseLong(xMsSharePaidBurstingMaxBandwidthMibps)) : null;
        this.xMsAccessTier = rawHeaders.getValue(X_MS_ACCESS_TIER);
        this.xMsEnabledProtocols = rawHeaders.getValue(X_MS_ENABLED_PROTOCOLS);
        String xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION);
        this.xMsLeaseDuration = xMsLeaseDuration != null ? LeaseDurationType.fromString(xMsLeaseDuration) : null;
        String xMsEnableSmbDirectoryLease = rawHeaders.getValue(X_MS_ENABLE_SMB_DIRECTORY_LEASE);
        this.xMsEnableSmbDirectoryLease = xMsEnableSmbDirectoryLease != null ? Boolean.valueOf(Boolean.parseBoolean(xMsEnableSmbDirectoryLease)) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsAccessTierTransitionState = rawHeaders.getValue(X_MS_ACCESS_TIER_TRANSITION_STATE);
        String xMsShareNextAllowedQuotaDowngradeTime = rawHeaders.getValue(X_MS_SHARE_NEXT_ALLOWED_QUOTA_DOWNGRADE_TIME);
        this.xMsShareNextAllowedQuotaDowngradeTime = xMsShareNextAllowedQuotaDowngradeTime != null ? new DateTimeRfc1123(xMsShareNextAllowedQuotaDowngradeTime) : null;
        String xMsShareProvisionedIops = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_IOPS);
        this.xMsShareProvisionedIops = xMsShareProvisionedIops != null ? Integer.valueOf(Integer.parseInt(xMsShareProvisionedIops)) : null;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsShareNextAllowedProvisionedBandwidthDowngradeTime = rawHeaders.getValue(X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_BANDWIDTH_DOWNGRADE_TIME);
        this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime = xMsShareNextAllowedProvisionedBandwidthDowngradeTime != null ? new DateTimeRfc1123(xMsShareNextAllowedProvisionedBandwidthDowngradeTime) : null;
        String xMsRootSquash = rawHeaders.getValue(X_MS_ROOT_SQUASH);
        this.xMsRootSquash = xMsRootSquash != null ? ShareRootSquash.fromString(xMsRootSquash) : null;
        String xMsEnableSnapshotVirtualDirectoryAccess = rawHeaders.getValue(X_MS_ENABLE_SNAPSHOT_VIRTUAL_DIRECTORY_ACCESS);
        this.xMsEnableSnapshotVirtualDirectoryAccess = xMsEnableSnapshotVirtualDirectoryAccess != null ? Boolean.valueOf(Boolean.parseBoolean(xMsEnableSnapshotVirtualDirectoryAccess)) : null;
        String xMsShareNextAllowedProvisionedIopsDowngradeTime = rawHeaders.getValue(X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_IOPS_DOWNGRADE_TIME);
        this.xMsShareNextAllowedProvisionedIopsDowngradeTime = xMsShareNextAllowedProvisionedIopsDowngradeTime != null ? new DateTimeRfc1123(xMsShareNextAllowedProvisionedIopsDowngradeTime) : null;
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
        String xMsSharePaidBurstingMaxIops = rawHeaders.getValue(X_MS_SHARE_PAID_BURSTING_MAX_IOPS);
        this.xMsSharePaidBurstingMaxIops = xMsSharePaidBurstingMaxIops != null ? Long.valueOf(Long.parseLong(xMsSharePaidBurstingMaxIops)) : null;
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsShareProvisionedEgressMbps = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_EGRESS_MBPS);
        this.xMsShareProvisionedEgressMbps = xMsShareProvisionedEgressMbps != null ? Integer.valueOf(Integer.parseInt(xMsShareProvisionedEgressMbps)) : null;
        LinkedHashMap<String, String> xMsMetaHeaderCollection = new LinkedHashMap<String, String>();
        rawHeaders.stream().forEach(header -> {
            String headerName = header.getName();
            if (headerName.startsWith("x-ms-meta-")) {
                xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
            }
        });
        this.xMsMeta = xMsMetaHeaderCollection;
    }

    public Long getXMsShareIncludedBurstIops() {
        return this.xMsShareIncludedBurstIops;
    }

    public SharesGetPropertiesHeaders setXMsShareIncludedBurstIops(Long xMsShareIncludedBurstIops) {
        this.xMsShareIncludedBurstIops = xMsShareIncludedBurstIops;
        return this;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public SharesGetPropertiesHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public Boolean isXMsSharePaidBurstingEnabled() {
        return this.xMsSharePaidBurstingEnabled;
    }

    public SharesGetPropertiesHeaders setXMsSharePaidBurstingEnabled(Boolean xMsSharePaidBurstingEnabled) {
        this.xMsSharePaidBurstingEnabled = xMsSharePaidBurstingEnabled;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public SharesGetPropertiesHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public SharesGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Long getXMsShareMaxBurstCreditsForIops() {
        return this.xMsShareMaxBurstCreditsForIops;
    }

    public SharesGetPropertiesHeaders setXMsShareMaxBurstCreditsForIops(Long xMsShareMaxBurstCreditsForIops) {
        this.xMsShareMaxBurstCreditsForIops = xMsShareMaxBurstCreditsForIops;
        return this;
    }

    public OffsetDateTime getXMsAccessTierChangeTime() {
        if (this.xMsAccessTierChangeTime == null) {
            return null;
        }
        return this.xMsAccessTierChangeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsAccessTierChangeTime(OffsetDateTime xMsAccessTierChangeTime) {
        this.xMsAccessTierChangeTime = xMsAccessTierChangeTime == null ? null : new DateTimeRfc1123(xMsAccessTierChangeTime);
        return this;
    }

    public Integer getXMsShareProvisionedIngressMbps() {
        return this.xMsShareProvisionedIngressMbps;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedIngressMbps(Integer xMsShareProvisionedIngressMbps) {
        this.xMsShareProvisionedIngressMbps = xMsShareProvisionedIngressMbps;
        return this;
    }

    public Integer getXMsShareProvisionedBandwidthMibps() {
        return this.xMsShareProvisionedBandwidthMibps;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedBandwidthMibps(Integer xMsShareProvisionedBandwidthMibps) {
        this.xMsShareProvisionedBandwidthMibps = xMsShareProvisionedBandwidthMibps;
        return this;
    }

    public Integer getXMsShareQuota() {
        return this.xMsShareQuota;
    }

    public SharesGetPropertiesHeaders setXMsShareQuota(Integer xMsShareQuota) {
        this.xMsShareQuota = xMsShareQuota;
        return this;
    }

    public Long getXMsSharePaidBurstingMaxBandwidthMibps() {
        return this.xMsSharePaidBurstingMaxBandwidthMibps;
    }

    public SharesGetPropertiesHeaders setXMsSharePaidBurstingMaxBandwidthMibps(Long xMsSharePaidBurstingMaxBandwidthMibps) {
        this.xMsSharePaidBurstingMaxBandwidthMibps = xMsSharePaidBurstingMaxBandwidthMibps;
        return this;
    }

    public String getXMsAccessTier() {
        return this.xMsAccessTier;
    }

    public SharesGetPropertiesHeaders setXMsAccessTier(String xMsAccessTier) {
        this.xMsAccessTier = xMsAccessTier;
        return this;
    }

    public String getXMsEnabledProtocols() {
        return this.xMsEnabledProtocols;
    }

    public SharesGetPropertiesHeaders setXMsEnabledProtocols(String xMsEnabledProtocols) {
        this.xMsEnabledProtocols = xMsEnabledProtocols;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public SharesGetPropertiesHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public Boolean isXMsEnableSmbDirectoryLease() {
        return this.xMsEnableSmbDirectoryLease;
    }

    public SharesGetPropertiesHeaders setXMsEnableSmbDirectoryLease(Boolean xMsEnableSmbDirectoryLease) {
        this.xMsEnableSmbDirectoryLease = xMsEnableSmbDirectoryLease;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public SharesGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsAccessTierTransitionState() {
        return this.xMsAccessTierTransitionState;
    }

    public SharesGetPropertiesHeaders setXMsAccessTierTransitionState(String xMsAccessTierTransitionState) {
        this.xMsAccessTierTransitionState = xMsAccessTierTransitionState;
        return this;
    }

    public OffsetDateTime getXMsShareNextAllowedQuotaDowngradeTime() {
        if (this.xMsShareNextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedQuotaDowngradeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsShareNextAllowedQuotaDowngradeTime(OffsetDateTime xMsShareNextAllowedQuotaDowngradeTime) {
        this.xMsShareNextAllowedQuotaDowngradeTime = xMsShareNextAllowedQuotaDowngradeTime == null ? null : new DateTimeRfc1123(xMsShareNextAllowedQuotaDowngradeTime);
        return this;
    }

    public Integer getXMsShareProvisionedIops() {
        return this.xMsShareProvisionedIops;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedIops(Integer xMsShareProvisionedIops) {
        this.xMsShareProvisionedIops = xMsShareProvisionedIops;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public SharesGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public OffsetDateTime getXMsShareNextAllowedProvisionedBandwidthDowngradeTime() {
        if (this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsShareNextAllowedProvisionedBandwidthDowngradeTime(OffsetDateTime xMsShareNextAllowedProvisionedBandwidthDowngradeTime) {
        this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime = xMsShareNextAllowedProvisionedBandwidthDowngradeTime == null ? null : new DateTimeRfc1123(xMsShareNextAllowedProvisionedBandwidthDowngradeTime);
        return this;
    }

    public ShareRootSquash getXMsRootSquash() {
        return this.xMsRootSquash;
    }

    public SharesGetPropertiesHeaders setXMsRootSquash(ShareRootSquash xMsRootSquash) {
        this.xMsRootSquash = xMsRootSquash;
        return this;
    }

    public Boolean isXMsEnableSnapshotVirtualDirectoryAccess() {
        return this.xMsEnableSnapshotVirtualDirectoryAccess;
    }

    public SharesGetPropertiesHeaders setXMsEnableSnapshotVirtualDirectoryAccess(Boolean xMsEnableSnapshotVirtualDirectoryAccess) {
        this.xMsEnableSnapshotVirtualDirectoryAccess = xMsEnableSnapshotVirtualDirectoryAccess;
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public SharesGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getXMsShareNextAllowedProvisionedIopsDowngradeTime() {
        if (this.xMsShareNextAllowedProvisionedIopsDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedProvisionedIopsDowngradeTime.getDateTime();
    }

    public SharesGetPropertiesHeaders setXMsShareNextAllowedProvisionedIopsDowngradeTime(OffsetDateTime xMsShareNextAllowedProvisionedIopsDowngradeTime) {
        this.xMsShareNextAllowedProvisionedIopsDowngradeTime = xMsShareNextAllowedProvisionedIopsDowngradeTime == null ? null : new DateTimeRfc1123(xMsShareNextAllowedProvisionedIopsDowngradeTime);
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public SharesGetPropertiesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public Long getXMsSharePaidBurstingMaxIops() {
        return this.xMsSharePaidBurstingMaxIops;
    }

    public SharesGetPropertiesHeaders setXMsSharePaidBurstingMaxIops(Long xMsSharePaidBurstingMaxIops) {
        this.xMsSharePaidBurstingMaxIops = xMsSharePaidBurstingMaxIops;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SharesGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Integer getXMsShareProvisionedEgressMbps() {
        return this.xMsShareProvisionedEgressMbps;
    }

    public SharesGetPropertiesHeaders setXMsShareProvisionedEgressMbps(Integer xMsShareProvisionedEgressMbps) {
        this.xMsShareProvisionedEgressMbps = xMsShareProvisionedEgressMbps;
        return this;
    }
}

