/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class SharesBreakLeaseHeaders {
    private String xMsVersion;
    private String eTag;
    private Integer xMsLeaseTime;
    private String xMsLeaseId;
    private DateTimeRfc1123 lastModified;
    private String xMsRequestId;
    private String xMsClientRequestId;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_LEASE_TIME = HttpHeaderName.fromString((String)"x-ms-lease-time");
    private static final HttpHeaderName X_MS_LEASE_ID = HttpHeaderName.fromString((String)"x-ms-lease-id");

    public SharesBreakLeaseHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String xMsLeaseTime = rawHeaders.getValue(X_MS_LEASE_TIME);
        this.xMsLeaseTime = xMsLeaseTime != null ? Integer.valueOf(Integer.parseInt(xMsLeaseTime)) : null;
        this.xMsLeaseId = rawHeaders.getValue(X_MS_LEASE_ID);
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public SharesBreakLeaseHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SharesBreakLeaseHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Integer getXMsLeaseTime() {
        return this.xMsLeaseTime;
    }

    public SharesBreakLeaseHeaders setXMsLeaseTime(Integer xMsLeaseTime) {
        this.xMsLeaseTime = xMsLeaseTime;
        return this;
    }

    public String getXMsLeaseId() {
        return this.xMsLeaseId;
    }

    public SharesBreakLeaseHeaders setXMsLeaseId(String xMsLeaseId) {
        this.xMsLeaseId = xMsLeaseId;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public SharesBreakLeaseHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public SharesBreakLeaseHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public SharesBreakLeaseHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public SharesBreakLeaseHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

