/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.AccountSasImplUtil;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.share.implementation.models.KeyInfo;
import com.azure.storage.file.share.implementation.models.ListSharesIncludeType;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.models.ListSharesOptions;
import com.azure.storage.file.share.models.ShareItem;
import com.azure.storage.file.share.models.ShareServiceProperties;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.models.UserDelegationKey;
import com.azure.storage.file.share.options.ShareCreateOptions;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@ServiceClient(builder=ShareServiceClientBuilder.class)
public final class ShareServiceClient {
    private static final ClientLogger LOGGER = new ClientLogger(ShareServiceClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;

    ShareServiceClient(AzureFileStorageImpl azureFileStorage, String accountName, ShareServiceVersion serviceVersion, AzureSasCredential sasToken) {
        this.azureFileStorageClient = azureFileStorage;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.sasToken = sasToken;
    }

    public String getFileServiceUrl() {
        return this.azureFileStorageClient.getUrl();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public ShareClient getShareClient(String shareName) {
        return new ShareClient(this.azureFileStorageClient, shareName, null, this.accountName, this.serviceVersion, this.sasToken);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareItem> listShares() {
        return this.listShares(null, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareItem> listShares(ListSharesOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        String prefix = options != null ? options.getPrefix() : null;
        Integer maxResultsPerPage = options != null ? options.getMaxResultsPerPage() : null;
        ArrayList<ListSharesIncludeType> include = new ArrayList<ListSharesIncludeType>();
        if (options != null) {
            if (options.isIncludeDeleted()) {
                include.add(ListSharesIncludeType.DELETED);
            }
            if (options.isIncludeMetadata()) {
                include.add(ListSharesIncludeType.METADATA);
            }
            if (options.isIncludeSnapshots()) {
                include.add(ListSharesIncludeType.SNAPSHOTS);
            }
        }
        BiFunction<String, Integer, PagedResponse> retriever = (nextMarker, pageSize) -> {
            Callable<PagedResponse> operation = () -> this.azureFileStorageClient.getServices().listSharesSegmentNoCustomHeadersSinglePage(prefix, (String)nextMarker, pageSize == null ? maxResultsPerPage : pageSize, (List<ListSharesIncludeType>)include, null, finalContext);
            PagedResponse response = (PagedResponse)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
            List value = response.getValue() == null ? Collections.emptyList() : response.getValue().stream().map(ModelHelper::populateShareItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, (String)response.getContinuationToken(), (Object)ModelHelper.transformListSharesHeaders(response.getHeaders()));
        };
        return new PagedIterable(pageSize -> (PagedResponse)retriever.apply((String)null, (Integer)pageSize), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareServiceProperties getProperties() {
        return (ShareServiceProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareServiceProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getServices().getPropertiesNoCustomHeadersWithResponse(null, finalContext);
        Response response = (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
        return new SimpleResponse(response, (Object)((ShareServiceProperties)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(ShareServiceProperties properties) {
        this.setPropertiesWithResponse(properties, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesWithResponse(ShareServiceProperties properties, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getServices().setPropertiesNoCustomHeadersWithResponse(properties, null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareClient createShare(String shareName) {
        return (ShareClient)this.createShareWithResponse(shareName, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareClient> createShareWithResponse(String shareName, Map<String, String> metadata, Integer quotaInGB, Duration timeout, Context context) {
        ShareClient shareClient = this.getShareClient(shareName);
        return new SimpleResponse(shareClient.createWithResponse(metadata, quotaInGB, timeout, context), (Object)shareClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareClient> createShareWithResponse(String shareName, ShareCreateOptions options, Duration timeout, Context context) {
        ShareClient shareClient = this.getShareClient(shareName);
        return new SimpleResponse(shareClient.createWithResponse(options, timeout, context), (Object)shareClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteShare(String shareName) {
        this.deleteShareWithResponse(shareName, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteShareWithResponse(String shareName, String snapshot, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        DeleteSnapshotsOptionType deleteSnapshots = CoreUtils.isNullOrEmpty((CharSequence)snapshot) ? DeleteSnapshotsOptionType.INCLUDE : null;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().deleteNoCustomHeadersWithResponse(shareName, snapshot, null, deleteSnapshots, null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.generateAccountSas(accountSasSignatureValues, Context.NONE);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.generateAccountSas(accountSasSignatureValues, null, context);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new AccountSasImplUtil(accountSasSignatureValues, null).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareClient undeleteShare(String deletedShareName, String deletedShareVersion) {
        return (ShareClient)this.undeleteShareWithResponse(deletedShareName, deletedShareVersion, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareClient> undeleteShareWithResponse(String deletedShareName, String deletedShareVersion, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().restoreNoCustomHeadersWithResponse(deletedShareName, null, null, deletedShareName, deletedShareVersion, finalContext);
        return new SimpleResponse((Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class), (Object)this.getShareClient(deletedShareName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserDelegationKey getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return (UserDelegationKey)this.getUserDelegationKeyWithResponse(start, expiry, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UserDelegationKey> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"expiry", (Object)expiry);
        if (start != null && !start.isBefore(expiry)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("`start` must be null or a datetime before `expiry`."));
        }
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getServices().getUserDelegationKeyWithResponse(new KeyInfo().setStart(start == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(start)).setExpiry(Constants.ISO_8601_UTC_DATE_FORMATTER.format(expiry)), null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
        return new SimpleResponse((Response)response, (Object)((UserDelegationKey)response.getValue()));
    }
}

