/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareFileClientBuilder;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.ListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.ListFilesIncludeType;
import com.azure.storage.file.share.implementation.models.ListHandlesResponse;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.FilePosixProperties;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.NtfsFileAttributes;
import com.azure.storage.file.share.models.ShareDirectoryInfo;
import com.azure.storage.file.share.models.ShareDirectoryProperties;
import com.azure.storage.file.share.models.ShareDirectorySetMetadataInfo;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileInfo;
import com.azure.storage.file.share.models.ShareFileItem;
import com.azure.storage.file.share.models.ShareFilePermission;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.options.ShareDirectoryCreateOptions;
import com.azure.storage.file.share.options.ShareDirectorySetPropertiesOptions;
import com.azure.storage.file.share.options.ShareFileRenameOptions;
import com.azure.storage.file.share.options.ShareListFilesAndDirectoriesOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

@ServiceClient(builder=ShareFileClientBuilder.class)
public class ShareDirectoryClient {
    private static final ClientLogger LOGGER = new ClientLogger(ShareDirectoryClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String directoryPath;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;
    private final String directoryUrl;

    ShareDirectoryClient(AzureFileStorageImpl azureFileStorageClient, String shareName, String directoryPath, String snapshot, String accountName, ShareServiceVersion serviceVersion, AzureSasCredential sasToken) {
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        Objects.requireNonNull(directoryPath);
        this.shareName = shareName;
        this.directoryPath = directoryPath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = azureFileStorageClient;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.sasToken = sasToken;
        StringBuilder directoryUrlString = new StringBuilder(azureFileStorageClient.getUrl()).append("/").append(shareName).append("/").append(directoryPath);
        if (snapshot != null) {
            directoryUrlString.append("?sharesnapshot=").append(snapshot);
        }
        this.directoryUrl = directoryUrlString.toString();
    }

    public String getDirectoryUrl() {
        return this.directoryUrl;
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public ShareFileClient getFileClient(String fileName) {
        String filePath = this.directoryPath + "/" + fileName;
        if (this.directoryPath.isEmpty()) {
            filePath = fileName;
        }
        return new ShareFileClient(new ShareFileAsyncClient(this.azureFileStorageClient, this.shareName, filePath, null, this.accountName, this.serviceVersion, this.sasToken), this.azureFileStorageClient, this.shareName, filePath, null, this.accountName, this.serviceVersion, this.sasToken);
    }

    public ShareDirectoryClient getSubdirectoryClient(String subdirectoryName) {
        boolean needPathDelimiter = !this.directoryPath.isEmpty() && !this.directoryPath.endsWith("/");
        String subDirectoryPath = this.directoryPath + (needPathDelimiter ? "/" : "") + subdirectoryName;
        return new ShareDirectoryClient(this.azureFileStorageClient, this.shareName, subDirectoryPath, this.snapshot, this.accountName, this.serviceVersion, this.sasToken);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        try {
            Response<ShareDirectoryProperties> response = this.getPropertiesWithResponse(timeout, context);
            return new SimpleResponse(response, (Object)true);
        }
        catch (RuntimeException e) {
            if (ModelHelper.checkDoesNotExistStatusCode(e) && e instanceof HttpResponseException) {
                HttpResponse response = ((HttpResponseException)e).getResponse();
                return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryInfo create() {
        return (ShareDirectoryInfo)this.createWithResponse(null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryInfo> createWithResponse(FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        return this.createWithResponse(new ShareDirectoryCreateOptions().setSmbProperties(smbProperties).setFilePermission(filePermission).setMetadata(metadata), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryInfo> createWithResponse(ShareDirectoryCreateOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareDirectoryCreateOptions finalOptions = options == null ? new ShareDirectoryCreateOptions() : options;
        FileSmbProperties smbProperties = finalOptions.getSmbProperties() == null ? new FileSmbProperties() : finalOptions.getSmbProperties();
        FilePosixProperties fileposixProperties = finalOptions.getPosixProperties() == null ? new FilePosixProperties() : finalOptions.getPosixProperties();
        ModelHelper.validateFilePermissionAndKey(finalOptions.getFilePermission(), smbProperties.getFilePermissionKey());
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getDirectories().createWithResponse(this.shareName, this.directoryPath, null, finalOptions.getMetadata(), finalOptions.getFilePermission(), finalOptions.getFilePermissionFormat(), smbProperties.getFilePermissionKey(), smbProperties.getNtfsFileAttributesString(), smbProperties.getFileCreationTimeString(), smbProperties.getFileLastWriteTimeString(), smbProperties.getFileChangeTimeString(), fileposixProperties.getOwner(), fileposixProperties.getGroup(), fileposixProperties.getFileMode(), null, finalContext);
        return ModelHelper.mapShareDirectoryInfo((ResponseBase<DirectoriesCreateHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryInfo createIfNotExists() {
        return (ShareDirectoryInfo)this.createIfNotExistsWithResponse(new ShareDirectoryCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryInfo> createIfNotExistsWithResponse(ShareDirectoryCreateOptions options, Duration timeout, Context context) {
        try {
            return this.createWithResponse(options, timeout, context);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 409 && e.getErrorCode().equals((Object)ShareErrorCode.RESOURCE_ALREADY_EXISTS)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), null);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getDirectories().deleteNoCustomHeadersWithResponse(this.shareName, this.directoryPath, null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return (Boolean)this.deleteIfExistsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(Duration timeout, Context context) {
        try {
            Response<Void> response = this.deleteWithResponse(timeout, context);
            return new SimpleResponse(response, (Object)true);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 404 && e.getErrorCode().equals((Object)ShareErrorCode.RESOURCE_NOT_FOUND)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryProperties getProperties() {
        return (ShareDirectoryProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getDirectories().getPropertiesWithResponse(this.shareName, this.directoryPath, this.snapshot, null, finalContext);
        return ModelHelper.mapShareDirectoryPropertiesResponse((ResponseBase<DirectoriesGetPropertiesHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryInfo setProperties(FileSmbProperties smbProperties, String filePermission) {
        return (ShareDirectoryInfo)this.setPropertiesWithResponse(smbProperties, filePermission, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryInfo> setPropertiesWithResponse(FileSmbProperties smbProperties, String filePermission, Duration timeout, Context context) {
        return this.setPropertiesWithResponse(new ShareDirectorySetPropertiesOptions().setSmbProperties(smbProperties).setFilePermissions(new ShareFilePermission().setPermission(filePermission)), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryInfo> setPropertiesWithResponse(ShareDirectorySetPropertiesOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareDirectorySetPropertiesOptions finalOptions = options == null ? new ShareDirectorySetPropertiesOptions() : options;
        FileSmbProperties smbProperties = finalOptions.getSmbProperties() == null ? new FileSmbProperties() : finalOptions.getSmbProperties();
        FilePosixProperties fileposixProperties = finalOptions.getPosixProperties() == null ? new FilePosixProperties() : finalOptions.getPosixProperties();
        ShareFilePermission filePermission = finalOptions.getFilePermissions() == null ? new ShareFilePermission() : finalOptions.getFilePermissions();
        ModelHelper.validateFilePermissionAndKey(filePermission.getPermission(), smbProperties.getFilePermissionKey());
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getDirectories().setPropertiesWithResponse(this.shareName, this.directoryPath, null, filePermission.getPermission(), filePermission.getPermissionFormat(), smbProperties.getFilePermissionKey(), smbProperties.getNtfsFileAttributesString(), smbProperties.getFileCreationTimeString(), smbProperties.getFileLastWriteTimeString(), smbProperties.getFileChangeTimeString(), fileposixProperties.getOwner(), fileposixProperties.getGroup(), fileposixProperties.getFileMode(), finalContext);
        return ModelHelper.mapSetPropertiesResponse((ResponseBase<DirectoriesSetPropertiesHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectorySetMetadataInfo setMetadata(Map<String, String> metadata) {
        return (ShareDirectorySetMetadataInfo)this.setMetadataWithResponse(metadata, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectorySetMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getDirectories().setMetadataWithResponse(this.shareName, this.directoryPath, null, metadata, finalContext);
        return ModelHelper.setShareDirectoryMetadataResponse((ResponseBase<DirectoriesSetMetadataHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileItem> listFilesAndDirectories() {
        return this.listFilesAndDirectories(null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileItem> listFilesAndDirectories(String prefix, Integer maxResultsPerPage, Duration timeout, Context context) {
        return this.listFilesAndDirectories(new ShareListFilesAndDirectoriesOptions().setPrefix(prefix).setMaxResultsPerPage(maxResultsPerPage), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileItem> listFilesAndDirectories(ShareListFilesAndDirectoriesOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareListFilesAndDirectoriesOptions modifiedOptions = options == null ? new ShareListFilesAndDirectoriesOptions() : options;
        ArrayList<ListFilesIncludeType> includeTypes = new ArrayList<ListFilesIncludeType>();
        if (modifiedOptions.includeAttributes()) {
            includeTypes.add(ListFilesIncludeType.ATTRIBUTES);
        }
        if (modifiedOptions.includeETag()) {
            includeTypes.add(ListFilesIncludeType.ETAG);
        }
        if (modifiedOptions.includeTimestamps()) {
            includeTypes.add(ListFilesIncludeType.TIMESTAMPS);
        }
        if (modifiedOptions.includePermissionKey()) {
            includeTypes.add(ListFilesIncludeType.PERMISSION_KEY);
        }
        ArrayList<ListFilesIncludeType> finalIncludeTypes = includeTypes.isEmpty() ? null : includeTypes;
        BiFunction<String, Integer, PagedResponse> retriever = (marker, pageSize) -> {
            Callable<Response> operation = () -> this.azureFileStorageClient.getDirectories().listFilesAndDirectoriesSegmentNoCustomHeadersWithResponse(this.shareName, this.directoryPath, modifiedOptions.getPrefix(), this.snapshot, (String)marker, pageSize == null ? modifiedOptions.getMaxResultsPerPage() : pageSize, null, (List<ListFilesIncludeType>)finalIncludeTypes, modifiedOptions.includeExtendedInfo(), finalContext);
            Response response = (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ModelHelper.convertResponseAndGetNumOfResults((Response<ListFilesAndDirectoriesSegmentResponse>)response), ((ListFilesAndDirectoriesSegmentResponse)response.getValue()).getNextMarker(), null);
        };
        return new PagedIterable(pageSize -> (PagedResponse)retriever.apply((String)null, (Integer)pageSize), retriever);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HandleItem> listHandles(Integer maxResultsPerPage, boolean recursive, Duration timeout, Context context) {
        return this.listHandlesWithOptionalTimeout(maxResultsPerPage, recursive, timeout, context);
    }

    PagedIterable<HandleItem> listHandlesWithOptionalTimeout(Integer maxResultPerPage, boolean recursive, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Function<String, PagedResponse> retriever = marker -> {
            Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getDirectories().listHandlesWithResponse(this.shareName, this.directoryPath, (String)marker, maxResultPerPage, null, this.snapshot, recursive, finalContext);
            ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ModelHelper.transformHandleItems(((ListHandlesResponse)response.getValue()).getHandleList()), ((ListHandlesResponse)response.getValue()).getNextMarker(), (Object)((DirectoriesListHandlesHeaders)response.getDeserializedHeaders()));
        };
        return new PagedIterable(() -> (PagedResponse)retriever.apply(null), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseHandle(String handleId) {
        return (CloseHandlesInfo)this.forceCloseHandleWithResponse(handleId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CloseHandlesInfo> forceCloseHandleWithResponse(String handleId, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getDirectories().forceCloseHandlesWithResponse(this.shareName, this.directoryPath, handleId, null, null, this.snapshot, false, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
        return new SimpleResponse((Response)response, (Object)new CloseHandlesInfo(((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseAllHandles(boolean recursive, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Function<String, PagedResponse> retriever = marker -> {
            Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getDirectories().forceCloseHandlesWithResponse(this.shareName, this.directoryPath, "*", null, (String)marker, this.snapshot, recursive, finalContext);
            ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Collections.singletonList(new CloseHandlesInfo(((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed())), ((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsMarker(), (Object)((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()));
        };
        return new PagedIterable(() -> (PagedResponse)retriever.apply(null), retriever).stream().reduce(new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryClient rename(String destinationPath) {
        return (ShareDirectoryClient)this.renameWithResponse(new ShareFileRenameOptions(destinationPath), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryClient> renameWithResponse(ShareFileRenameOptions options, Duration timeout, Context context) {
        CopyFileSmbInfo smbInfo;
        String filePermissionKey;
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions sourceRequestConditions = options.getSourceRequestConditions() == null ? new ShareRequestConditions() : options.getSourceRequestConditions();
        ShareRequestConditions destinationRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        SourceLeaseAccessConditions sourceConditions = new SourceLeaseAccessConditions().setSourceLeaseId(sourceRequestConditions.getLeaseId());
        DestinationLeaseAccessConditions destinationConditions = new DestinationLeaseAccessConditions().setDestinationLeaseId(destinationRequestConditions.getLeaseId());
        if (options.getSmbProperties() != null) {
            FileSmbProperties tempSmbProperties = options.getSmbProperties();
            filePermissionKey = tempSmbProperties.getFilePermissionKey();
            String fileAttributes = NtfsFileAttributes.toString(tempSmbProperties.getNtfsFileAttributes());
            String fileCreationTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileCreationTime());
            String fileLastWriteTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileLastWriteTime());
            String fileChangeTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileChangeTime());
            smbInfo = new CopyFileSmbInfo().setFileAttributes(fileAttributes).setFileCreationTime(fileCreationTime).setFileLastWriteTime(fileLastWriteTime).setFileChangeTime(fileChangeTime).setIgnoreReadOnly(options.isIgnoreReadOnly());
        } else {
            smbInfo = null;
            filePermissionKey = null;
        }
        ShareDirectoryClient destinationDirectoryClient = this.getDirectoryClient(options.getDestinationPath());
        String renameSource = this.sasToken != null ? this.getDirectoryUrl() + "?" + this.sasToken.getSignature() : this.getDirectoryUrl();
        Callable<Response> operation = () -> destinationDirectoryClient.azureFileStorageClient.getDirectories().renameNoCustomHeadersWithResponse(destinationDirectoryClient.getShareName(), destinationDirectoryClient.getDirectoryPath(), renameSource, null, options.getReplaceIfExists(), options.isIgnoreReadOnly(), options.getFilePermission(), options.getFilePermissionFormat(), filePermissionKey, options.getMetadata(), sourceConditions, destinationConditions, smbInfo, finalContext);
        return new SimpleResponse((Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class), (Object)destinationDirectoryClient);
    }

    ShareDirectoryClient getDirectoryClient(String destinationPath) {
        if (CoreUtils.isNullOrEmpty((CharSequence)destinationPath)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'destinationPath' can not be set to null"));
        }
        return new ShareDirectoryClient(this.azureFileStorageClient, this.getShareName(), destinationPath, null, this.getAccountName(), this.getServiceVersion(), this.sasToken);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryClient createSubdirectory(String subdirectoryName) {
        return (ShareDirectoryClient)this.createSubdirectoryWithResponse(subdirectoryName, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryClient> createSubdirectoryWithResponse(String subdirectoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        ShareDirectoryClient shareDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        return new SimpleResponse(shareDirectoryClient.createWithResponse(smbProperties, filePermission, metadata, timeout, context), (Object)shareDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryClient createSubdirectoryIfNotExists(String subdirectoryName) {
        return (ShareDirectoryClient)this.createSubdirectoryIfNotExistsWithResponse(subdirectoryName, new ShareDirectoryCreateOptions(), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryClient> createSubdirectoryIfNotExistsWithResponse(String subdirectoryName, ShareDirectoryCreateOptions options, Duration timeout, Context context) {
        ShareDirectoryClient shareDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        Response<ShareDirectoryInfo> response = shareDirectoryClient.createIfNotExistsWithResponse(options, timeout, context);
        return new SimpleResponse(response, (Object)shareDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSubdirectory(String subdirectoryName) {
        this.deleteSubdirectoryWithResponse(subdirectoryName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSubdirectoryWithResponse(String subdirectoryName, Duration timeout, Context context) {
        return this.getSubdirectoryClient(subdirectoryName).deleteWithResponse(timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteSubdirectoryIfExists(String subdirectoryName) {
        return (Boolean)this.deleteSubdirectoryIfExistsWithResponse(subdirectoryName, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteSubdirectoryIfExistsWithResponse(String subdirectoryName, Duration timeout, Context context) {
        return this.getSubdirectoryClient(subdirectoryName).deleteIfExistsWithResponse(timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileClient createFile(String fileName, long maxSize) {
        return (ShareFileClient)this.createFileWithResponse(fileName, maxSize, null, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        return this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        ShareFileClient shareFileClient = this.getFileClient(fileName);
        Response<ShareFileInfo> response = shareFileClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, timeout, context);
        return new SimpleResponse(response, (Object)shareFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, Duration timeout, Context context) {
        return this.deleteFileWithResponse(fileName, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteFileIfExists(String fileName) {
        return (Boolean)this.deleteFileIfExistsWithResponse(fileName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteFileIfExistsWithResponse(String fileName, Duration timeout, Context context) {
        return this.deleteFileIfExistsWithResponse(fileName, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteFileIfExistsWithResponse(String fileName, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        requestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        try {
            Response<Void> response = this.deleteFileWithResponse(fileName, requestConditions, timeout, context);
            return new SimpleResponse(response, (Object)true);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 404 && e.getErrorCode().equals((Object)ShareErrorCode.RESOURCE_NOT_FOUND)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
    }

    public String getShareSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    @Deprecated
    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.generateSas(shareServiceSasSignatureValues, Context.NONE);
    }

    @Deprecated
    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return this.generateSas(shareServiceSasSignatureValues, null, context);
    }

    @Deprecated
    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName(), this.getDirectoryPath()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }
}

