/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareClientBuilder;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.SharePermission;
import com.azure.storage.file.share.implementation.models.ShareSignedIdentifierWrapper;
import com.azure.storage.file.share.implementation.models.ShareStats;
import com.azure.storage.file.share.implementation.models.SharesCreatePermissionHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetAccessPolicyHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPermissionHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.FilePermissionFormat;
import com.azure.storage.file.share.models.ShareDirectoryInfo;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFilePermission;
import com.azure.storage.file.share.models.ShareInfo;
import com.azure.storage.file.share.models.ShareProperties;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareSnapshotInfo;
import com.azure.storage.file.share.models.ShareStatistics;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.models.UserDelegationKey;
import com.azure.storage.file.share.options.ShareCreateOptions;
import com.azure.storage.file.share.options.ShareDeleteOptions;
import com.azure.storage.file.share.options.ShareDirectoryCreateOptions;
import com.azure.storage.file.share.options.ShareGetAccessPolicyOptions;
import com.azure.storage.file.share.options.ShareGetPropertiesOptions;
import com.azure.storage.file.share.options.ShareGetStatisticsOptions;
import com.azure.storage.file.share.options.ShareSetAccessPolicyOptions;
import com.azure.storage.file.share.options.ShareSetMetadataOptions;
import com.azure.storage.file.share.options.ShareSetPropertiesOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;

@ServiceClient(builder=ShareClientBuilder.class)
public class ShareClient {
    private static final ClientLogger LOGGER = new ClientLogger(ShareClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;
    private final String shareUrlString;

    ShareClient(AzureFileStorageImpl azureFileStorageClient, String shareName, String snapshot, String accountName, ShareServiceVersion serviceVersion, AzureSasCredential sasToken) {
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        this.shareName = shareName;
        this.snapshot = snapshot;
        this.accountName = accountName;
        this.azureFileStorageClient = azureFileStorageClient;
        this.serviceVersion = serviceVersion;
        this.sasToken = sasToken;
        StringBuilder shareUrlString = new StringBuilder(azureFileStorageClient.getUrl()).append("/").append(shareName);
        if (snapshot != null) {
            shareUrlString.append("?sharesnapshot=").append(snapshot);
        }
        this.shareUrlString = shareUrlString.toString();
    }

    public String getAccountUrl() {
        return this.azureFileStorageClient.getUrl();
    }

    public String getShareUrl() {
        return this.shareUrlString;
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public ShareDirectoryClient getRootDirectoryClient() {
        return this.getDirectoryClient("");
    }

    public ShareDirectoryClient getDirectoryClient(String directoryName) {
        directoryName = "/".equals(directoryName) ? "" : directoryName;
        return new ShareDirectoryClient(this.azureFileStorageClient, this.shareName, directoryName, this.snapshot, this.accountName, this.serviceVersion, this.sasToken);
    }

    public ShareFileClient getFileClient(String filePath) {
        return new ShareFileClient(new ShareFileAsyncClient(this.azureFileStorageClient, this.shareName, filePath, this.snapshot, this.accountName, this.serviceVersion, this.sasToken), this.azureFileStorageClient, this.shareName, filePath, this.snapshot, this.accountName, this.serviceVersion, this.sasToken);
    }

    public ShareClient getSnapshotClient(String snapshot) {
        return new ShareClient(this.azureFileStorageClient, this.shareName, snapshot, this.accountName, this.serviceVersion, this.sasToken);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        try {
            Response<ShareProperties> response = this.getPropertiesWithResponse(timeout, context);
            return new SimpleResponse(response, (Object)true);
        }
        catch (RuntimeException e) {
            if (ModelHelper.checkDoesNotExistStatusCode(e) && e instanceof HttpResponseException) {
                HttpResponse response = ((HttpResponseException)e).getResponse();
                return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo create() {
        return (ShareInfo)this.createWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> createWithResponse(Map<String, String> metadata, Integer quotaInGB, Duration timeout, Context context) {
        return this.createWithResponse(new ShareCreateOptions().setQuotaInGb(quotaInGB).setMetadata(metadata), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> createWithResponse(ShareCreateOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareCreateOptions finalOptions = options == null ? new ShareCreateOptions() : options;
        String enabledProtocol = finalOptions.getProtocols() == null ? null : finalOptions.getProtocols().toString();
        String finalEnabledProtocol = "".equals(enabledProtocol) ? null : enabledProtocol;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().createNoCustomHeadersWithResponse(this.shareName, null, finalOptions.getMetadata(), finalOptions.getQuotaInGb(), finalOptions.getAccessTier(), finalEnabledProtocol, finalOptions.getRootSquash(), finalOptions.isSnapshotVirtualDirectoryAccessEnabled(), finalOptions.isPaidBurstingEnabled(), finalOptions.getPaidBurstingMaxBandwidthMibps(), finalOptions.getPaidBurstingMaxIops(), finalOptions.getProvisionedMaxIops(), finalOptions.getProvisionedMaxBandwidthMibps(), null, finalContext);
        return ModelHelper.mapToShareInfoResponse((Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo createIfNotExists() {
        return (ShareInfo)this.createIfNotExistsWithResponse(null, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> createIfNotExistsWithResponse(ShareCreateOptions options, Duration timeout, Context context) {
        try {
            return this.createWithResponse(options, timeout, context);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 409 && e.getErrorCode().equals((Object)ShareErrorCode.SHARE_ALREADY_EXISTS)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), null);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareSnapshotInfo createSnapshot() {
        return (ShareSnapshotInfo)this.createSnapshotWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareSnapshotInfo> createSnapshotWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getShares().createSnapshotWithResponse(this.shareName, null, metadata, finalContext);
        return ModelHelper.mapCreateSnapshotResponse((ResponseBase<SharesCreateSnapshotHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        return this.deleteWithResponse(new ShareDeleteOptions(), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(ShareDeleteOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareDeleteOptions finalOptions = options == null ? new ShareDeleteOptions() : options;
        ShareRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new ShareRequestConditions() : finalOptions.getRequestConditions();
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().deleteNoCustomHeadersWithResponse(this.shareName, this.snapshot, null, ModelHelper.toDeleteSnapshotsOptionType(finalOptions.getDeleteSnapshotsOptions()), requestConditions.getLeaseId(), finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return (Boolean)this.deleteIfExistsWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(ShareDeleteOptions options, Duration timeout, Context context) {
        try {
            Response<Void> response = this.deleteWithResponse(options, timeout, context);
            return new SimpleResponse(response, (Object)true);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 404 && (e.getErrorCode().equals((Object)ShareErrorCode.SHARE_NOT_FOUND) || e.getErrorCode().equals((Object)ShareErrorCode.SHARE_SNAPSHOT_NOT_FOUND))) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareProperties getProperties() {
        return (ShareProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        return this.getPropertiesWithResponse(new ShareGetPropertiesOptions(), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareProperties> getPropertiesWithResponse(ShareGetPropertiesOptions options, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getShares().getPropertiesWithResponse(this.shareName, this.snapshot, null, requestConditions.getLeaseId(), finalContext);
        return ModelHelper.mapGetPropertiesResponse((ResponseBase<SharesGetPropertiesHeaders, Void>)((ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo setQuota(int quotaInGB) {
        return (ShareInfo)this.setQuotaWithResponse(quotaInGB, null, Context.NONE).getValue();
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setQuotaWithResponse(int quotaInGB, Duration timeout, Context context) {
        return this.setPropertiesWithResponse(new ShareSetPropertiesOptions().setQuotaInGb(quotaInGB), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo setProperties(ShareSetPropertiesOptions options) {
        return (ShareInfo)this.setPropertiesWithResponse(options, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setPropertiesWithResponse(ShareSetPropertiesOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().setPropertiesNoCustomHeadersWithResponse(this.shareName, null, options.getQuotaInGb(), options.getAccessTier(), requestConditions.getLeaseId(), options.getRootSquash(), options.isSnapshotVirtualDirectoryAccessEnabled(), options.isPaidBurstingEnabled(), options.getPaidBurstingMaxBandwidthMibps(), options.getPaidBurstingMaxIops(), options.getProvisionedMaxIops(), options.getProvisionedMaxBandwidthMibps(), null, finalContext);
        return ModelHelper.mapToShareInfoResponse((Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo setMetadata(Map<String, String> metadata) {
        return (ShareInfo)this.setMetadataWithResponse(metadata, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        return this.setMetadataWithResponse(new ShareSetMetadataOptions().setMetadata(metadata), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setMetadataWithResponse(ShareSetMetadataOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().setMetadataNoCustomHeadersWithResponse(this.shareName, null, options.getMetadata(), requestConditions.getLeaseId(), finalContext);
        return ModelHelper.mapToShareInfoResponse((Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareSignedIdentifier> getAccessPolicy() {
        return this.getAccessPolicy(new ShareGetAccessPolicyOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareSignedIdentifier> getAccessPolicy(ShareGetAccessPolicyOptions options) {
        ShareGetAccessPolicyOptions finalOptions = options == null ? new ShareGetAccessPolicyOptions() : options;
        ShareRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new ShareRequestConditions() : finalOptions.getRequestConditions();
        ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper> responseBase = this.azureFileStorageClient.getShares().getAccessPolicyWithResponse(this.shareName, null, requestConditions.getLeaseId(), Context.NONE);
        Supplier<PagedResponse> response = () -> new PagedResponseBase(responseBase.getRequest(), responseBase.getStatusCode(), responseBase.getHeaders(), ((ShareSignedIdentifierWrapper)responseBase.getValue()).items(), null, (Object)((SharesGetAccessPolicyHeaders)responseBase.getDeserializedHeaders()));
        return new PagedIterable(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo setAccessPolicy(List<ShareSignedIdentifier> permissions) {
        return (ShareInfo)this.setAccessPolicyWithResponse(permissions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setAccessPolicyWithResponse(List<ShareSignedIdentifier> permissions, Duration timeout, Context context) {
        return this.setAccessPolicyWithResponse(new ShareSetAccessPolicyOptions().setPermissions(permissions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setAccessPolicyWithResponse(ShareSetAccessPolicyOptions options, Duration timeout, Context context) {
        options = options == null ? new ShareSetAccessPolicyOptions() : options;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        List<ShareSignedIdentifier> permissions = ModelHelper.truncateAccessPolicyPermissionsToSeconds(options.getPermissions());
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().setAccessPolicyNoCustomHeadersWithResponse(this.shareName, null, requestConditions.getLeaseId(), permissions, finalContext);
        return ModelHelper.mapToShareInfoResponse((Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareStatistics getStatistics() {
        return (ShareStatistics)this.getStatisticsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareStatistics> getStatisticsWithResponse(Duration timeout, Context context) {
        return this.getStatisticsWithResponse(new ShareGetStatisticsOptions(), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareStatistics> getStatisticsWithResponse(ShareGetStatisticsOptions options, Duration timeout, Context context) {
        options = options == null ? new ShareGetStatisticsOptions() : options;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().getStatisticsNoCustomHeadersWithResponse(this.shareName, null, requestConditions.getLeaseId(), finalContext);
        return ModelHelper.mapGetStatisticsResponse((Response<ShareStats>)((Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryClient createDirectory(String directoryName) {
        return (ShareDirectoryClient)this.createDirectoryWithResponse(directoryName, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryClient> createDirectoryWithResponse(String directoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        ShareDirectoryClient shareDirectoryClient = this.getDirectoryClient(directoryName);
        return new SimpleResponse(shareDirectoryClient.createWithResponse(smbProperties, filePermission, metadata, timeout, context), (Object)shareDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryClient createDirectoryIfNotExists(String directoryName) {
        return (ShareDirectoryClient)this.createDirectoryIfNotExistsWithResponse(directoryName, new ShareDirectoryCreateOptions(), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryClient> createDirectoryIfNotExistsWithResponse(String directoryName, ShareDirectoryCreateOptions options, Duration timeout, Context context) {
        ShareDirectoryClient shareDirectoryClient = this.getDirectoryClient(directoryName);
        Response<ShareDirectoryInfo> response = shareDirectoryClient.createIfNotExistsWithResponse(options, timeout, context);
        return new SimpleResponse(response, (Object)shareDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileClient createFile(String fileName, long maxSize) {
        return (ShareFileClient)this.createFileWithResponse(fileName, maxSize, null, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        return this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        ShareFileClient shareFileClient = this.getFileClient(fileName);
        return new SimpleResponse(shareFileClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, timeout, context), (Object)shareFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDirectory(String directoryName) {
        this.deleteDirectoryWithResponse(directoryName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDirectoryWithResponse(String directoryName, Duration timeout, Context context) {
        return this.getDirectoryClient(directoryName).deleteWithResponse(timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteDirectoryIfExists(String directoryName) {
        return (Boolean)this.deleteDirectoryIfExistsWithResponse(directoryName, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteDirectoryIfExistsWithResponse(String directoryName, Duration timeout, Context context) {
        return this.getDirectoryClient(directoryName).deleteIfExistsWithResponse(timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, Duration timeout, Context context) {
        return this.deleteFileWithResponse(fileName, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteFileIfExists(String fileName) {
        return (Boolean)this.deleteFileIfExistsWithResponse(fileName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteFileIfExistsWithResponse(String fileName, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        try {
            Response<Void> response = this.deleteFileWithResponse(fileName, finalRequestConditions, timeout, finalContext);
            return new SimpleResponse(response, (Object)true);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 404 && e.getErrorCode().equals((Object)ShareErrorCode.RESOURCE_NOT_FOUND)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String createPermission(String filePermission) {
        return (String)this.createPermissionWithResponse(filePermission, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String createPermission(ShareFilePermission filePermission) {
        return (String)this.createPermissionWithResponse(filePermission, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> createPermissionWithResponse(String filePermission, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        SharePermission sharePermission = new SharePermission().setPermission(filePermission);
        ResponseBase<SharesCreatePermissionHeaders, Void> response = this.azureFileStorageClient.getShares().createPermissionWithResponse(this.shareName, sharePermission, null, finalContext);
        return new SimpleResponse(response, (Object)((SharesCreatePermissionHeaders)response.getDeserializedHeaders()).getXMsFilePermissionKey());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> createPermissionWithResponse(ShareFilePermission filePermission, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        SharePermission sharePermission = new SharePermission().setPermission(filePermission.getPermission()).setFormat(filePermission.getPermissionFormat());
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getShares().createPermissionWithResponse(this.shareName, sharePermission, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
        return new SimpleResponse((Response)response, (Object)((SharesCreatePermissionHeaders)response.getDeserializedHeaders()).getXMsFilePermissionKey());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getPermission(String filePermissionKey) {
        return (String)this.getPermissionWithResponse(filePermissionKey, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getPermission(String filePermissionKey, FilePermissionFormat filePermissionFormat) {
        return (String)this.getPermissionWithResponse(filePermissionKey, filePermissionFormat, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getPermissionWithResponse(String filePermissionKey, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ResponseBase<SharesGetPermissionHeaders, SharePermission> response = this.azureFileStorageClient.getShares().getPermissionWithResponse(this.shareName, filePermissionKey, null, null, finalContext);
        return new SimpleResponse(response, (Object)((SharePermission)response.getValue()).getPermission());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getPermissionWithResponse(String filePermissionKey, FilePermissionFormat filePermissionFormat, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getShares().getPermissionWithResponse(this.shareName, filePermissionKey, filePermissionFormat, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, ShareStorageException.class);
        return new SimpleResponse((Response)response, (Object)((SharePermission)response.getValue()).getPermission());
    }

    public String getSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.generateSas(shareServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return this.generateSas(shareServiceSasSignatureValues, null, context);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }

    public String generateUserDelegationSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(shareServiceSasSignatureValues, userDelegationKey, null, Context.NONE);
    }

    public String generateUserDelegationSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, UserDelegationKey userDelegationKey, Consumer<String> stringToSignHandler, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName()).generateUserDelegationSas(userDelegationKey, this.accountName, stringToSignHandler, context);
    }
}

