/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.share.implementation.models.SharePermission;
import com.azure.storage.file.share.implementation.models.ShareSignedIdentifierWrapper;
import com.azure.storage.file.share.implementation.models.ShareStats;
import com.azure.storage.file.share.implementation.models.ShareStorageExceptionInternal;
import com.azure.storage.file.share.implementation.models.SharesAcquireLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesBreakLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesChangeLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreateHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreatePermissionHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotHeaders;
import com.azure.storage.file.share.implementation.models.SharesDeleteHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetAccessPolicyHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPermissionHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetStatisticsHeaders;
import com.azure.storage.file.share.implementation.models.SharesReleaseLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesRenewLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesRestoreHeaders;
import com.azure.storage.file.share.implementation.models.SharesSetAccessPolicyHeaders;
import com.azure.storage.file.share.implementation.models.SharesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.SharesSetPropertiesHeaders;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.models.FilePermissionFormat;
import com.azure.storage.file.share.models.ShareAccessTier;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareTokenIntent;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class SharesImpl {
    private final SharesService service;
    private final AzureFileStorageImpl client;

    SharesImpl(AzureFileStorageImpl client) {
        this.service = (SharesService)RestProxy.create(SharesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateHeaders, Void>> createWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return FluxUtil.withContext(context -> this.createWithResponseAsync(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateHeaders, Void>> createWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), shareName, "share", timeout, metadata, quota, accessTier, this.client.getVersion(), enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return this.createWithResponseAsync(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        return this.createWithResponseAsync(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return FluxUtil.withContext(context -> this.createNoCustomHeadersWithResponseAsync(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.createNoCustomHeaders(this.client.getUrl(), shareName, "share", timeout, metadata, quota, accessTier, this.client.getVersion(), enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesCreateHeaders, Void> createWithResponse(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        try {
            String restype = "share";
            String accept = "application/xml";
            return this.service.createSync(this.client.getUrl(), shareName, "share", timeout, metadata, quota, accessTier, this.client.getVersion(), enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        this.createWithResponse(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        try {
            String restype = "share";
            String accept = "application/xml";
            return this.service.createNoCustomHeadersSync(this.client.getUrl(), shareName, "share", timeout, metadata, quota, accessTier, this.client.getVersion(), enabledProtocols, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId) {
        return FluxUtil.withContext(context -> this.getPropertiesWithResponseAsync(shareName, sharesnapshot, timeout, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId) {
        return this.getPropertiesWithResponseAsync(shareName, sharesnapshot, timeout, leaseId).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        return this.getPropertiesWithResponseAsync(shareName, sharesnapshot, timeout, leaseId, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId) {
        return FluxUtil.withContext(context -> this.getPropertiesNoCustomHeadersWithResponseAsync(shareName, sharesnapshot, timeout, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesGetPropertiesHeaders, Void> getPropertiesWithResponse(String shareName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        try {
            String restype = "share";
            String accept = "application/xml";
            return this.service.getPropertiesSync(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getProperties(String shareName, String sharesnapshot, Integer timeout, String leaseId) {
        this.getPropertiesWithResponse(shareName, sharesnapshot, timeout, leaseId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getPropertiesNoCustomHeadersWithResponse(String shareName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        try {
            String restype = "share";
            String accept = "application/xml";
            return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        return this.deleteWithResponseAsync(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        return this.deleteWithResponseAsync(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        return FluxUtil.withContext(context -> this.deleteNoCustomHeadersWithResponseAsync(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.deleteNoCustomHeaders(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesDeleteHeaders, Void> deleteWithResponse(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        try {
            String restype = "share";
            String accept = "application/xml";
            return this.service.deleteSync(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        this.deleteWithResponse(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNoCustomHeadersWithResponse(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        try {
            String restype = "share";
            String accept = "application/xml";
            return this.service.deleteNoCustomHeadersSync(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId) {
        return FluxUtil.withContext(context -> this.acquireLeaseWithResponseAsync(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String restype = "share";
        String accept = "application/xml";
        return this.service.acquireLease(this.client.getUrl(), shareName, "lease", "acquire", "share", timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId) {
        return this.acquireLeaseWithResponseAsync(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        return this.acquireLeaseWithResponseAsync(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId) {
        return FluxUtil.withContext(context -> this.acquireLeaseNoCustomHeadersWithResponseAsync(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String restype = "share";
        String accept = "application/xml";
        return this.service.acquireLeaseNoCustomHeaders(this.client.getUrl(), shareName, "lease", "acquire", "share", timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesAcquireLeaseHeaders, Void> acquireLeaseWithResponse(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        try {
            String comp = "lease";
            String action = "acquire";
            String restype = "share";
            String accept = "application/xml";
            return this.service.acquireLeaseSync(this.client.getUrl(), shareName, "lease", "acquire", "share", timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void acquireLease(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId) {
        this.acquireLeaseWithResponse(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> acquireLeaseNoCustomHeadersWithResponse(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        try {
            String comp = "lease";
            String action = "acquire";
            String restype = "share";
            String accept = "application/xml";
            return this.service.acquireLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, "lease", "acquire", "share", timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return FluxUtil.withContext(context -> this.releaseLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String restype = "share";
        String accept = "application/xml";
        return this.service.releaseLease(this.client.getUrl(), shareName, "lease", "release", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return this.releaseLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        return this.releaseLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return FluxUtil.withContext(context -> this.releaseLeaseNoCustomHeadersWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String restype = "share";
        String accept = "application/xml";
        return this.service.releaseLeaseNoCustomHeaders(this.client.getUrl(), shareName, "lease", "release", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesReleaseLeaseHeaders, Void> releaseLeaseWithResponse(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        try {
            String comp = "lease";
            String action = "release";
            String restype = "share";
            String accept = "application/xml";
            return this.service.releaseLeaseSync(this.client.getUrl(), shareName, "lease", "release", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releaseLease(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        this.releaseLeaseWithResponse(shareName, leaseId, timeout, sharesnapshot, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releaseLeaseNoCustomHeadersWithResponse(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        try {
            String comp = "lease";
            String action = "release";
            String restype = "share";
            String accept = "application/xml";
            return this.service.releaseLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, "lease", "release", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId) {
        return FluxUtil.withContext(context -> this.changeLeaseWithResponseAsync(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String restype = "share";
        String accept = "application/xml";
        return this.service.changeLease(this.client.getUrl(), shareName, "lease", "change", "share", timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId) {
        return this.changeLeaseWithResponseAsync(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        return this.changeLeaseWithResponseAsync(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId) {
        return FluxUtil.withContext(context -> this.changeLeaseNoCustomHeadersWithResponseAsync(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String restype = "share";
        String accept = "application/xml";
        return this.service.changeLeaseNoCustomHeaders(this.client.getUrl(), shareName, "lease", "change", "share", timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesChangeLeaseHeaders, Void> changeLeaseWithResponse(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        try {
            String comp = "lease";
            String action = "change";
            String restype = "share";
            String accept = "application/xml";
            return this.service.changeLeaseSync(this.client.getUrl(), shareName, "lease", "change", "share", timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void changeLease(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId) {
        this.changeLeaseWithResponse(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> changeLeaseNoCustomHeadersWithResponse(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        try {
            String comp = "lease";
            String action = "change";
            String restype = "share";
            String accept = "application/xml";
            return this.service.changeLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, "lease", "change", "share", timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return FluxUtil.withContext(context -> this.renewLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "renew";
        String restype = "share";
        String accept = "application/xml";
        return this.service.renewLease(this.client.getUrl(), shareName, "lease", "renew", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return this.renewLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        return this.renewLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renewLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return FluxUtil.withContext(context -> this.renewLeaseNoCustomHeadersWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renewLeaseNoCustomHeadersWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "renew";
        String restype = "share";
        String accept = "application/xml";
        return this.service.renewLeaseNoCustomHeaders(this.client.getUrl(), shareName, "lease", "renew", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesRenewLeaseHeaders, Void> renewLeaseWithResponse(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        try {
            String comp = "lease";
            String action = "renew";
            String restype = "share";
            String accept = "application/xml";
            return this.service.renewLeaseSync(this.client.getUrl(), shareName, "lease", "renew", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renewLease(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        this.renewLeaseWithResponse(shareName, leaseId, timeout, sharesnapshot, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renewLeaseNoCustomHeadersWithResponse(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        try {
            String comp = "lease";
            String action = "renew";
            String restype = "share";
            String accept = "application/xml";
            return this.service.renewLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, "lease", "renew", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot) {
        return FluxUtil.withContext(context -> this.breakLeaseWithResponseAsync(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        String comp = "lease";
        String action = "break";
        String restype = "share";
        String accept = "application/xml";
        return this.service.breakLease(this.client.getUrl(), shareName, "lease", "break", "share", timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot) {
        return this.breakLeaseWithResponseAsync(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        return this.breakLeaseWithResponseAsync(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot) {
        return FluxUtil.withContext(context -> this.breakLeaseNoCustomHeadersWithResponseAsync(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        String comp = "lease";
        String action = "break";
        String restype = "share";
        String accept = "application/xml";
        return this.service.breakLeaseNoCustomHeaders(this.client.getUrl(), shareName, "lease", "break", "share", timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesBreakLeaseHeaders, Void> breakLeaseWithResponse(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        try {
            String comp = "lease";
            String action = "break";
            String restype = "share";
            String accept = "application/xml";
            return this.service.breakLeaseSync(this.client.getUrl(), shareName, "lease", "break", "share", timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void breakLease(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot) {
        this.breakLeaseWithResponse(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> breakLeaseNoCustomHeadersWithResponse(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        try {
            String comp = "lease";
            String action = "break";
            String restype = "share";
            String accept = "application/xml";
            return this.service.breakLeaseNoCustomHeadersSync(this.client.getUrl(), shareName, "lease", "break", "share", timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateSnapshotHeaders, Void>> createSnapshotWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata) {
        return FluxUtil.withContext(context -> this.createSnapshotWithResponseAsync(shareName, timeout, metadata, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateSnapshotHeaders, Void>> createSnapshotWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "share";
        String comp = "snapshot";
        String accept = "application/xml";
        return this.service.createSnapshot(this.client.getUrl(), shareName, "share", "snapshot", timeout, metadata, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createSnapshotAsync(String shareName, Integer timeout, Map<String, String> metadata) {
        return this.createSnapshotWithResponseAsync(shareName, timeout, metadata).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createSnapshotAsync(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        return this.createSnapshotWithResponseAsync(shareName, timeout, metadata, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createSnapshotNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata) {
        return FluxUtil.withContext(context -> this.createSnapshotNoCustomHeadersWithResponseAsync(shareName, timeout, metadata, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createSnapshotNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "share";
        String comp = "snapshot";
        String accept = "application/xml";
        return this.service.createSnapshotNoCustomHeaders(this.client.getUrl(), shareName, "share", "snapshot", timeout, metadata, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesCreateSnapshotHeaders, Void> createSnapshotWithResponse(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        try {
            String restype = "share";
            String comp = "snapshot";
            String accept = "application/xml";
            return this.service.createSnapshotSync(this.client.getUrl(), shareName, "share", "snapshot", timeout, metadata, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createSnapshot(String shareName, Integer timeout, Map<String, String> metadata) {
        this.createSnapshotWithResponse(shareName, timeout, metadata, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createSnapshotNoCustomHeadersWithResponse(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        try {
            String restype = "share";
            String comp = "snapshot";
            String accept = "application/xml";
            return this.service.createSnapshotNoCustomHeadersSync(this.client.getUrl(), shareName, "share", "snapshot", timeout, metadata, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreatePermissionHeaders, Void>> createPermissionWithResponseAsync(String shareName, SharePermission sharePermission, Integer timeout) {
        return FluxUtil.withContext(context -> this.createPermissionWithResponseAsync(shareName, sharePermission, timeout, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreatePermissionHeaders, Void>> createPermissionWithResponseAsync(String shareName, SharePermission sharePermission, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/xml";
        return this.service.createPermission(this.client.getUrl(), shareName, "share", "filepermission", timeout, this.client.getVersion(), this.client.getFileRequestIntent(), sharePermission, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createPermissionAsync(String shareName, SharePermission sharePermission, Integer timeout) {
        return this.createPermissionWithResponseAsync(shareName, sharePermission, timeout).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createPermissionAsync(String shareName, SharePermission sharePermission, Integer timeout, Context context) {
        return this.createPermissionWithResponseAsync(shareName, sharePermission, timeout, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createPermissionNoCustomHeadersWithResponseAsync(String shareName, SharePermission sharePermission, Integer timeout) {
        return FluxUtil.withContext(context -> this.createPermissionNoCustomHeadersWithResponseAsync(shareName, sharePermission, timeout, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createPermissionNoCustomHeadersWithResponseAsync(String shareName, SharePermission sharePermission, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/xml";
        return this.service.createPermissionNoCustomHeaders(this.client.getUrl(), shareName, "share", "filepermission", timeout, this.client.getVersion(), this.client.getFileRequestIntent(), sharePermission, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesCreatePermissionHeaders, Void> createPermissionWithResponse(String shareName, SharePermission sharePermission, Integer timeout, Context context) {
        try {
            String restype = "share";
            String comp = "filepermission";
            String accept = "application/xml";
            return this.service.createPermissionSync(this.client.getUrl(), shareName, "share", "filepermission", timeout, this.client.getVersion(), this.client.getFileRequestIntent(), sharePermission, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createPermission(String shareName, SharePermission sharePermission, Integer timeout) {
        this.createPermissionWithResponse(shareName, sharePermission, timeout, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createPermissionNoCustomHeadersWithResponse(String shareName, SharePermission sharePermission, Integer timeout, Context context) {
        try {
            String restype = "share";
            String comp = "filepermission";
            String accept = "application/xml";
            return this.service.createPermissionNoCustomHeadersSync(this.client.getUrl(), shareName, "share", "filepermission", timeout, this.client.getVersion(), this.client.getFileRequestIntent(), sharePermission, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPermissionHeaders, SharePermission>> getPermissionWithResponseAsync(String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout) {
        return FluxUtil.withContext(context -> this.getPermissionWithResponseAsync(shareName, filePermissionKey, filePermissionFormat, timeout, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPermissionHeaders, SharePermission>> getPermissionWithResponseAsync(String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/json";
        return this.service.getPermission(this.client.getUrl(), shareName, "share", "filepermission", filePermissionKey, filePermissionFormat, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/json", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharePermission> getPermissionAsync(String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout) {
        return this.getPermissionWithResponseAsync(shareName, filePermissionKey, filePermissionFormat, timeout).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((SharePermission)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharePermission> getPermissionAsync(String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout, Context context) {
        return this.getPermissionWithResponseAsync(shareName, filePermissionKey, filePermissionFormat, timeout, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((SharePermission)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SharePermission>> getPermissionNoCustomHeadersWithResponseAsync(String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout) {
        return FluxUtil.withContext(context -> this.getPermissionNoCustomHeadersWithResponseAsync(shareName, filePermissionKey, filePermissionFormat, timeout, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SharePermission>> getPermissionNoCustomHeadersWithResponseAsync(String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/json";
        return this.service.getPermissionNoCustomHeaders(this.client.getUrl(), shareName, "share", "filepermission", filePermissionKey, filePermissionFormat, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/json", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesGetPermissionHeaders, SharePermission> getPermissionWithResponse(String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout, Context context) {
        try {
            String restype = "share";
            String comp = "filepermission";
            String accept = "application/json";
            return this.service.getPermissionSync(this.client.getUrl(), shareName, "share", "filepermission", filePermissionKey, filePermissionFormat, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/json", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SharePermission getPermission(String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout) {
        try {
            return (SharePermission)this.getPermissionWithResponse(shareName, filePermissionKey, filePermissionFormat, timeout, Context.NONE).getValue();
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SharePermission> getPermissionNoCustomHeadersWithResponse(String shareName, String filePermissionKey, FilePermissionFormat filePermissionFormat, Integer timeout, Context context) {
        try {
            String restype = "share";
            String comp = "filepermission";
            String accept = "application/json";
            return this.service.getPermissionNoCustomHeadersSync(this.client.getUrl(), shareName, "share", "filepermission", filePermissionKey, filePermissionFormat, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/json", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return FluxUtil.withContext(context -> this.setPropertiesWithResponseAsync(shareName, timeout, quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        String restype = "share";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), shareName, "share", "properties", timeout, this.client.getVersion(), quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return this.setPropertiesWithResponseAsync(shareName, timeout, quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        return this.setPropertiesWithResponseAsync(shareName, timeout, quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        return FluxUtil.withContext(context -> this.setPropertiesNoCustomHeadersWithResponseAsync(shareName, timeout, quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        String restype = "share";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), shareName, "share", "properties", timeout, this.client.getVersion(), quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesSetPropertiesHeaders, Void> setPropertiesWithResponse(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        try {
            String restype = "share";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.setPropertiesSync(this.client.getUrl(), shareName, "share", "properties", timeout, this.client.getVersion(), quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps) {
        this.setPropertiesWithResponse(shareName, timeout, quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, shareProvisionedIops, shareProvisionedBandwidthMibps, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesNoCustomHeadersWithResponse(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Boolean enableSnapshotVirtualDirectoryAccess, Boolean paidBurstingEnabled, Long paidBurstingMaxBandwidthMibps, Long paidBurstingMaxIops, Long shareProvisionedIops, Long shareProvisionedBandwidthMibps, Context context) {
        try {
            String restype = "share";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.setPropertiesNoCustomHeadersSync(this.client.getUrl(), shareName, "share", "properties", timeout, this.client.getVersion(), quota, accessTier, leaseId, rootSquash, enableSnapshotVirtualDirectoryAccess, paidBurstingEnabled, paidBurstingMaxBandwidthMibps, paidBurstingMaxIops, this.client.getFileRequestIntent(), shareProvisionedIops, shareProvisionedBandwidthMibps, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId) {
        return FluxUtil.withContext(context -> this.setMetadataWithResponseAsync(shareName, timeout, metadata, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String restype = "share";
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), shareName, "share", "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId) {
        return this.setMetadataWithResponseAsync(shareName, timeout, metadata, leaseId).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        return this.setMetadataWithResponseAsync(shareName, timeout, metadata, leaseId, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId) {
        return FluxUtil.withContext(context -> this.setMetadataNoCustomHeadersWithResponseAsync(shareName, timeout, metadata, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String restype = "share";
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadataNoCustomHeaders(this.client.getUrl(), shareName, "share", "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesSetMetadataHeaders, Void> setMetadataWithResponse(String shareName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        try {
            String restype = "share";
            String comp = "metadata";
            String accept = "application/xml";
            return this.service.setMetadataSync(this.client.getUrl(), shareName, "share", "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(String shareName, Integer timeout, Map<String, String> metadata, String leaseId) {
        this.setMetadataWithResponse(shareName, timeout, metadata, leaseId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataNoCustomHeadersWithResponse(String shareName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        try {
            String restype = "share";
            String comp = "metadata";
            String accept = "application/xml";
            return this.service.setMetadataNoCustomHeadersSync(this.client.getUrl(), shareName, "share", "metadata", timeout, metadata, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper>> getAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId) {
        return FluxUtil.withContext(context -> this.getAccessPolicyWithResponseAsync(shareName, timeout, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper>> getAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareSignedIdentifierWrapper> getAccessPolicyAsync(String shareName, Integer timeout, String leaseId) {
        return this.getAccessPolicyWithResponseAsync(shareName, timeout, leaseId).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ShareSignedIdentifierWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareSignedIdentifierWrapper> getAccessPolicyAsync(String shareName, Integer timeout, String leaseId, Context context) {
        return this.getAccessPolicyWithResponseAsync(shareName, timeout, leaseId, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ShareSignedIdentifierWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareSignedIdentifierWrapper>> getAccessPolicyNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, String leaseId) {
        return FluxUtil.withContext(context -> this.getAccessPolicyNoCustomHeadersWithResponseAsync(shareName, timeout, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareSignedIdentifierWrapper>> getAccessPolicyNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicyNoCustomHeaders(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper> getAccessPolicyWithResponse(String shareName, Integer timeout, String leaseId, Context context) {
        try {
            String restype = "share";
            String comp = "acl";
            String accept = "application/xml";
            return this.service.getAccessPolicySync(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareSignedIdentifierWrapper getAccessPolicy(String shareName, Integer timeout, String leaseId) {
        try {
            return (ShareSignedIdentifierWrapper)this.getAccessPolicyWithResponse(shareName, timeout, leaseId, Context.NONE).getValue();
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersWithResponse(String shareName, Integer timeout, String leaseId, Context context) {
        try {
            String restype = "share";
            String comp = "acl";
            String accept = "application/xml";
            return this.service.getAccessPolicyNoCustomHeadersSync(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl) {
        return FluxUtil.withContext(context -> this.setAccessPolicyWithResponseAsync(shareName, timeout, leaseId, shareAcl, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        ShareSignedIdentifierWrapper shareAclConverted = new ShareSignedIdentifierWrapper(shareAcl);
        return this.service.setAccessPolicy(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), shareAclConverted, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl) {
        return this.setAccessPolicyWithResponseAsync(shareName, timeout, leaseId, shareAcl).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        return this.setAccessPolicyWithResponseAsync(shareName, timeout, leaseId, shareAcl, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl) {
        return FluxUtil.withContext(context -> this.setAccessPolicyNoCustomHeadersWithResponseAsync(shareName, timeout, leaseId, shareAcl, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        ShareSignedIdentifierWrapper shareAclConverted = new ShareSignedIdentifierWrapper(shareAcl);
        return this.service.setAccessPolicyNoCustomHeaders(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), shareAclConverted, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesSetAccessPolicyHeaders, Void> setAccessPolicyWithResponse(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        try {
            String restype = "share";
            String comp = "acl";
            String accept = "application/xml";
            ShareSignedIdentifierWrapper shareAclConverted = new ShareSignedIdentifierWrapper(shareAcl);
            return this.service.setAccessPolicySync(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), shareAclConverted, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicy(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl) {
        this.setAccessPolicyWithResponse(shareName, timeout, leaseId, shareAcl, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPolicyNoCustomHeadersWithResponse(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        try {
            String restype = "share";
            String comp = "acl";
            String accept = "application/xml";
            ShareSignedIdentifierWrapper shareAclConverted = new ShareSignedIdentifierWrapper(shareAcl);
            return this.service.setAccessPolicyNoCustomHeadersSync(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), shareAclConverted, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetStatisticsHeaders, ShareStats>> getStatisticsWithResponseAsync(String shareName, Integer timeout, String leaseId) {
        return FluxUtil.withContext(context -> this.getStatisticsWithResponseAsync(shareName, timeout, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetStatisticsHeaders, ShareStats>> getStatisticsWithResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatistics(this.client.getUrl(), shareName, "share", "stats", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareStats> getStatisticsAsync(String shareName, Integer timeout, String leaseId) {
        return this.getStatisticsWithResponseAsync(shareName, timeout, leaseId).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ShareStats)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareStats> getStatisticsAsync(String shareName, Integer timeout, String leaseId, Context context) {
        return this.getStatisticsWithResponseAsync(shareName, timeout, leaseId, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ShareStats)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareStats>> getStatisticsNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, String leaseId) {
        return FluxUtil.withContext(context -> this.getStatisticsNoCustomHeadersWithResponseAsync(shareName, timeout, leaseId, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareStats>> getStatisticsNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatisticsNoCustomHeaders(this.client.getUrl(), shareName, "share", "stats", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesGetStatisticsHeaders, ShareStats> getStatisticsWithResponse(String shareName, Integer timeout, String leaseId, Context context) {
        try {
            String restype = "share";
            String comp = "stats";
            String accept = "application/xml";
            return this.service.getStatisticsSync(this.client.getUrl(), shareName, "share", "stats", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareStats getStatistics(String shareName, Integer timeout, String leaseId) {
        try {
            return (ShareStats)this.getStatisticsWithResponse(shareName, timeout, leaseId, Context.NONE).getValue();
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareStats> getStatisticsNoCustomHeadersWithResponse(String shareName, Integer timeout, String leaseId, Context context) {
        try {
            String restype = "share";
            String comp = "stats";
            String accept = "application/xml";
            return this.service.getStatisticsNoCustomHeadersSync(this.client.getUrl(), shareName, "share", "stats", timeout, this.client.getVersion(), leaseId, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRestoreHeaders, Void>> restoreWithResponseAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion) {
        return FluxUtil.withContext(context -> this.restoreWithResponseAsync(shareName, timeout, requestId, deletedShareName, deletedShareVersion, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRestoreHeaders, Void>> restoreWithResponseAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        String restype = "share";
        String comp = "undelete";
        String accept = "application/xml";
        return this.service.restore(this.client.getUrl(), shareName, "share", "undelete", timeout, this.client.getVersion(), requestId, deletedShareName, deletedShareVersion, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion) {
        return this.restoreWithResponseAsync(shareName, timeout, requestId, deletedShareName, deletedShareVersion).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        return this.restoreWithResponseAsync(shareName, timeout, requestId, deletedShareName, deletedShareVersion, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> restoreNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion) {
        return FluxUtil.withContext(context -> this.restoreNoCustomHeadersWithResponseAsync(shareName, timeout, requestId, deletedShareName, deletedShareVersion, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> restoreNoCustomHeadersWithResponseAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        String restype = "share";
        String comp = "undelete";
        String accept = "application/xml";
        return this.service.restoreNoCustomHeaders(this.client.getUrl(), shareName, "share", "undelete", timeout, this.client.getVersion(), requestId, deletedShareName, deletedShareVersion, this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<SharesRestoreHeaders, Void> restoreWithResponse(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        try {
            String restype = "share";
            String comp = "undelete";
            String accept = "application/xml";
            return this.service.restoreSync(this.client.getUrl(), shareName, "share", "undelete", timeout, this.client.getVersion(), requestId, deletedShareName, deletedShareVersion, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restore(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion) {
        this.restoreWithResponse(shareName, timeout, requestId, deletedShareName, deletedShareVersion, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> restoreNoCustomHeadersWithResponse(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        try {
            String restype = "share";
            String comp = "undelete";
            String accept = "application/xml";
            return this.service.restoreNoCustomHeadersSync(this.client.getUrl(), shareName, "share", "undelete", timeout, this.client.getVersion(), requestId, deletedShareName, deletedShareVersion, this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageShares")
    public static interface SharesService {
        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-share-quota") Integer var6, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-enabled-protocols") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="x-ms-enable-snapshot-virtual-directory-access") Boolean var11, @HeaderParam(value="x-ms-share-paid-bursting-enabled") Boolean var12, @HeaderParam(value="x-ms-share-paid-bursting-max-bandwidth-mibps") Long var13, @HeaderParam(value="x-ms-share-paid-bursting-max-iops") Long var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="x-ms-share-provisioned-iops") Long var16, @HeaderParam(value="x-ms-share-provisioned-bandwidth-mibps") Long var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> createNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-share-quota") Integer var6, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-enabled-protocols") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="x-ms-enable-snapshot-virtual-directory-access") Boolean var11, @HeaderParam(value="x-ms-share-paid-bursting-enabled") Boolean var12, @HeaderParam(value="x-ms-share-paid-bursting-max-bandwidth-mibps") Long var13, @HeaderParam(value="x-ms-share-paid-bursting-max-iops") Long var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="x-ms-share-provisioned-iops") Long var16, @HeaderParam(value="x-ms-share-provisioned-bandwidth-mibps") Long var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesCreateHeaders, Void> createSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-share-quota") Integer var6, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-enabled-protocols") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="x-ms-enable-snapshot-virtual-directory-access") Boolean var11, @HeaderParam(value="x-ms-share-paid-bursting-enabled") Boolean var12, @HeaderParam(value="x-ms-share-paid-bursting-max-bandwidth-mibps") Long var13, @HeaderParam(value="x-ms-share-paid-bursting-max-iops") Long var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="x-ms-share-provisioned-iops") Long var16, @HeaderParam(value="x-ms-share-provisioned-bandwidth-mibps") Long var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> createNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-share-quota") Integer var6, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-enabled-protocols") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="x-ms-enable-snapshot-virtual-directory-access") Boolean var11, @HeaderParam(value="x-ms-share-paid-bursting-enabled") Boolean var12, @HeaderParam(value="x-ms-share-paid-bursting-max-bandwidth-mibps") Long var13, @HeaderParam(value="x-ms-share-paid-bursting-max-iops") Long var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="x-ms-share-provisioned-iops") Long var16, @HeaderParam(value="x-ms-share-provisioned-bandwidth-mibps") Long var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesGetPropertiesHeaders, Void> getPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Delete(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> deleteNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Delete(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesDeleteHeaders, Void> deleteSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Delete(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> deleteNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesAcquireLeaseHeaders, Void>> acquireLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> acquireLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesAcquireLeaseHeaders, Void> acquireLeaseSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> acquireLeaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesReleaseLeaseHeaders, Void>> releaseLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> releaseLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesReleaseLeaseHeaders, Void> releaseLeaseSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> releaseLeaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesChangeLeaseHeaders, Void>> changeLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> changeLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesChangeLeaseHeaders, Void> changeLeaseSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> changeLeaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesRenewLeaseHeaders, Void>> renewLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> renewLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesRenewLeaseHeaders, Void> renewLeaseSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> renewLeaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesBreakLeaseHeaders, Void>> breakLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="sharesnapshot") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> breakLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="sharesnapshot") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesBreakLeaseHeaders, Void> breakLeaseSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="sharesnapshot") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> breakLeaseNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="sharesnapshot") String var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesCreateSnapshotHeaders, Void>> createSnapshot(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> createSnapshotNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesCreateSnapshotHeaders, Void> createSnapshotSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> createSnapshotNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesCreatePermissionHeaders, Void>> createPermission(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var7, @BodyParam(value="application/json") SharePermission var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> createPermissionNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var7, @BodyParam(value="application/json") SharePermission var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesCreatePermissionHeaders, Void> createPermissionSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var7, @BodyParam(value="application/json") SharePermission var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> createPermissionNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var7, @BodyParam(value="application/json") SharePermission var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesGetPermissionHeaders, SharePermission>> getPermission(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-file-permission-key") String var5, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<SharePermission>> getPermissionNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-file-permission-key") String var5, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesGetPermissionHeaders, SharePermission> getPermissionSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-file-permission-key") String var5, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<SharePermission> getPermissionNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-file-permission-key") String var5, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-share-quota") Integer var7, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="x-ms-enable-snapshot-virtual-directory-access") Boolean var11, @HeaderParam(value="x-ms-share-paid-bursting-enabled") Boolean var12, @HeaderParam(value="x-ms-share-paid-bursting-max-bandwidth-mibps") Long var13, @HeaderParam(value="x-ms-share-paid-bursting-max-iops") Long var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="x-ms-share-provisioned-iops") Long var16, @HeaderParam(value="x-ms-share-provisioned-bandwidth-mibps") Long var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-share-quota") Integer var7, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="x-ms-enable-snapshot-virtual-directory-access") Boolean var11, @HeaderParam(value="x-ms-share-paid-bursting-enabled") Boolean var12, @HeaderParam(value="x-ms-share-paid-bursting-max-bandwidth-mibps") Long var13, @HeaderParam(value="x-ms-share-paid-bursting-max-iops") Long var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="x-ms-share-provisioned-iops") Long var16, @HeaderParam(value="x-ms-share-provisioned-bandwidth-mibps") Long var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesSetPropertiesHeaders, Void> setPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-share-quota") Integer var7, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="x-ms-enable-snapshot-virtual-directory-access") Boolean var11, @HeaderParam(value="x-ms-share-paid-bursting-enabled") Boolean var12, @HeaderParam(value="x-ms-share-paid-bursting-max-bandwidth-mibps") Long var13, @HeaderParam(value="x-ms-share-paid-bursting-max-iops") Long var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="x-ms-share-provisioned-iops") Long var16, @HeaderParam(value="x-ms-share-provisioned-bandwidth-mibps") Long var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> setPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-share-quota") Integer var7, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="x-ms-enable-snapshot-virtual-directory-access") Boolean var11, @HeaderParam(value="x-ms-share-paid-bursting-enabled") Boolean var12, @HeaderParam(value="x-ms-share-paid-bursting-max-bandwidth-mibps") Long var13, @HeaderParam(value="x-ms-share-paid-bursting-max-iops") Long var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="x-ms-share-provisioned-iops") Long var16, @HeaderParam(value="x-ms-share-provisioned-bandwidth-mibps") Long var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesSetMetadataHeaders, Void>> setMetadata(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> setMetadataNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesSetMetadataHeaders, Void> setMetadataSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> setMetadataNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper>> getAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<ShareSignedIdentifierWrapper>> getAccessPolicyNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper> getAccessPolicySync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<ShareSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesSetAccessPolicyHeaders, Void>> setAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @BodyParam(value="application/xml") ShareSignedIdentifierWrapper var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> setAccessPolicyNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @BodyParam(value="application/xml") ShareSignedIdentifierWrapper var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesSetAccessPolicyHeaders, Void> setAccessPolicySync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @BodyParam(value="application/xml") ShareSignedIdentifierWrapper var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> setAccessPolicyNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @BodyParam(value="application/xml") ShareSignedIdentifierWrapper var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesGetStatisticsHeaders, ShareStats>> getStatistics(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<ShareStats>> getStatisticsNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesGetStatisticsHeaders, ShareStats> getStatisticsSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<ShareStats> getStatisticsNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<SharesRestoreHeaders, Void>> restore(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-deleted-share-name") String var8, @HeaderParam(value="x-ms-deleted-share-version") String var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> restoreNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-deleted-share-name") String var8, @HeaderParam(value="x-ms-deleted-share-version") String var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<SharesRestoreHeaders, Void> restoreSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-deleted-share-name") String var8, @HeaderParam(value="x-ms-deleted-share-version") String var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> restoreNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-deleted-share-name") String var8, @HeaderParam(value="x-ms-deleted-share-version") String var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);
    }
}

