/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesDeleteHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesListFilesAndDirectoriesSegmentHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesRenameHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.ListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.ListFilesIncludeType;
import com.azure.storage.file.share.implementation.models.ListHandlesResponse;
import com.azure.storage.file.share.implementation.models.ShareStorageExceptionInternal;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.models.FilePermissionFormat;
import com.azure.storage.file.share.models.ShareTokenIntent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class DirectoriesImpl {
    private final DirectoriesService service;
    private final AzureFileStorageImpl client;

    DirectoriesImpl(AzureFileStorageImpl client) {
        this.service = (DirectoriesService)RestProxy.create(DirectoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesCreateHeaders, Void>> createWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode) {
        return FluxUtil.withContext(context -> this.createWithResponseAsync(shareName, directory, timeout, metadata, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesCreateHeaders, Void>> createWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), timeout, metadata, this.client.getVersion(), filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, this.client.getFileRequestIntent(), owner, group, fileMode, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode) {
        return this.createWithResponseAsync(shareName, directory, timeout, metadata, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        return this.createWithResponseAsync(shareName, directory, timeout, metadata, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode) {
        return FluxUtil.withContext(context -> this.createNoCustomHeadersWithResponseAsync(shareName, directory, timeout, metadata, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.createNoCustomHeaders(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), timeout, metadata, this.client.getVersion(), filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, this.client.getFileRequestIntent(), owner, group, fileMode, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DirectoriesCreateHeaders, Void> createWithResponse(String shareName, String directory, Integer timeout, Map<String, String> metadata, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        try {
            String restype = "directory";
            String accept = "application/xml";
            return this.service.createSync(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), timeout, metadata, this.client.getVersion(), filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, this.client.getFileRequestIntent(), owner, group, fileMode, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create(String shareName, String directory, Integer timeout, Map<String, String> metadata, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode) {
        this.createWithResponse(shareName, directory, timeout, metadata, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String shareName, String directory, Integer timeout, Map<String, String> metadata, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        try {
            String restype = "directory";
            String accept = "application/xml";
            return this.service.createNoCustomHeadersSync(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), timeout, metadata, this.client.getVersion(), filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, this.client.getFileRequestIntent(), owner, group, fileMode, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName, String directory, String sharesnapshot, Integer timeout) {
        return FluxUtil.withContext(context -> this.getPropertiesWithResponseAsync(shareName, directory, sharesnapshot, timeout, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName, String directory, String sharesnapshot, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String directory, String sharesnapshot, Integer timeout) {
        return this.getPropertiesWithResponseAsync(shareName, directory, sharesnapshot, timeout).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String directory, String sharesnapshot, Integer timeout, Context context) {
        return this.getPropertiesWithResponseAsync(shareName, directory, sharesnapshot, timeout, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String shareName, String directory, String sharesnapshot, Integer timeout) {
        return FluxUtil.withContext(context -> this.getPropertiesNoCustomHeadersWithResponseAsync(shareName, directory, sharesnapshot, timeout, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String shareName, String directory, String sharesnapshot, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DirectoriesGetPropertiesHeaders, Void> getPropertiesWithResponse(String shareName, String directory, String sharesnapshot, Integer timeout, Context context) {
        try {
            String restype = "directory";
            String accept = "application/xml";
            return this.service.getPropertiesSync(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getProperties(String shareName, String directory, String sharesnapshot, Integer timeout) {
        this.getPropertiesWithResponse(shareName, directory, sharesnapshot, timeout, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getPropertiesNoCustomHeadersWithResponse(String shareName, String directory, String sharesnapshot, Integer timeout, Context context) {
        try {
            String restype = "directory";
            String accept = "application/xml";
            return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), sharesnapshot, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String directory, Integer timeout) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(shareName, directory, timeout, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String directory, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String directory, Integer timeout) {
        return this.deleteWithResponseAsync(shareName, directory, timeout).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String directory, Integer timeout, Context context) {
        return this.deleteWithResponseAsync(shareName, directory, timeout, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String shareName, String directory, Integer timeout) {
        return FluxUtil.withContext(context -> this.deleteNoCustomHeadersWithResponseAsync(shareName, directory, timeout, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String shareName, String directory, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.deleteNoCustomHeaders(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DirectoriesDeleteHeaders, Void> deleteWithResponse(String shareName, String directory, Integer timeout, Context context) {
        try {
            String restype = "directory";
            String accept = "application/xml";
            return this.service.deleteSync(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String shareName, String directory, Integer timeout) {
        this.deleteWithResponse(shareName, directory, timeout, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNoCustomHeadersWithResponse(String shareName, String directory, Integer timeout, Context context) {
        try {
            String restype = "directory";
            String accept = "application/xml";
            return this.service.deleteNoCustomHeadersSync(this.client.getUrl(), shareName, directory, "directory", this.client.isAllowTrailingDot(), timeout, this.client.getVersion(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String shareName, String directory, Integer timeout, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode) {
        return FluxUtil.withContext(context -> this.setPropertiesWithResponseAsync(shareName, directory, timeout, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String shareName, String directory, Integer timeout, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        String restype = "directory";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), shareName, directory, "directory", "properties", timeout, this.client.getVersion(), filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), owner, group, fileMode, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String shareName, String directory, Integer timeout, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode) {
        return this.setPropertiesWithResponseAsync(shareName, directory, timeout, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String shareName, String directory, Integer timeout, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        return this.setPropertiesWithResponseAsync(shareName, directory, timeout, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(String shareName, String directory, Integer timeout, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode) {
        return FluxUtil.withContext(context -> this.setPropertiesNoCustomHeadersWithResponseAsync(shareName, directory, timeout, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(String shareName, String directory, Integer timeout, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        String restype = "directory";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), shareName, directory, "directory", "properties", timeout, this.client.getVersion(), filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), owner, group, fileMode, "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DirectoriesSetPropertiesHeaders, Void> setPropertiesWithResponse(String shareName, String directory, Integer timeout, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        try {
            String restype = "directory";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.setPropertiesSync(this.client.getUrl(), shareName, directory, "directory", "properties", timeout, this.client.getVersion(), filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), owner, group, fileMode, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(String shareName, String directory, Integer timeout, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode) {
        this.setPropertiesWithResponse(shareName, directory, timeout, filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, owner, group, fileMode, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesNoCustomHeadersWithResponse(String shareName, String directory, Integer timeout, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, String fileAttributes, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String owner, String group, String fileMode, Context context) {
        try {
            String restype = "directory";
            String comp = "properties";
            String accept = "application/xml";
            return this.service.setPropertiesNoCustomHeadersSync(this.client.getUrl(), shareName, directory, "directory", "properties", timeout, this.client.getVersion(), filePermission, filePermissionFormat, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), owner, group, fileMode, "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata) {
        return FluxUtil.withContext(context -> this.setMetadataWithResponseAsync(shareName, directory, timeout, metadata, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "directory";
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), shareName, directory, "directory", "metadata", timeout, metadata, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata) {
        return this.setMetadataWithResponseAsync(shareName, directory, timeout, metadata).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, Context context) {
        return this.setMetadataWithResponseAsync(shareName, directory, timeout, metadata, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata) {
        return FluxUtil.withContext(context -> this.setMetadataNoCustomHeadersWithResponseAsync(shareName, directory, timeout, metadata, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "directory";
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadataNoCustomHeaders(this.client.getUrl(), shareName, directory, "directory", "metadata", timeout, metadata, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DirectoriesSetMetadataHeaders, Void> setMetadataWithResponse(String shareName, String directory, Integer timeout, Map<String, String> metadata, Context context) {
        try {
            String restype = "directory";
            String comp = "metadata";
            String accept = "application/xml";
            return this.service.setMetadataSync(this.client.getUrl(), shareName, directory, "directory", "metadata", timeout, metadata, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(String shareName, String directory, Integer timeout, Map<String, String> metadata) {
        this.setMetadataWithResponse(shareName, directory, timeout, metadata, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataNoCustomHeadersWithResponse(String shareName, String directory, Integer timeout, Map<String, String> metadata, Context context) {
        try {
            String restype = "directory";
            String comp = "metadata";
            String accept = "application/xml";
            return this.service.setMetadataNoCustomHeadersSync(this.client.getUrl(), shareName, directory, "directory", "metadata", timeout, metadata, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesListFilesAndDirectoriesSegmentHeaders, ListFilesAndDirectoriesSegmentResponse>> listFilesAndDirectoriesSegmentWithResponseAsync(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo) {
        return FluxUtil.withContext(context -> this.listFilesAndDirectoriesSegmentWithResponseAsync(shareName, directory, prefix, sharesnapshot, marker, maxresults, timeout, include, includeExtendedInfo, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesListFilesAndDirectoriesSegmentHeaders, ListFilesAndDirectoriesSegmentResponse>> listFilesAndDirectoriesSegmentWithResponseAsync(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo, Context context) {
        String restype = "directory";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listFilesAndDirectoriesSegment(this.client.getUrl(), shareName, directory, "directory", "list", prefix, sharesnapshot, marker, maxresults, timeout, this.client.getVersion(), includeConverted, includeExtendedInfo, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentAsync(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo) {
        return this.listFilesAndDirectoriesSegmentWithResponseAsync(shareName, directory, prefix, sharesnapshot, marker, maxresults, timeout, include, includeExtendedInfo).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ListFilesAndDirectoriesSegmentResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentAsync(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo, Context context) {
        return this.listFilesAndDirectoriesSegmentWithResponseAsync(shareName, directory, prefix, sharesnapshot, marker, maxresults, timeout, include, includeExtendedInfo, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ListFilesAndDirectoriesSegmentResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListFilesAndDirectoriesSegmentResponse>> listFilesAndDirectoriesSegmentNoCustomHeadersWithResponseAsync(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo) {
        return FluxUtil.withContext(context -> this.listFilesAndDirectoriesSegmentNoCustomHeadersWithResponseAsync(shareName, directory, prefix, sharesnapshot, marker, maxresults, timeout, include, includeExtendedInfo, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListFilesAndDirectoriesSegmentResponse>> listFilesAndDirectoriesSegmentNoCustomHeadersWithResponseAsync(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo, Context context) {
        String restype = "directory";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listFilesAndDirectoriesSegmentNoCustomHeaders(this.client.getUrl(), shareName, directory, "directory", "list", prefix, sharesnapshot, marker, maxresults, timeout, this.client.getVersion(), includeConverted, includeExtendedInfo, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DirectoriesListFilesAndDirectoriesSegmentHeaders, ListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentWithResponse(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo, Context context) {
        try {
            String restype = "directory";
            String comp = "list";
            String accept = "application/xml";
            String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            return this.service.listFilesAndDirectoriesSegmentSync(this.client.getUrl(), shareName, directory, "directory", "list", prefix, sharesnapshot, marker, maxresults, timeout, this.client.getVersion(), includeConverted, includeExtendedInfo, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListFilesAndDirectoriesSegmentResponse listFilesAndDirectoriesSegment(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo) {
        try {
            return (ListFilesAndDirectoriesSegmentResponse)this.listFilesAndDirectoriesSegmentWithResponse(shareName, directory, prefix, sharesnapshot, marker, maxresults, timeout, include, includeExtendedInfo, Context.NONE).getValue();
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentNoCustomHeadersWithResponse(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo, Context context) {
        try {
            String restype = "directory";
            String comp = "list";
            String accept = "application/xml";
            String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
            return this.service.listFilesAndDirectoriesSegmentNoCustomHeadersSync(this.client.getUrl(), shareName, directory, "directory", "list", prefix, sharesnapshot, marker, maxresults, timeout, this.client.getVersion(), includeConverted, includeExtendedInfo, this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesListHandlesHeaders, ListHandlesResponse>> listHandlesWithResponseAsync(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive) {
        return FluxUtil.withContext(context -> this.listHandlesWithResponseAsync(shareName, directory, marker, maxresults, timeout, sharesnapshot, recursive, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesListHandlesHeaders, ListHandlesResponse>> listHandlesWithResponseAsync(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandles(this.client.getUrl(), shareName, directory, "listhandles", marker, maxresults, timeout, sharesnapshot, recursive, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListHandlesResponse> listHandlesAsync(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive) {
        return this.listHandlesWithResponseAsync(shareName, directory, marker, maxresults, timeout, sharesnapshot, recursive).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ListHandlesResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListHandlesResponse> listHandlesAsync(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive, Context context) {
        return this.listHandlesWithResponseAsync(shareName, directory, marker, maxresults, timeout, sharesnapshot, recursive, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ListHandlesResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListHandlesResponse>> listHandlesNoCustomHeadersWithResponseAsync(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive) {
        return FluxUtil.withContext(context -> this.listHandlesNoCustomHeadersWithResponseAsync(shareName, directory, marker, maxresults, timeout, sharesnapshot, recursive, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListHandlesResponse>> listHandlesNoCustomHeadersWithResponseAsync(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandlesNoCustomHeaders(this.client.getUrl(), shareName, directory, "listhandles", marker, maxresults, timeout, sharesnapshot, recursive, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DirectoriesListHandlesHeaders, ListHandlesResponse> listHandlesWithResponse(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive, Context context) {
        try {
            String comp = "listhandles";
            String accept = "application/xml";
            return this.service.listHandlesSync(this.client.getUrl(), shareName, directory, "listhandles", marker, maxresults, timeout, sharesnapshot, recursive, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListHandlesResponse listHandles(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive) {
        try {
            return (ListHandlesResponse)this.listHandlesWithResponse(shareName, directory, marker, maxresults, timeout, sharesnapshot, recursive, Context.NONE).getValue();
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListHandlesResponse> listHandlesNoCustomHeadersWithResponse(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive, Context context) {
        try {
            String comp = "listhandles";
            String accept = "application/xml";
            return this.service.listHandlesNoCustomHeadersSync(this.client.getUrl(), shareName, directory, "listhandles", marker, maxresults, timeout, sharesnapshot, recursive, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesForceCloseHandlesHeaders, Void>> forceCloseHandlesWithResponseAsync(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive) {
        return FluxUtil.withContext(context -> this.forceCloseHandlesWithResponseAsync(shareName, directory, handleId, timeout, marker, sharesnapshot, recursive, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesForceCloseHandlesHeaders, Void>> forceCloseHandlesWithResponseAsync(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandles(this.client.getUrl(), shareName, directory, "forceclosehandles", timeout, marker, sharesnapshot, handleId, recursive, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> forceCloseHandlesAsync(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive) {
        return this.forceCloseHandlesWithResponseAsync(shareName, directory, handleId, timeout, marker, sharesnapshot, recursive).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> forceCloseHandlesAsync(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive, Context context) {
        return this.forceCloseHandlesWithResponseAsync(shareName, directory, handleId, timeout, marker, sharesnapshot, recursive, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> forceCloseHandlesNoCustomHeadersWithResponseAsync(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive) {
        return FluxUtil.withContext(context -> this.forceCloseHandlesNoCustomHeadersWithResponseAsync(shareName, directory, handleId, timeout, marker, sharesnapshot, recursive, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> forceCloseHandlesNoCustomHeadersWithResponseAsync(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandlesNoCustomHeaders(this.client.getUrl(), shareName, directory, "forceclosehandles", timeout, marker, sharesnapshot, handleId, recursive, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DirectoriesForceCloseHandlesHeaders, Void> forceCloseHandlesWithResponse(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive, Context context) {
        try {
            String comp = "forceclosehandles";
            String accept = "application/xml";
            return this.service.forceCloseHandlesSync(this.client.getUrl(), shareName, directory, "forceclosehandles", timeout, marker, sharesnapshot, handleId, recursive, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void forceCloseHandles(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive) {
        this.forceCloseHandlesWithResponse(shareName, directory, handleId, timeout, marker, sharesnapshot, recursive, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> forceCloseHandlesNoCustomHeadersWithResponse(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive, Context context) {
        try {
            String comp = "forceclosehandles";
            String accept = "application/xml";
            return this.service.forceCloseHandlesNoCustomHeadersSync(this.client.getUrl(), shareName, directory, "forceclosehandles", timeout, marker, sharesnapshot, handleId, recursive, this.client.getVersion(), this.client.isAllowTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesRenameHeaders, Void>> renameWithResponseAsync(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo) {
        return FluxUtil.withContext(context -> this.renameWithResponseAsync(shareName, directory, renameSource, timeout, replaceIfExists, ignoreReadOnly, filePermission, filePermissionFormat, filePermissionKey, metadata, sourceLeaseAccessConditions, destinationLeaseAccessConditions, copyFileSmbInfo, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesRenameHeaders, Void>> renameWithResponseAsync(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        String restype = "directory";
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        return this.service.rename(this.client.getUrl(), shareName, directory, "directory", "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionFormat, filePermissionKey, metadata, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameAsync(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo) {
        return this.renameWithResponseAsync(shareName, directory, renameSource, timeout, replaceIfExists, ignoreReadOnly, filePermission, filePermissionFormat, filePermissionKey, metadata, sourceLeaseAccessConditions, destinationLeaseAccessConditions, copyFileSmbInfo).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameAsync(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        return this.renameWithResponseAsync(shareName, directory, renameSource, timeout, replaceIfExists, ignoreReadOnly, filePermission, filePermissionFormat, filePermissionKey, metadata, sourceLeaseAccessConditions, destinationLeaseAccessConditions, copyFileSmbInfo, context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameNoCustomHeadersWithResponseAsync(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo) {
        return FluxUtil.withContext(context -> this.renameNoCustomHeadersWithResponseAsync(shareName, directory, renameSource, timeout, replaceIfExists, ignoreReadOnly, filePermission, filePermissionFormat, filePermissionKey, metadata, sourceLeaseAccessConditions, destinationLeaseAccessConditions, copyFileSmbInfo, (Context)context)).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameNoCustomHeadersWithResponseAsync(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        String restype = "directory";
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        return this.service.renameNoCustomHeaders(this.client.getUrl(), shareName, directory, "directory", "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionFormat, filePermissionKey, metadata, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context).onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DirectoriesRenameHeaders, Void> renameWithResponse(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        try {
            String restype = "directory";
            String comp = "rename";
            String accept = "application/xml";
            String sourceLeaseIdInternal = null;
            if (sourceLeaseAccessConditions != null) {
                sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
            }
            String sourceLeaseId = sourceLeaseIdInternal;
            String destinationLeaseIdInternal = null;
            if (destinationLeaseAccessConditions != null) {
                destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
            }
            String destinationLeaseId = destinationLeaseIdInternal;
            String fileAttributesInternal = null;
            if (copyFileSmbInfo != null) {
                fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
            }
            String fileAttributes = fileAttributesInternal;
            String fileCreationTimeInternal = null;
            if (copyFileSmbInfo != null) {
                fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
            }
            String fileCreationTime = fileCreationTimeInternal;
            String fileLastWriteTimeInternal = null;
            if (copyFileSmbInfo != null) {
                fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
            }
            String fileLastWriteTime = fileLastWriteTimeInternal;
            String fileChangeTimeInternal = null;
            if (copyFileSmbInfo != null) {
                fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
            }
            String fileChangeTime = fileChangeTimeInternal;
            return this.service.renameSync(this.client.getUrl(), shareName, directory, "directory", "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionFormat, filePermissionKey, metadata, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rename(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo) {
        this.renameWithResponse(shareName, directory, renameSource, timeout, replaceIfExists, ignoreReadOnly, filePermission, filePermissionFormat, filePermissionKey, metadata, sourceLeaseAccessConditions, destinationLeaseAccessConditions, copyFileSmbInfo, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameNoCustomHeadersWithResponse(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, FilePermissionFormat filePermissionFormat, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        try {
            String restype = "directory";
            String comp = "rename";
            String accept = "application/xml";
            String sourceLeaseIdInternal = null;
            if (sourceLeaseAccessConditions != null) {
                sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
            }
            String sourceLeaseId = sourceLeaseIdInternal;
            String destinationLeaseIdInternal = null;
            if (destinationLeaseAccessConditions != null) {
                destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
            }
            String destinationLeaseId = destinationLeaseIdInternal;
            String fileAttributesInternal = null;
            if (copyFileSmbInfo != null) {
                fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
            }
            String fileAttributes = fileAttributesInternal;
            String fileCreationTimeInternal = null;
            if (copyFileSmbInfo != null) {
                fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
            }
            String fileCreationTime = fileCreationTimeInternal;
            String fileLastWriteTimeInternal = null;
            if (copyFileSmbInfo != null) {
                fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
            }
            String fileLastWriteTime = fileLastWriteTimeInternal;
            String fileChangeTimeInternal = null;
            if (copyFileSmbInfo != null) {
                fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
            }
            String fileChangeTime = fileChangeTimeInternal;
            return this.service.renameNoCustomHeadersSync(this.client.getUrl(), shareName, directory, "directory", "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionFormat, filePermissionKey, metadata, this.client.isAllowTrailingDot(), this.client.isAllowSourceTrailingDot(), this.client.getFileRequestIntent(), "application/xml", context);
        }
        catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageDirectories")
    public static interface DirectoriesService {
        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<DirectoriesCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-permission") String var9, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var10, @HeaderParam(value="x-ms-file-permission-key") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var16, @HeaderParam(value="x-ms-owner") String var17, @HeaderParam(value="x-ms-group") String var18, @HeaderParam(value="x-ms-mode") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> createNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-permission") String var9, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var10, @HeaderParam(value="x-ms-file-permission-key") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var16, @HeaderParam(value="x-ms-owner") String var17, @HeaderParam(value="x-ms-group") String var18, @HeaderParam(value="x-ms-mode") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<DirectoriesCreateHeaders, Void> createSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-permission") String var9, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var10, @HeaderParam(value="x-ms-file-permission-key") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var16, @HeaderParam(value="x-ms-owner") String var17, @HeaderParam(value="x-ms-group") String var18, @HeaderParam(value="x-ms-mode") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> createNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-permission") String var9, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var10, @HeaderParam(value="x-ms-file-permission-key") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var16, @HeaderParam(value="x-ms-owner") String var17, @HeaderParam(value="x-ms-group") String var18, @HeaderParam(value="x-ms-mode") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<DirectoriesGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="sharesnapshot") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="sharesnapshot") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<DirectoriesGetPropertiesHeaders, Void> getPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="sharesnapshot") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="sharesnapshot") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Delete(value="/{shareName}/{directory}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<DirectoriesDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{shareName}/{directory}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> deleteNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{shareName}/{directory}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<DirectoriesDeleteHeaders, Void> deleteSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{shareName}/{directory}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> deleteNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<DirectoriesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var9, @HeaderParam(value="x-ms-file-permission-key") String var10, @HeaderParam(value="x-ms-file-attributes") String var11, @HeaderParam(value="x-ms-file-creation-time") String var12, @HeaderParam(value="x-ms-file-last-write-time") String var13, @HeaderParam(value="x-ms-file-change-time") String var14, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var15, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var16, @HeaderParam(value="x-ms-owner") String var17, @HeaderParam(value="x-ms-group") String var18, @HeaderParam(value="x-ms-mode") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var9, @HeaderParam(value="x-ms-file-permission-key") String var10, @HeaderParam(value="x-ms-file-attributes") String var11, @HeaderParam(value="x-ms-file-creation-time") String var12, @HeaderParam(value="x-ms-file-last-write-time") String var13, @HeaderParam(value="x-ms-file-change-time") String var14, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var15, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var16, @HeaderParam(value="x-ms-owner") String var17, @HeaderParam(value="x-ms-group") String var18, @HeaderParam(value="x-ms-mode") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<DirectoriesSetPropertiesHeaders, Void> setPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var9, @HeaderParam(value="x-ms-file-permission-key") String var10, @HeaderParam(value="x-ms-file-attributes") String var11, @HeaderParam(value="x-ms-file-creation-time") String var12, @HeaderParam(value="x-ms-file-last-write-time") String var13, @HeaderParam(value="x-ms-file-change-time") String var14, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var15, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var16, @HeaderParam(value="x-ms-owner") String var17, @HeaderParam(value="x-ms-group") String var18, @HeaderParam(value="x-ms-mode") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> setPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var9, @HeaderParam(value="x-ms-file-permission-key") String var10, @HeaderParam(value="x-ms-file-attributes") String var11, @HeaderParam(value="x-ms-file-creation-time") String var12, @HeaderParam(value="x-ms-file-last-write-time") String var13, @HeaderParam(value="x-ms-file-change-time") String var14, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var15, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var16, @HeaderParam(value="x-ms-owner") String var17, @HeaderParam(value="x-ms-group") String var18, @HeaderParam(value="x-ms-mode") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<DirectoriesSetMetadataHeaders, Void>> setMetadata(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> setMetadataNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<DirectoriesSetMetadataHeaders, Void> setMetadataSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> setMetadataNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var9, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<DirectoriesListFilesAndDirectoriesSegmentHeaders, ListFilesAndDirectoriesSegmentResponse>> listFilesAndDirectoriesSegment(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="prefix") String var6, @QueryParam(value="sharesnapshot") String var7, @QueryParam(value="marker") String var8, @QueryParam(value="maxresults") Integer var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @QueryParam(value="include") String var12, @HeaderParam(value="x-ms-file-extended-info") Boolean var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<ListFilesAndDirectoriesSegmentResponse>> listFilesAndDirectoriesSegmentNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="prefix") String var6, @QueryParam(value="sharesnapshot") String var7, @QueryParam(value="marker") String var8, @QueryParam(value="maxresults") Integer var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @QueryParam(value="include") String var12, @HeaderParam(value="x-ms-file-extended-info") Boolean var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<DirectoriesListFilesAndDirectoriesSegmentHeaders, ListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="prefix") String var6, @QueryParam(value="sharesnapshot") String var7, @QueryParam(value="marker") String var8, @QueryParam(value="maxresults") Integer var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @QueryParam(value="include") String var12, @HeaderParam(value="x-ms-file-extended-info") Boolean var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<ListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="prefix") String var6, @QueryParam(value="sharesnapshot") String var7, @QueryParam(value="marker") String var8, @QueryParam(value="maxresults") Integer var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @QueryParam(value="include") String var12, @HeaderParam(value="x-ms-file-extended-info") Boolean var13, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var14, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<DirectoriesListHandlesHeaders, ListHandlesResponse>> listHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<ListHandlesResponse>> listHandlesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<DirectoriesListHandlesHeaders, ListHandlesResponse> listHandlesSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<ListHandlesResponse> listHandlesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<DirectoriesForceCloseHandlesHeaders, Void>> forceCloseHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> forceCloseHandlesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<DirectoriesForceCloseHandlesHeaders, Void> forceCloseHandlesSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> forceCloseHandlesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var11, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<ResponseBase<DirectoriesRenameHeaders, Void>> rename(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-rename-source") String var8, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var9, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var10, @HeaderParam(value="x-ms-source-lease-id") String var11, @HeaderParam(value="x-ms-destination-lease-id") String var12, @HeaderParam(value="x-ms-file-attributes") String var13, @HeaderParam(value="x-ms-file-creation-time") String var14, @HeaderParam(value="x-ms-file-last-write-time") String var15, @HeaderParam(value="x-ms-file-change-time") String var16, @HeaderParam(value="x-ms-file-permission") String var17, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var18, @HeaderParam(value="x-ms-file-permission-key") String var19, @HeaderParam(value="x-ms-meta-") Map<String, String> var20, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var22, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var23, @HeaderParam(value="Accept") String var24, Context var25);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Mono<Response<Void>> renameNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-rename-source") String var8, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var9, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var10, @HeaderParam(value="x-ms-source-lease-id") String var11, @HeaderParam(value="x-ms-destination-lease-id") String var12, @HeaderParam(value="x-ms-file-attributes") String var13, @HeaderParam(value="x-ms-file-creation-time") String var14, @HeaderParam(value="x-ms-file-last-write-time") String var15, @HeaderParam(value="x-ms-file-change-time") String var16, @HeaderParam(value="x-ms-file-permission") String var17, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var18, @HeaderParam(value="x-ms-file-permission-key") String var19, @HeaderParam(value="x-ms-meta-") Map<String, String> var20, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var22, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var23, @HeaderParam(value="Accept") String var24, Context var25);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public ResponseBase<DirectoriesRenameHeaders, Void> renameSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-rename-source") String var8, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var9, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var10, @HeaderParam(value="x-ms-source-lease-id") String var11, @HeaderParam(value="x-ms-destination-lease-id") String var12, @HeaderParam(value="x-ms-file-attributes") String var13, @HeaderParam(value="x-ms-file-creation-time") String var14, @HeaderParam(value="x-ms-file-last-write-time") String var15, @HeaderParam(value="x-ms-file-change-time") String var16, @HeaderParam(value="x-ms-file-permission") String var17, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var18, @HeaderParam(value="x-ms-file-permission-key") String var19, @HeaderParam(value="x-ms-meta-") Map<String, String> var20, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var22, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var23, @HeaderParam(value="Accept") String var24, Context var25);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageExceptionInternal.class)
        public Response<Void> renameNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-rename-source") String var8, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var9, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var10, @HeaderParam(value="x-ms-source-lease-id") String var11, @HeaderParam(value="x-ms-destination-lease-id") String var12, @HeaderParam(value="x-ms-file-attributes") String var13, @HeaderParam(value="x-ms-file-creation-time") String var14, @HeaderParam(value="x-ms-file-last-write-time") String var15, @HeaderParam(value="x-ms-file-change-time") String var16, @HeaderParam(value="x-ms-file-permission") String var17, @HeaderParam(value="x-ms-file-permission-format") FilePermissionFormat var18, @HeaderParam(value="x-ms-file-permission-key") String var19, @HeaderParam(value="x-ms-meta-") Map<String, String> var20, @HeaderParam(value="x-ms-allow-trailing-dot") Boolean var21, @HeaderParam(value="x-ms-source-allow-trailing-dot") Boolean var22, @HeaderParam(value="x-ms-file-request-intent") ShareTokenIntent var23, @HeaderParam(value="Accept") String var24, Context var25);
    }
}

