/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.DirectoriesImpl;
import com.azure.storage.file.share.implementation.FilesImpl;
import com.azure.storage.file.share.implementation.ServicesImpl;
import com.azure.storage.file.share.implementation.SharesImpl;
import com.azure.storage.file.share.models.ShareTokenIntent;

public final class AzureFileStorageImpl {
    private final String version;
    private final ShareTokenIntent fileRequestIntent;
    private final String url;
    private final boolean allowTrailingDot;
    private final boolean allowSourceTrailingDot;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final ServicesImpl services;
    private final SharesImpl shares;
    private final DirectoriesImpl directories;
    private final FilesImpl files;

    public String getVersion() {
        return this.version;
    }

    public ShareTokenIntent getFileRequestIntent() {
        return this.fileRequestIntent;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isAllowTrailingDot() {
        return this.allowTrailingDot;
    }

    public boolean isAllowSourceTrailingDot() {
        return this.allowSourceTrailingDot;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ServicesImpl getServices() {
        return this.services;
    }

    public SharesImpl getShares() {
        return this.shares;
    }

    public DirectoriesImpl getDirectories() {
        return this.directories;
    }

    public FilesImpl getFiles() {
        return this.files;
    }

    public AzureFileStorageImpl(String version, ShareTokenIntent fileRequestIntent, String url, boolean allowTrailingDot, boolean allowSourceTrailingDot) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), version, fileRequestIntent, url, allowTrailingDot, allowSourceTrailingDot);
    }

    public AzureFileStorageImpl(HttpPipeline httpPipeline, String version, ShareTokenIntent fileRequestIntent, String url, boolean allowTrailingDot, boolean allowSourceTrailingDot) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), version, fileRequestIntent, url, allowTrailingDot, allowSourceTrailingDot);
    }

    public AzureFileStorageImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String version, ShareTokenIntent fileRequestIntent, String url, boolean allowTrailingDot, boolean allowSourceTrailingDot) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.version = version;
        this.fileRequestIntent = fileRequestIntent;
        this.url = url;
        this.allowTrailingDot = allowTrailingDot;
        this.allowSourceTrailingDot = allowSourceTrailingDot;
        this.services = new ServicesImpl(this);
        this.shares = new SharesImpl(this);
        this.directories = new DirectoriesImpl(this);
        this.files = new FilesImpl(this);
    }
}

