// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The retention policy.
 */
@Fluent
public final class ShareRetentionPolicy implements XmlSerializable<ShareRetentionPolicy> {
    /*
     * Indicates whether a retention policy is enabled for the File service. If false, metrics data is retained, and the
     * user is responsible for deleting it.
     */
    @Generated
    private boolean enabled;

    /*
     * Indicates the number of days that metrics data should be retained. All data older than this value will be
     * deleted. Metrics data is deleted on a best-effort basis after the retention period expires.
     */
    @Generated
    private Integer days;

    /**
     * Creates an instance of ShareRetentionPolicy class.
     */
    @Generated
    public ShareRetentionPolicy() {
    }

    /**
     * Get the enabled property: Indicates whether a retention policy is enabled for the File service. If false, metrics
     * data is retained, and the user is responsible for deleting it.
     * 
     * @return the enabled value.
     */
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether a retention policy is enabled for the File service. If false, metrics
     * data is retained, and the user is responsible for deleting it.
     * 
     * @param enabled the enabled value to set.
     * @return the ShareRetentionPolicy object itself.
     */
    @Generated
    public ShareRetentionPolicy setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the days property: Indicates the number of days that metrics data should be retained. All data older than
     * this value will be deleted. Metrics data is deleted on a best-effort basis after the retention period expires.
     * 
     * @return the days value.
     */
    @Generated
    public Integer getDays() {
        return this.days;
    }

    /**
     * Set the days property: Indicates the number of days that metrics data should be retained. All data older than
     * this value will be deleted. Metrics data is deleted on a best-effort basis after the retention period expires.
     * 
     * @param days the days value to set.
     * @return the ShareRetentionPolicy object itself.
     */
    @Generated
    public ShareRetentionPolicy setDays(Integer days) {
        this.days = days;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "ShareRetentionPolicy" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeNumberElement("Days", this.days);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of ShareRetentionPolicy from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of ShareRetentionPolicy if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ShareRetentionPolicy.
     */
    @Generated
    public static ShareRetentionPolicy fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of ShareRetentionPolicy from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of ShareRetentionPolicy if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ShareRetentionPolicy.
     */
    @Generated
    public static ShareRetentionPolicy fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "ShareRetentionPolicy" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareRetentionPolicy deserializedShareRetentionPolicy = new ShareRetentionPolicy();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedShareRetentionPolicy.enabled = reader.getBooleanElement();
                } else if ("Days".equals(elementName.getLocalPart())) {
                    deserializedShareRetentionPolicy.days = reader.getNullableElement(Integer::parseInt);
                } else {
                    reader.skipElement();
                }
            }

            return deserializedShareRetentionPolicy;
        });
    }
}
