// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Storage Analytics metrics for file service.
 */
@Fluent
public final class ShareMetrics implements XmlSerializable<ShareMetrics> {
    /*
     * The version of Storage Analytics to configure.
     */
    @Generated
    private String version;

    /*
     * Indicates whether metrics are enabled for the File service.
     */
    @Generated
    private boolean enabled;

    /*
     * Indicates whether metrics should generate summary statistics for called API operations.
     */
    @Generated
    private Boolean includeApis;

    /*
     * The retention policy.
     */
    @Generated
    private ShareRetentionPolicy retentionPolicy;

    /**
     * Creates an instance of ShareMetrics class.
     */
    @Generated
    public ShareMetrics() {
    }

    /**
     * Get the version property: The version of Storage Analytics to configure.
     * 
     * @return the version value.
     */
    @Generated
    public String getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The version of Storage Analytics to configure.
     * 
     * @param version the version value to set.
     * @return the ShareMetrics object itself.
     */
    @Generated
    public ShareMetrics setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the enabled property: Indicates whether metrics are enabled for the File service.
     * 
     * @return the enabled value.
     */
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether metrics are enabled for the File service.
     * 
     * @param enabled the enabled value to set.
     * @return the ShareMetrics object itself.
     */
    @Generated
    public ShareMetrics setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the includeApis property: Indicates whether metrics should generate summary statistics for called API
     * operations.
     * 
     * @return the includeApis value.
     */
    @Generated
    public Boolean isIncludeApis() {
        return this.includeApis;
    }

    /**
     * Set the includeApis property: Indicates whether metrics should generate summary statistics for called API
     * operations.
     * 
     * @param includeApis the includeApis value to set.
     * @return the ShareMetrics object itself.
     */
    @Generated
    public ShareMetrics setIncludeApis(Boolean includeApis) {
        this.includeApis = includeApis;
        return this;
    }

    /**
     * Get the retentionPolicy property: The retention policy.
     * 
     * @return the retentionPolicy value.
     */
    @Generated
    public ShareRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set the retentionPolicy property: The retention policy.
     * 
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the ShareMetrics object itself.
     */
    @Generated
    public ShareMetrics setRetentionPolicy(ShareRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "ShareMetrics" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeBooleanElement("IncludeAPIs", this.includeApis);
        xmlWriter.writeXml(this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of ShareMetrics from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of ShareMetrics if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ShareMetrics.
     */
    @Generated
    public static ShareMetrics fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of ShareMetrics from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of ShareMetrics if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ShareMetrics.
     */
    @Generated
    public static ShareMetrics fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "ShareMetrics" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareMetrics deserializedShareMetrics = new ShareMetrics();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedShareMetrics.version = reader.getStringElement();
                } else if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedShareMetrics.enabled = reader.getBooleanElement();
                } else if ("IncludeAPIs".equals(elementName.getLocalPart())) {
                    deserializedShareMetrics.includeApis = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedShareMetrics.retentionPolicy = ShareRetentionPolicy.fromXml(reader, "RetentionPolicy");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedShareMetrics;
        });
    }
}
