// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

/**
 * The SharesSetPropertiesHeaders model.
 */
@Fluent
public final class SharesSetPropertiesHeaders {
    /*
     * The x-ms-share-provisioned-iops property.
     */
    @Generated
    private Long xMsShareProvisionedIops;

    /*
     * The x-ms-share-included-burst-iops property.
     */
    @Generated
    private Long xMsShareIncludedBurstIops;

    /*
     * The x-ms-version property.
     */
    @Generated
    private String xMsVersion;

    /*
     * The x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time property.
     */
    @Generated
    private DateTimeRfc1123 xMsShareNextAllowedProvisionedBandwidthDowngradeTime;

    /*
     * The Last-Modified property.
     */
    @Generated
    private DateTimeRfc1123 lastModified;

    /*
     * The x-ms-share-max-burst-credits-for-iops property.
     */
    @Generated
    private Long xMsShareMaxBurstCreditsForIops;

    /*
     * The x-ms-share-next-allowed-provisioned-iops-downgrade-time property.
     */
    @Generated
    private DateTimeRfc1123 xMsShareNextAllowedProvisionedIopsDowngradeTime;

    /*
     * The Date property.
     */
    @Generated
    private DateTimeRfc1123 date;

    /*
     * The x-ms-share-provisioned-bandwidth-mibps property.
     */
    @Generated
    private Long xMsShareProvisionedBandwidthMibps;

    /*
     * The x-ms-share-quota property.
     */
    @Generated
    private Long xMsShareQuota;

    /*
     * The ETag property.
     */
    @Generated
    private String eTag;

    /*
     * The x-ms-request-id property.
     */
    @Generated
    private String xMsRequestId;

    /*
     * The x-ms-share-next-allowed-quota-downgrade-time property.
     */
    @Generated
    private DateTimeRfc1123 xMsShareNextAllowedQuotaDowngradeTime;

    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_IOPS
        = HttpHeaderName.fromString("x-ms-share-provisioned-iops");

    private static final HttpHeaderName X_MS_SHARE_INCLUDED_BURST_IOPS
        = HttpHeaderName.fromString("x-ms-share-included-burst-iops");

    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");

    private static final HttpHeaderName X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_BANDWIDTH_DOWNGRADE_TIME
        = HttpHeaderName.fromString("x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time");

    private static final HttpHeaderName X_MS_SHARE_MAX_BURST_CREDITS_FOR_IOPS
        = HttpHeaderName.fromString("x-ms-share-max-burst-credits-for-iops");

    private static final HttpHeaderName X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_IOPS_DOWNGRADE_TIME
        = HttpHeaderName.fromString("x-ms-share-next-allowed-provisioned-iops-downgrade-time");

    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_BANDWIDTH_MIBPS
        = HttpHeaderName.fromString("x-ms-share-provisioned-bandwidth-mibps");

    private static final HttpHeaderName X_MS_SHARE_QUOTA = HttpHeaderName.fromString("x-ms-share-quota");

    private static final HttpHeaderName X_MS_SHARE_NEXT_ALLOWED_QUOTA_DOWNGRADE_TIME
        = HttpHeaderName.fromString("x-ms-share-next-allowed-quota-downgrade-time");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of SharesSetPropertiesHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public SharesSetPropertiesHeaders(HttpHeaders rawHeaders) {
        String xMsShareProvisionedIops = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_IOPS);
        if (xMsShareProvisionedIops != null) {
            this.xMsShareProvisionedIops = Long.parseLong(xMsShareProvisionedIops);
        } else {
            this.xMsShareProvisionedIops = null;
        }
        String xMsShareIncludedBurstIops = rawHeaders.getValue(X_MS_SHARE_INCLUDED_BURST_IOPS);
        if (xMsShareIncludedBurstIops != null) {
            this.xMsShareIncludedBurstIops = Long.parseLong(xMsShareIncludedBurstIops);
        } else {
            this.xMsShareIncludedBurstIops = null;
        }
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsShareNextAllowedProvisionedBandwidthDowngradeTime
            = rawHeaders.getValue(X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_BANDWIDTH_DOWNGRADE_TIME);
        if (xMsShareNextAllowedProvisionedBandwidthDowngradeTime != null) {
            this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime
                = new DateTimeRfc1123(xMsShareNextAllowedProvisionedBandwidthDowngradeTime);
        } else {
            this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime = null;
        }
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        if (lastModified != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        } else {
            this.lastModified = null;
        }
        String xMsShareMaxBurstCreditsForIops = rawHeaders.getValue(X_MS_SHARE_MAX_BURST_CREDITS_FOR_IOPS);
        if (xMsShareMaxBurstCreditsForIops != null) {
            this.xMsShareMaxBurstCreditsForIops = Long.parseLong(xMsShareMaxBurstCreditsForIops);
        } else {
            this.xMsShareMaxBurstCreditsForIops = null;
        }
        String xMsShareNextAllowedProvisionedIopsDowngradeTime
            = rawHeaders.getValue(X_MS_SHARE_NEXT_ALLOWED_PROVISIONED_IOPS_DOWNGRADE_TIME);
        if (xMsShareNextAllowedProvisionedIopsDowngradeTime != null) {
            this.xMsShareNextAllowedProvisionedIopsDowngradeTime
                = new DateTimeRfc1123(xMsShareNextAllowedProvisionedIopsDowngradeTime);
        } else {
            this.xMsShareNextAllowedProvisionedIopsDowngradeTime = null;
        }
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        } else {
            this.date = null;
        }
        String xMsShareProvisionedBandwidthMibps = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_BANDWIDTH_MIBPS);
        if (xMsShareProvisionedBandwidthMibps != null) {
            this.xMsShareProvisionedBandwidthMibps = Long.parseLong(xMsShareProvisionedBandwidthMibps);
        } else {
            this.xMsShareProvisionedBandwidthMibps = null;
        }
        String xMsShareQuota = rawHeaders.getValue(X_MS_SHARE_QUOTA);
        if (xMsShareQuota != null) {
            this.xMsShareQuota = Long.parseLong(xMsShareQuota);
        } else {
            this.xMsShareQuota = null;
        }
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String xMsShareNextAllowedQuotaDowngradeTime
            = rawHeaders.getValue(X_MS_SHARE_NEXT_ALLOWED_QUOTA_DOWNGRADE_TIME);
        if (xMsShareNextAllowedQuotaDowngradeTime != null) {
            this.xMsShareNextAllowedQuotaDowngradeTime = new DateTimeRfc1123(xMsShareNextAllowedQuotaDowngradeTime);
        } else {
            this.xMsShareNextAllowedQuotaDowngradeTime = null;
        }
    }

    /**
     * Get the xMsShareProvisionedIops property: The x-ms-share-provisioned-iops property.
     * 
     * @return the xMsShareProvisionedIops value.
     */
    @Generated
    public Long getXMsShareProvisionedIops() {
        return this.xMsShareProvisionedIops;
    }

    /**
     * Set the xMsShareProvisionedIops property: The x-ms-share-provisioned-iops property.
     * 
     * @param xMsShareProvisionedIops the xMsShareProvisionedIops value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setXMsShareProvisionedIops(Long xMsShareProvisionedIops) {
        this.xMsShareProvisionedIops = xMsShareProvisionedIops;
        return this;
    }

    /**
     * Get the xMsShareIncludedBurstIops property: The x-ms-share-included-burst-iops property.
     * 
     * @return the xMsShareIncludedBurstIops value.
     */
    @Generated
    public Long getXMsShareIncludedBurstIops() {
        return this.xMsShareIncludedBurstIops;
    }

    /**
     * Set the xMsShareIncludedBurstIops property: The x-ms-share-included-burst-iops property.
     * 
     * @param xMsShareIncludedBurstIops the xMsShareIncludedBurstIops value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setXMsShareIncludedBurstIops(Long xMsShareIncludedBurstIops) {
        this.xMsShareIncludedBurstIops = xMsShareIncludedBurstIops;
        return this;
    }

    /**
     * Get the xMsVersion property: The x-ms-version property.
     * 
     * @return the xMsVersion value.
     */
    @Generated
    public String getXMsVersion() {
        return this.xMsVersion;
    }

    /**
     * Set the xMsVersion property: The x-ms-version property.
     * 
     * @param xMsVersion the xMsVersion value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    /**
     * Get the xMsShareNextAllowedProvisionedBandwidthDowngradeTime property: The
     * x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time property.
     * 
     * @return the xMsShareNextAllowedProvisionedBandwidthDowngradeTime value.
     */
    @Generated
    public OffsetDateTime getXMsShareNextAllowedProvisionedBandwidthDowngradeTime() {
        if (this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime.getDateTime();
    }

    /**
     * Set the xMsShareNextAllowedProvisionedBandwidthDowngradeTime property: The
     * x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time property.
     * 
     * @param xMsShareNextAllowedProvisionedBandwidthDowngradeTime the
     * xMsShareNextAllowedProvisionedBandwidthDowngradeTime value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setXMsShareNextAllowedProvisionedBandwidthDowngradeTime(
        OffsetDateTime xMsShareNextAllowedProvisionedBandwidthDowngradeTime) {
        if (xMsShareNextAllowedProvisionedBandwidthDowngradeTime == null) {
            this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime = null;
        } else {
            this.xMsShareNextAllowedProvisionedBandwidthDowngradeTime
                = new DateTimeRfc1123(xMsShareNextAllowedProvisionedBandwidthDowngradeTime);
        }
        return this;
    }

    /**
     * Get the lastModified property: The Last-Modified property.
     * 
     * @return the lastModified value.
     */
    @Generated
    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    /**
     * Set the lastModified property: The Last-Modified property.
     * 
     * @param lastModified the lastModified value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        if (lastModified == null) {
            this.lastModified = null;
        } else {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        return this;
    }

    /**
     * Get the xMsShareMaxBurstCreditsForIops property: The x-ms-share-max-burst-credits-for-iops property.
     * 
     * @return the xMsShareMaxBurstCreditsForIops value.
     */
    @Generated
    public Long getXMsShareMaxBurstCreditsForIops() {
        return this.xMsShareMaxBurstCreditsForIops;
    }

    /**
     * Set the xMsShareMaxBurstCreditsForIops property: The x-ms-share-max-burst-credits-for-iops property.
     * 
     * @param xMsShareMaxBurstCreditsForIops the xMsShareMaxBurstCreditsForIops value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setXMsShareMaxBurstCreditsForIops(Long xMsShareMaxBurstCreditsForIops) {
        this.xMsShareMaxBurstCreditsForIops = xMsShareMaxBurstCreditsForIops;
        return this;
    }

    /**
     * Get the xMsShareNextAllowedProvisionedIopsDowngradeTime property: The
     * x-ms-share-next-allowed-provisioned-iops-downgrade-time property.
     * 
     * @return the xMsShareNextAllowedProvisionedIopsDowngradeTime value.
     */
    @Generated
    public OffsetDateTime getXMsShareNextAllowedProvisionedIopsDowngradeTime() {
        if (this.xMsShareNextAllowedProvisionedIopsDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedProvisionedIopsDowngradeTime.getDateTime();
    }

    /**
     * Set the xMsShareNextAllowedProvisionedIopsDowngradeTime property: The
     * x-ms-share-next-allowed-provisioned-iops-downgrade-time property.
     * 
     * @param xMsShareNextAllowedProvisionedIopsDowngradeTime the xMsShareNextAllowedProvisionedIopsDowngradeTime value
     * to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setXMsShareNextAllowedProvisionedIopsDowngradeTime(
        OffsetDateTime xMsShareNextAllowedProvisionedIopsDowngradeTime) {
        if (xMsShareNextAllowedProvisionedIopsDowngradeTime == null) {
            this.xMsShareNextAllowedProvisionedIopsDowngradeTime = null;
        } else {
            this.xMsShareNextAllowedProvisionedIopsDowngradeTime
                = new DateTimeRfc1123(xMsShareNextAllowedProvisionedIopsDowngradeTime);
        }
        return this;
    }

    /**
     * Get the date property: The Date property.
     * 
     * @return the date value.
     */
    @Generated
    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    /**
     * Set the date property: The Date property.
     * 
     * @param date the date value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setDate(OffsetDateTime date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = new DateTimeRfc1123(date);
        }
        return this;
    }

    /**
     * Get the xMsShareProvisionedBandwidthMibps property: The x-ms-share-provisioned-bandwidth-mibps property.
     * 
     * @return the xMsShareProvisionedBandwidthMibps value.
     */
    @Generated
    public Long getXMsShareProvisionedBandwidthMibps() {
        return this.xMsShareProvisionedBandwidthMibps;
    }

    /**
     * Set the xMsShareProvisionedBandwidthMibps property: The x-ms-share-provisioned-bandwidth-mibps property.
     * 
     * @param xMsShareProvisionedBandwidthMibps the xMsShareProvisionedBandwidthMibps value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setXMsShareProvisionedBandwidthMibps(Long xMsShareProvisionedBandwidthMibps) {
        this.xMsShareProvisionedBandwidthMibps = xMsShareProvisionedBandwidthMibps;
        return this;
    }

    /**
     * Get the xMsShareQuota property: The x-ms-share-quota property.
     * 
     * @return the xMsShareQuota value.
     */
    @Generated
    public Long getXMsShareQuota() {
        return this.xMsShareQuota;
    }

    /**
     * Set the xMsShareQuota property: The x-ms-share-quota property.
     * 
     * @param xMsShareQuota the xMsShareQuota value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setXMsShareQuota(Long xMsShareQuota) {
        this.xMsShareQuota = xMsShareQuota;
        return this;
    }

    /**
     * Get the eTag property: The ETag property.
     * 
     * @return the eTag value.
     */
    @Generated
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The ETag property.
     * 
     * @param eTag the eTag value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the xMsRequestId property: The x-ms-request-id property.
     * 
     * @return the xMsRequestId value.
     */
    @Generated
    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    /**
     * Set the xMsRequestId property: The x-ms-request-id property.
     * 
     * @param xMsRequestId the xMsRequestId value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    /**
     * Get the xMsShareNextAllowedQuotaDowngradeTime property: The x-ms-share-next-allowed-quota-downgrade-time
     * property.
     * 
     * @return the xMsShareNextAllowedQuotaDowngradeTime value.
     */
    @Generated
    public OffsetDateTime getXMsShareNextAllowedQuotaDowngradeTime() {
        if (this.xMsShareNextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.xMsShareNextAllowedQuotaDowngradeTime.getDateTime();
    }

    /**
     * Set the xMsShareNextAllowedQuotaDowngradeTime property: The x-ms-share-next-allowed-quota-downgrade-time
     * property.
     * 
     * @param xMsShareNextAllowedQuotaDowngradeTime the xMsShareNextAllowedQuotaDowngradeTime value to set.
     * @return the SharesSetPropertiesHeaders object itself.
     */
    @Generated
    public SharesSetPropertiesHeaders
        setXMsShareNextAllowedQuotaDowngradeTime(OffsetDateTime xMsShareNextAllowedQuotaDowngradeTime) {
        if (xMsShareNextAllowedQuotaDowngradeTime == null) {
            this.xMsShareNextAllowedQuotaDowngradeTime = null;
        } else {
            this.xMsShareNextAllowedQuotaDowngradeTime = new DateTimeRfc1123(xMsShareNextAllowedQuotaDowngradeTime);
        }
        return this;
    }
}
