// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

/**
 * The FilesForceCloseHandlesHeaders model.
 */
@Fluent
public final class FilesForceCloseHandlesHeaders {
    /*
     * The x-ms-marker property.
     */
    @Generated
    private String xMsMarker;

    /*
     * The x-ms-version property.
     */
    @Generated
    private String xMsVersion;

    /*
     * The x-ms-number-of-handles-closed property.
     */
    @Generated
    private Integer xMsNumberOfHandlesClosed;

    /*
     * The x-ms-number-of-handles-failed property.
     */
    @Generated
    private Integer xMsNumberOfHandlesFailed;

    /*
     * The x-ms-request-id property.
     */
    @Generated
    private String xMsRequestId;

    /*
     * The Date property.
     */
    @Generated
    private DateTimeRfc1123 date;

    private static final HttpHeaderName X_MS_MARKER = HttpHeaderName.fromString("x-ms-marker");

    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");

    private static final HttpHeaderName X_MS_NUMBER_OF_HANDLES_CLOSED
        = HttpHeaderName.fromString("x-ms-number-of-handles-closed");

    private static final HttpHeaderName X_MS_NUMBER_OF_HANDLES_FAILED
        = HttpHeaderName.fromString("x-ms-number-of-handles-failed");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of FilesForceCloseHandlesHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public FilesForceCloseHandlesHeaders(HttpHeaders rawHeaders) {
        this.xMsMarker = rawHeaders.getValue(X_MS_MARKER);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsNumberOfHandlesClosed = rawHeaders.getValue(X_MS_NUMBER_OF_HANDLES_CLOSED);
        if (xMsNumberOfHandlesClosed != null) {
            this.xMsNumberOfHandlesClosed = Integer.parseInt(xMsNumberOfHandlesClosed);
        } else {
            this.xMsNumberOfHandlesClosed = null;
        }
        String xMsNumberOfHandlesFailed = rawHeaders.getValue(X_MS_NUMBER_OF_HANDLES_FAILED);
        if (xMsNumberOfHandlesFailed != null) {
            this.xMsNumberOfHandlesFailed = Integer.parseInt(xMsNumberOfHandlesFailed);
        } else {
            this.xMsNumberOfHandlesFailed = null;
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        } else {
            this.date = null;
        }
    }

    /**
     * Get the xMsMarker property: The x-ms-marker property.
     * 
     * @return the xMsMarker value.
     */
    @Generated
    public String getXMsMarker() {
        return this.xMsMarker;
    }

    /**
     * Set the xMsMarker property: The x-ms-marker property.
     * 
     * @param xMsMarker the xMsMarker value to set.
     * @return the FilesForceCloseHandlesHeaders object itself.
     */
    @Generated
    public FilesForceCloseHandlesHeaders setXMsMarker(String xMsMarker) {
        this.xMsMarker = xMsMarker;
        return this;
    }

    /**
     * Get the xMsVersion property: The x-ms-version property.
     * 
     * @return the xMsVersion value.
     */
    @Generated
    public String getXMsVersion() {
        return this.xMsVersion;
    }

    /**
     * Set the xMsVersion property: The x-ms-version property.
     * 
     * @param xMsVersion the xMsVersion value to set.
     * @return the FilesForceCloseHandlesHeaders object itself.
     */
    @Generated
    public FilesForceCloseHandlesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    /**
     * Get the xMsNumberOfHandlesClosed property: The x-ms-number-of-handles-closed property.
     * 
     * @return the xMsNumberOfHandlesClosed value.
     */
    @Generated
    public Integer getXMsNumberOfHandlesClosed() {
        return this.xMsNumberOfHandlesClosed;
    }

    /**
     * Set the xMsNumberOfHandlesClosed property: The x-ms-number-of-handles-closed property.
     * 
     * @param xMsNumberOfHandlesClosed the xMsNumberOfHandlesClosed value to set.
     * @return the FilesForceCloseHandlesHeaders object itself.
     */
    @Generated
    public FilesForceCloseHandlesHeaders setXMsNumberOfHandlesClosed(Integer xMsNumberOfHandlesClosed) {
        this.xMsNumberOfHandlesClosed = xMsNumberOfHandlesClosed;
        return this;
    }

    /**
     * Get the xMsNumberOfHandlesFailed property: The x-ms-number-of-handles-failed property.
     * 
     * @return the xMsNumberOfHandlesFailed value.
     */
    @Generated
    public Integer getXMsNumberOfHandlesFailed() {
        return this.xMsNumberOfHandlesFailed;
    }

    /**
     * Set the xMsNumberOfHandlesFailed property: The x-ms-number-of-handles-failed property.
     * 
     * @param xMsNumberOfHandlesFailed the xMsNumberOfHandlesFailed value to set.
     * @return the FilesForceCloseHandlesHeaders object itself.
     */
    @Generated
    public FilesForceCloseHandlesHeaders setXMsNumberOfHandlesFailed(Integer xMsNumberOfHandlesFailed) {
        this.xMsNumberOfHandlesFailed = xMsNumberOfHandlesFailed;
        return this;
    }

    /**
     * Get the xMsRequestId property: The x-ms-request-id property.
     * 
     * @return the xMsRequestId value.
     */
    @Generated
    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    /**
     * Set the xMsRequestId property: The x-ms-request-id property.
     * 
     * @param xMsRequestId the xMsRequestId value to set.
     * @return the FilesForceCloseHandlesHeaders object itself.
     */
    @Generated
    public FilesForceCloseHandlesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    /**
     * Get the date property: The Date property.
     * 
     * @return the date value.
     */
    @Generated
    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    /**
     * Set the date property: The Date property.
     * 
     * @param date the date value to set.
     * @return the FilesForceCloseHandlesHeaders object itself.
     */
    @Generated
    public FilesForceCloseHandlesHeaders setDate(OffsetDateTime date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = new DateTimeRfc1123(date);
        }
        return this;
    }
}
