// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.file.share.implementation.models.ListSharesIncludeType;
import com.azure.storage.file.share.implementation.models.ListSharesResponse;
import com.azure.storage.file.share.implementation.models.ServicesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.ServicesListSharesSegmentHeaders;
import com.azure.storage.file.share.implementation.models.ServicesListSharesSegmentNextHeaders;
import com.azure.storage.file.share.implementation.models.ServicesSetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.ShareItemInternal;
import com.azure.storage.file.share.implementation.models.ShareStorageExceptionInternal;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.models.ShareServiceProperties;
import com.azure.storage.file.share.models.ShareTokenIntent;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in Services.
 */
public final class ServicesImpl {

    /**
     * The proxy service used to perform REST calls.
     */
    private final ServicesService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureFileStorageImpl client;

    /**
     * Initializes an instance of ServicesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ServicesImpl(AzureFileStorageImpl client) {
        this.service = RestProxy.create(ServicesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureFileStorageServices to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureFileStorageServices")
    public interface ServicesService {

        @Put("/")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setProperties(@HostParam("url") String url,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/xml") ShareServiceProperties shareServiceProperties,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam("url") String url,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/xml") ShareServiceProperties shareServiceProperties,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<ServicesSetPropertiesHeaders, Void> setPropertiesSync(@HostParam("url") String url,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/xml") ShareServiceProperties shareServiceProperties,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<Void> setPropertiesNoCustomHeadersSync(@HostParam("url") String url,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @BodyParam("application/xml") ShareServiceProperties shareServiceProperties,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties>> getProperties(
            @HostParam("url") String url, @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<ShareServiceProperties>> getPropertiesNoCustomHeaders(@HostParam("url") String url,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties> getPropertiesSync(
            @HostParam("url") String url, @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<ShareServiceProperties> getPropertiesNoCustomHeadersSync(@HostParam("url") String url,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<ServicesListSharesSegmentHeaders, ListSharesResponse>> listSharesSegment(
            @HostParam("url") String url, @QueryParam("comp") String comp, @QueryParam("prefix") String prefix,
            @QueryParam("marker") String marker, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("include") String include, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<ListSharesResponse>> listSharesSegmentNoCustomHeaders(@HostParam("url") String url,
            @QueryParam("comp") String comp, @QueryParam("prefix") String prefix, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<ServicesListSharesSegmentHeaders, ListSharesResponse> listSharesSegmentSync(
            @HostParam("url") String url, @QueryParam("comp") String comp, @QueryParam("prefix") String prefix,
            @QueryParam("marker") String marker, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("include") String include, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<ListSharesResponse> listSharesSegmentNoCustomHeadersSync(@HostParam("url") String url,
            @QueryParam("comp") String comp, @QueryParam("prefix") String prefix, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<ResponseBase<ServicesListSharesSegmentNextHeaders, ListSharesResponse>> listSharesSegmentNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("url") String url,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Mono<Response<ListSharesResponse>> listSharesSegmentNextNoCustomHeaders(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("url") String url,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        ResponseBase<ServicesListSharesSegmentNextHeaders, ListSharesResponse> listSharesSegmentNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("url") String url,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ShareStorageExceptionInternal.class)
        Response<ListSharesResponse> listSharesSegmentNextNoCustomHeadersSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("url") String url,
            @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-file-request-intent") ShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param shareServiceProperties The StorageService properties.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>>
        setPropertiesWithResponseAsync(ShareServiceProperties shareServiceProperties, Integer timeout) {
        return FluxUtil.withContext(context -> setPropertiesWithResponseAsync(shareServiceProperties, timeout, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param shareServiceProperties The StorageService properties.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(
        ShareServiceProperties shareServiceProperties, Integer timeout, Context context) {
        final String restype = "service";
        final String comp = "properties";
        final String accept = "application/xml";
        return service
            .setProperties(this.client.getUrl(), restype, comp, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), shareServiceProperties, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param shareServiceProperties The StorageService properties.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(ShareServiceProperties shareServiceProperties, Integer timeout) {
        return setPropertiesWithResponseAsync(shareServiceProperties, timeout)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param shareServiceProperties The StorageService properties.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(ShareServiceProperties shareServiceProperties, Integer timeout,
        Context context) {
        return setPropertiesWithResponseAsync(shareServiceProperties, timeout, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param shareServiceProperties The StorageService properties.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>>
        setPropertiesNoCustomHeadersWithResponseAsync(ShareServiceProperties shareServiceProperties, Integer timeout) {
        return FluxUtil
            .withContext(
                context -> setPropertiesNoCustomHeadersWithResponseAsync(shareServiceProperties, timeout, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param shareServiceProperties The StorageService properties.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(
        ShareServiceProperties shareServiceProperties, Integer timeout, Context context) {
        final String restype = "service";
        final String comp = "properties";
        final String accept = "application/xml";
        return service
            .setPropertiesNoCustomHeaders(this.client.getUrl(), restype, comp, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), shareServiceProperties, accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param shareServiceProperties The StorageService properties.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ServicesSetPropertiesHeaders, Void>
        setPropertiesWithResponse(ShareServiceProperties shareServiceProperties, Integer timeout, Context context) {
        try {
            final String restype = "service";
            final String comp = "properties";
            final String accept = "application/xml";
            return service.setPropertiesSync(this.client.getUrl(), restype, comp, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), shareServiceProperties, accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param shareServiceProperties The StorageService properties.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setProperties(ShareServiceProperties shareServiceProperties, Integer timeout) {
        setPropertiesWithResponse(shareServiceProperties, timeout, Context.NONE);
    }

    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param shareServiceProperties The StorageService properties.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setPropertiesNoCustomHeadersWithResponse(ShareServiceProperties shareServiceProperties,
        Integer timeout, Context context) {
        try {
            final String restype = "service";
            final String comp = "properties";
            final String accept = "application/xml";
            return service.setPropertiesNoCustomHeadersSync(this.client.getUrl(), restype, comp, timeout,
                this.client.getVersion(), this.client.getFileRequestIntent(), shareServiceProperties, accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics metrics and
     * CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account's File service, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties>>
        getPropertiesWithResponseAsync(Integer timeout) {
        return FluxUtil.withContext(context -> getPropertiesWithResponseAsync(timeout, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics metrics and
     * CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account's File service, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties>>
        getPropertiesWithResponseAsync(Integer timeout, Context context) {
        final String restype = "service";
        final String comp = "properties";
        final String accept = "application/xml";
        return service
            .getProperties(this.client.getUrl(), restype, comp, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics metrics and
     * CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account's File service, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ShareServiceProperties> getPropertiesAsync(Integer timeout) {
        return getPropertiesWithResponseAsync(timeout)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics metrics and
     * CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account's File service, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ShareServiceProperties> getPropertiesAsync(Integer timeout, Context context) {
        return getPropertiesWithResponseAsync(timeout, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics metrics and
     * CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account's File service, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ShareServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout) {
        return FluxUtil.withContext(context -> getPropertiesNoCustomHeadersWithResponseAsync(timeout, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics metrics and
     * CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account's File service, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ShareServiceProperties>> getPropertiesNoCustomHeadersWithResponseAsync(Integer timeout,
        Context context) {
        final String restype = "service";
        final String comp = "properties";
        final String accept = "application/xml";
        return service
            .getPropertiesNoCustomHeaders(this.client.getUrl(), restype, comp, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException);
    }

    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics metrics and
     * CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account's File service, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ServicesGetPropertiesHeaders, ShareServiceProperties> getPropertiesWithResponse(Integer timeout,
        Context context) {
        try {
            final String restype = "service";
            final String comp = "properties";
            final String accept = "application/xml";
            return service.getPropertiesSync(this.client.getUrl(), restype, comp, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics metrics and
     * CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account's File service, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ShareServiceProperties getProperties(Integer timeout) {
        try {
            return getPropertiesWithResponse(timeout, Context.NONE).getValue();
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics metrics and
     * CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a storage account's File service, including properties for Storage Analytics metrics
     * and CORS (Cross-Origin Resource Sharing) rules along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ShareServiceProperties> getPropertiesNoCustomHeadersWithResponse(Integer timeout, Context context) {
        try {
            final String restype = "service";
            final String comp = "properties";
            final String accept = "application/xml";
            return service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), restype, comp, timeout,
                this.client.getVersion(), this.client.getFileRequestIntent(), accept, context);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentSinglePageAsync(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout) {
        final String comp = "list";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.listSharesSegment(this.client.getUrl(), comp, prefix, marker, maxresults,
                includeConverted, timeout, this.client.getVersion(), this.client.getFileRequestIntent(), accept,
                context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders()));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentSinglePageAsync(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout, Context context) {
        final String comp = "list";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .listSharesSegment(this.client.getUrl(), comp, prefix, marker, maxresults, includeConverted, timeout,
                this.client.getVersion(), this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders()));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ShareItemInternal> listSharesSegmentAsync(String prefix, String marker, Integer maxresults,
        List<ListSharesIncludeType> include, Integer timeout) {
        return new PagedFlux<>(() -> listSharesSegmentSinglePageAsync(prefix, marker, maxresults, include, timeout),
            nextLink -> listSharesSegmentNextSinglePageAsync(nextLink));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ShareItemInternal> listSharesSegmentAsync(String prefix, String marker, Integer maxresults,
        List<ListSharesIncludeType> include, Integer timeout, Context context) {
        return new PagedFlux<>(
            () -> listSharesSegmentSinglePageAsync(prefix, marker, maxresults, include, timeout, context),
            nextLink -> listSharesSegmentNextSinglePageAsync(nextLink, context));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNoCustomHeadersSinglePageAsync(String prefix,
        String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout) {
        final String comp = "list";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(context -> service.listSharesSegmentNoCustomHeaders(this.client.getUrl(), comp, prefix, marker,
                maxresults, includeConverted, timeout, this.client.getVersion(), this.client.getFileRequestIntent(),
                accept, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), null));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNoCustomHeadersSinglePageAsync(String prefix,
        String marker, Integer maxresults, List<ListSharesIncludeType> include, Integer timeout, Context context) {
        final String comp = "list";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .listSharesSegmentNoCustomHeaders(this.client.getUrl(), comp, prefix, marker, maxresults, includeConverted,
                timeout, this.client.getVersion(), this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), null));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ShareItemInternal> listSharesSegmentNoCustomHeadersAsync(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout) {
        return new PagedFlux<>(
            () -> listSharesSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults, include, timeout),
            nextLink -> listSharesSegmentNextSinglePageAsync(nextLink));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ShareItemInternal> listSharesSegmentNoCustomHeadersAsync(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout, Context context) {
        return new PagedFlux<>(() -> listSharesSegmentNoCustomHeadersSinglePageAsync(prefix, marker, maxresults,
            include, timeout, context), nextLink -> listSharesSegmentNextSinglePageAsync(nextLink, context));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentSinglePage(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout) {
        try {
            final String comp = "list";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            ResponseBase<ServicesListSharesSegmentHeaders, ListSharesResponse> res = service.listSharesSegmentSync(
                this.client.getUrl(), comp, prefix, marker, maxresults, includeConverted, timeout,
                this.client.getVersion(), this.client.getFileRequestIntent(), accept, Context.NONE);
            return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentSinglePage(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout, Context context) {
        try {
            final String comp = "list";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            ResponseBase<ServicesListSharesSegmentHeaders, ListSharesResponse> res = service.listSharesSegmentSync(
                this.client.getUrl(), comp, prefix, marker, maxresults, includeConverted, timeout,
                this.client.getVersion(), this.client.getFileRequestIntent(), accept, context);
            return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ShareItemInternal> listSharesSegment(String prefix, String marker, Integer maxresults,
        List<ListSharesIncludeType> include, Integer timeout) {
        return new PagedIterable<>(() -> listSharesSegmentSinglePage(prefix, marker, maxresults, include, timeout),
            nextLink -> listSharesSegmentNextSinglePage(nextLink));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ShareItemInternal> listSharesSegment(String prefix, String marker, Integer maxresults,
        List<ListSharesIncludeType> include, Integer timeout, Context context) {
        return new PagedIterable<>(
            () -> listSharesSegmentSinglePage(prefix, marker, maxresults, include, timeout, context),
            nextLink -> listSharesSegmentNextSinglePage(nextLink, context));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNoCustomHeadersSinglePage(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout) {
        try {
            final String comp = "list";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            Response<ListSharesResponse> res = service.listSharesSegmentNoCustomHeadersSync(this.client.getUrl(), comp,
                prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), accept, Context.NONE);
            return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), null);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNoCustomHeadersSinglePage(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout, Context context) {
        try {
            final String comp = "list";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            Response<ListSharesResponse> res = service.listSharesSegmentNoCustomHeadersSync(this.client.getUrl(), comp,
                prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(),
                this.client.getFileRequestIntent(), accept, context);
            return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), null);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ShareItemInternal> listSharesSegmentNoCustomHeaders(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout) {
        return new PagedIterable<>(
            () -> listSharesSegmentNoCustomHeadersSinglePage(prefix, marker, maxresults, include, timeout),
            nextLink -> listSharesSegmentNextSinglePage(nextLink));
    }

    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the specified account.
     *
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     * The operation returns a marker value within the response body if the list returned was not complete. The marker
     * value may then be used in a subsequent call to request the next set of list items. The marker value is opaque to
     * the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     * or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations"&gt;Setting
     * Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ShareItemInternal> listSharesSegmentNoCustomHeaders(String prefix, String marker,
        Integer maxresults, List<ListSharesIncludeType> include, Integer timeout, Context context) {
        return new PagedIterable<>(
            () -> listSharesSegmentNoCustomHeadersSinglePage(prefix, marker, maxresults, include, timeout, context),
            nextLink -> listSharesSegmentNextSinglePage(nextLink, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNextSinglePageAsync(String nextLink) {
        final String accept = "application/xml";
        return FluxUtil
            .withContext(context -> service.listSharesSegmentNext(nextLink, this.client.getUrl(),
                this.client.getVersion(), this.client.getFileRequestIntent(), accept, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNextSinglePageAsync(String nextLink,
        Context context) {
        final String accept = "application/xml";
        return service
            .listSharesSegmentNext(nextLink, this.client.getUrl(), this.client.getVersion(),
                this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNextNoCustomHeadersSinglePageAsync(String nextLink) {
        final String accept = "application/xml";
        return FluxUtil
            .withContext(context -> service.listSharesSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(),
                this.client.getVersion(), this.client.getFileRequestIntent(), accept, context))
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ShareItemInternal>> listSharesSegmentNextNoCustomHeadersSinglePageAsync(String nextLink,
        Context context) {
        final String accept = "application/xml";
        return service
            .listSharesSegmentNextNoCustomHeaders(nextLink, this.client.getUrl(), this.client.getVersion(),
                this.client.getFileRequestIntent(), accept, context)
            .onErrorMap(ShareStorageExceptionInternal.class, ModelHelper::mapToShareStorageException)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNextSinglePage(String nextLink) {
        try {
            final String accept = "application/xml";
            ResponseBase<ServicesListSharesSegmentNextHeaders, ListSharesResponse> res
                = service.listSharesSegmentNextSync(nextLink, this.client.getUrl(), this.client.getVersion(),
                    this.client.getFileRequestIntent(), accept, Context.NONE);
            return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNextSinglePage(String nextLink, Context context) {
        try {
            final String accept = "application/xml";
            ResponseBase<ServicesListSharesSegmentNextHeaders, ListSharesResponse> res
                = service.listSharesSegmentNextSync(nextLink, this.client.getUrl(), this.client.getVersion(),
                    this.client.getFileRequestIntent(), accept, context);
            return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), res.getDeserializedHeaders());
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNextNoCustomHeadersSinglePage(String nextLink) {
        try {
            final String accept = "application/xml";
            Response<ListSharesResponse> res
                = service.listSharesSegmentNextNoCustomHeadersSync(nextLink, this.client.getUrl(),
                    this.client.getVersion(), this.client.getFileRequestIntent(), accept, Context.NONE);
            return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), null);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of shares along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ShareItemInternal> listSharesSegmentNextNoCustomHeadersSinglePage(String nextLink,
        Context context) {
        try {
            final String accept = "application/xml";
            Response<ListSharesResponse> res = service.listSharesSegmentNextNoCustomHeadersSync(nextLink,
                this.client.getUrl(), this.client.getVersion(), this.client.getFileRequestIntent(), accept, context);
            return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getShareItems(), res.getValue().getNextMarker(), null);
        } catch (ShareStorageExceptionInternal internalException) {
            throw ModelHelper.mapToShareStorageException(internalException);
        }
    }
}
