/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.storage.file.share.implementation.models.DirectoryItem;
import com.azure.storage.file.share.implementation.models.FileItem;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class FilesAndDirectoriesListSegment
implements XmlSerializable<FilesAndDirectoriesListSegment> {
    private List<DirectoryItem> directoryItems = new ArrayList<DirectoryItem>();
    private List<FileItem> fileItems = new ArrayList<FileItem>();

    public List<DirectoryItem> getDirectoryItems() {
        return this.directoryItems;
    }

    public FilesAndDirectoriesListSegment setDirectoryItems(List<DirectoryItem> directoryItems) {
        this.directoryItems = directoryItems;
        return this;
    }

    public List<FileItem> getFileItems() {
        return this.fileItems;
    }

    public FilesAndDirectoriesListSegment setFileItems(List<FileItem> fileItems) {
        this.fileItems = fileItems;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "Entries" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.directoryItems != null) {
            for (DirectoryItem directoryItem : this.directoryItems) {
                xmlWriter.writeXml((XmlSerializable)directoryItem, "Directory");
            }
        }
        if (this.fileItems != null) {
            for (FileItem fileItem : this.fileItems) {
                xmlWriter.writeXml((XmlSerializable)fileItem, "File");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static FilesAndDirectoriesListSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return FilesAndDirectoriesListSegment.fromXml(xmlReader, null);
    }

    public static FilesAndDirectoriesListSegment fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "Entries" : rootElementName;
        return (FilesAndDirectoriesListSegment)xmlReader.readObject(finalRootElementName, reader -> {
            FilesAndDirectoriesListSegment deserializedFilesAndDirectoriesListSegment = new FilesAndDirectoriesListSegment();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Directory".equals(elementName.getLocalPart())) {
                    deserializedFilesAndDirectoriesListSegment.directoryItems.add(DirectoryItem.fromXml(reader, "Directory"));
                    continue;
                }
                if ("File".equals(elementName.getLocalPart())) {
                    deserializedFilesAndDirectoriesListSegment.fileItems.add(FileItem.fromXml(reader, "File"));
                    continue;
                }
                reader.skipElement();
            }
            return deserializedFilesAndDirectoriesListSegment;
        });
    }
}

