// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

/**
 * Defines values for FilePermissionFormat.
 */
public enum FilePermissionFormat {
    /**
     * Enum value Sddl.
     */
    SDDL("Sddl"),

    /**
     * Enum value Binary.
     */
    BINARY("Binary");

    /**
     * The actual serialized value for a FilePermissionFormat instance.
     */
    private final String value;

    FilePermissionFormat(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a FilePermissionFormat instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed FilePermissionFormat object, or null if unable to parse.
     */
    public static FilePermissionFormat fromString(String value) {
        if (value == null) {
            return null;
        }
        FilePermissionFormat[] items = FilePermissionFormat.values();
        for (FilePermissionFormat item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
