// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.NfsFileType;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * The DirectoriesGetPropertiesHeaders model.
 */
@Fluent
public final class DirectoriesGetPropertiesHeaders {
    /*
     * The x-ms-group property.
     */
    private String xMsGroup;

    /*
     * The x-ms-version property.
     */
    private String xMsVersion;

    /*
     * The x-ms-file-permission-key property.
     */
    private String xMsFilePermissionKey;

    /*
     * The x-ms-file-id property.
     */
    private String xMsFileId;

    /*
     * The x-ms-file-creation-time property.
     */
    private OffsetDateTime xMsFileCreationTime;

    /*
     * The x-ms-file-file-type property.
     */
    private NfsFileType xMsFileFileType;

    /*
     * The Last-Modified property.
     */
    private DateTimeRfc1123 lastModified;

    /*
     * The x-ms-meta- property.
     */
    private Map<String, String> xMsMeta;

    /*
     * The Date property.
     */
    private DateTimeRfc1123 date;

    /*
     * The x-ms-mode property.
     */
    private String xMsMode;

    /*
     * The x-ms-server-encrypted property.
     */
    private Boolean xMsServerEncrypted;

    /*
     * The ETag property.
     */
    private String eTag;

    /*
     * The x-ms-file-attributes property.
     */
    private String xMsFileAttributes;

    /*
     * The x-ms-file-change-time property.
     */
    private OffsetDateTime xMsFileChangeTime;

    /*
     * The x-ms-file-parent-id property.
     */
    private String xMsFileParentId;

    /*
     * The x-ms-request-id property.
     */
    private String xMsRequestId;

    /*
     * The x-ms-file-last-write-time property.
     */
    private OffsetDateTime xMsFileLastWriteTime;

    /*
     * The x-ms-owner property.
     */
    private String xMsOwner;

    private static final HttpHeaderName X_MS_GROUP = HttpHeaderName.fromString("x-ms-group");

    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");

    private static final HttpHeaderName X_MS_FILE_PERMISSION_KEY
        = HttpHeaderName.fromString("x-ms-file-permission-key");

    private static final HttpHeaderName X_MS_FILE_ID = HttpHeaderName.fromString("x-ms-file-id");

    private static final HttpHeaderName X_MS_FILE_CREATION_TIME = HttpHeaderName.fromString("x-ms-file-creation-time");

    private static final HttpHeaderName X_MS_FILE_FILE_TYPE = HttpHeaderName.fromString("x-ms-file-file-type");

    private static final HttpHeaderName X_MS_MODE = HttpHeaderName.fromString("x-ms-mode");

    private static final HttpHeaderName X_MS_SERVER_ENCRYPTED = HttpHeaderName.fromString("x-ms-server-encrypted");

    private static final HttpHeaderName X_MS_FILE_ATTRIBUTES = HttpHeaderName.fromString("x-ms-file-attributes");

    private static final HttpHeaderName X_MS_FILE_CHANGE_TIME = HttpHeaderName.fromString("x-ms-file-change-time");

    private static final HttpHeaderName X_MS_FILE_PARENT_ID = HttpHeaderName.fromString("x-ms-file-parent-id");

    private static final HttpHeaderName X_MS_FILE_LAST_WRITE_TIME
        = HttpHeaderName.fromString("x-ms-file-last-write-time");

    private static final HttpHeaderName X_MS_OWNER = HttpHeaderName.fromString("x-ms-owner");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of DirectoriesGetPropertiesHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public DirectoriesGetPropertiesHeaders(HttpHeaders rawHeaders) {
        this.xMsGroup = rawHeaders.getValue(X_MS_GROUP);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsFilePermissionKey = rawHeaders.getValue(X_MS_FILE_PERMISSION_KEY);
        this.xMsFileId = rawHeaders.getValue(X_MS_FILE_ID);
        String xMsFileCreationTime = rawHeaders.getValue(X_MS_FILE_CREATION_TIME);
        if (xMsFileCreationTime != null) {
            this.xMsFileCreationTime = OffsetDateTime.parse(xMsFileCreationTime);
        }
        String xMsFileFileType = rawHeaders.getValue(X_MS_FILE_FILE_TYPE);
        if (xMsFileFileType != null) {
            this.xMsFileFileType = NfsFileType.fromString(xMsFileFileType);
        }
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        if (lastModified != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        this.xMsMode = rawHeaders.getValue(X_MS_MODE);
        String xMsServerEncrypted = rawHeaders.getValue(X_MS_SERVER_ENCRYPTED);
        if (xMsServerEncrypted != null) {
            this.xMsServerEncrypted = Boolean.parseBoolean(xMsServerEncrypted);
        }
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.xMsFileAttributes = rawHeaders.getValue(X_MS_FILE_ATTRIBUTES);
        String xMsFileChangeTime = rawHeaders.getValue(X_MS_FILE_CHANGE_TIME);
        if (xMsFileChangeTime != null) {
            this.xMsFileChangeTime = OffsetDateTime.parse(xMsFileChangeTime);
        }
        this.xMsFileParentId = rawHeaders.getValue(X_MS_FILE_PARENT_ID);
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String xMsFileLastWriteTime = rawHeaders.getValue(X_MS_FILE_LAST_WRITE_TIME);
        if (xMsFileLastWriteTime != null) {
            this.xMsFileLastWriteTime = OffsetDateTime.parse(xMsFileLastWriteTime);
        }
        this.xMsOwner = rawHeaders.getValue(X_MS_OWNER);
        Map<String, String> xMsMetaHeaderCollection = new LinkedHashMap<>();

        for (HttpHeader header : rawHeaders) {
            String headerName = header.getName();
            if (headerName.startsWith("x-ms-meta-")) {
                xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
            }
        }

        this.xMsMeta = xMsMetaHeaderCollection;
    }

    /**
     * Get the xMsGroup property: The x-ms-group property.
     * 
     * @return the xMsGroup value.
     */
    public String getXMsGroup() {
        return this.xMsGroup;
    }

    /**
     * Set the xMsGroup property: The x-ms-group property.
     * 
     * @param xMsGroup the xMsGroup value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsGroup(String xMsGroup) {
        this.xMsGroup = xMsGroup;
        return this;
    }

    /**
     * Get the xMsVersion property: The x-ms-version property.
     * 
     * @return the xMsVersion value.
     */
    public String getXMsVersion() {
        return this.xMsVersion;
    }

    /**
     * Set the xMsVersion property: The x-ms-version property.
     * 
     * @param xMsVersion the xMsVersion value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    /**
     * Get the xMsFilePermissionKey property: The x-ms-file-permission-key property.
     * 
     * @return the xMsFilePermissionKey value.
     */
    public String getXMsFilePermissionKey() {
        return this.xMsFilePermissionKey;
    }

    /**
     * Set the xMsFilePermissionKey property: The x-ms-file-permission-key property.
     * 
     * @param xMsFilePermissionKey the xMsFilePermissionKey value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsFilePermissionKey(String xMsFilePermissionKey) {
        this.xMsFilePermissionKey = xMsFilePermissionKey;
        return this;
    }

    /**
     * Get the xMsFileId property: The x-ms-file-id property.
     * 
     * @return the xMsFileId value.
     */
    public String getXMsFileId() {
        return this.xMsFileId;
    }

    /**
     * Set the xMsFileId property: The x-ms-file-id property.
     * 
     * @param xMsFileId the xMsFileId value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsFileId(String xMsFileId) {
        this.xMsFileId = xMsFileId;
        return this;
    }

    /**
     * Get the xMsFileCreationTime property: The x-ms-file-creation-time property.
     * 
     * @return the xMsFileCreationTime value.
     */
    public OffsetDateTime getXMsFileCreationTime() {
        return this.xMsFileCreationTime;
    }

    /**
     * Set the xMsFileCreationTime property: The x-ms-file-creation-time property.
     * 
     * @param xMsFileCreationTime the xMsFileCreationTime value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsFileCreationTime(OffsetDateTime xMsFileCreationTime) {
        this.xMsFileCreationTime = xMsFileCreationTime;
        return this;
    }

    /**
     * Get the xMsFileFileType property: The x-ms-file-file-type property.
     * 
     * @return the xMsFileFileType value.
     */
    public NfsFileType getXMsFileFileType() {
        return this.xMsFileFileType;
    }

    /**
     * Set the xMsFileFileType property: The x-ms-file-file-type property.
     * 
     * @param xMsFileFileType the xMsFileFileType value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsFileFileType(NfsFileType xMsFileFileType) {
        this.xMsFileFileType = xMsFileFileType;
        return this;
    }

    /**
     * Get the lastModified property: The Last-Modified property.
     * 
     * @return the lastModified value.
     */
    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    /**
     * Set the lastModified property: The Last-Modified property.
     * 
     * @param lastModified the lastModified value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        if (lastModified == null) {
            this.lastModified = null;
        } else {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        return this;
    }

    /**
     * Get the xMsMeta property: The x-ms-meta- property.
     * 
     * @return the xMsMeta value.
     */
    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    /**
     * Set the xMsMeta property: The x-ms-meta- property.
     * 
     * @param xMsMeta the xMsMeta value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    /**
     * Get the date property: The Date property.
     * 
     * @return the date value.
     */
    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    /**
     * Set the date property: The Date property.
     * 
     * @param date the date value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setDate(OffsetDateTime date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = new DateTimeRfc1123(date);
        }
        return this;
    }

    /**
     * Get the xMsMode property: The x-ms-mode property.
     * 
     * @return the xMsMode value.
     */
    public String getXMsMode() {
        return this.xMsMode;
    }

    /**
     * Set the xMsMode property: The x-ms-mode property.
     * 
     * @param xMsMode the xMsMode value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsMode(String xMsMode) {
        this.xMsMode = xMsMode;
        return this;
    }

    /**
     * Get the xMsServerEncrypted property: The x-ms-server-encrypted property.
     * 
     * @return the xMsServerEncrypted value.
     */
    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    /**
     * Set the xMsServerEncrypted property: The x-ms-server-encrypted property.
     * 
     * @param xMsServerEncrypted the xMsServerEncrypted value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    /**
     * Get the eTag property: The ETag property.
     * 
     * @return the eTag value.
     */
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The ETag property.
     * 
     * @param eTag the eTag value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the xMsFileAttributes property: The x-ms-file-attributes property.
     * 
     * @return the xMsFileAttributes value.
     */
    public String getXMsFileAttributes() {
        return this.xMsFileAttributes;
    }

    /**
     * Set the xMsFileAttributes property: The x-ms-file-attributes property.
     * 
     * @param xMsFileAttributes the xMsFileAttributes value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsFileAttributes(String xMsFileAttributes) {
        this.xMsFileAttributes = xMsFileAttributes;
        return this;
    }

    /**
     * Get the xMsFileChangeTime property: The x-ms-file-change-time property.
     * 
     * @return the xMsFileChangeTime value.
     */
    public OffsetDateTime getXMsFileChangeTime() {
        return this.xMsFileChangeTime;
    }

    /**
     * Set the xMsFileChangeTime property: The x-ms-file-change-time property.
     * 
     * @param xMsFileChangeTime the xMsFileChangeTime value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsFileChangeTime(OffsetDateTime xMsFileChangeTime) {
        this.xMsFileChangeTime = xMsFileChangeTime;
        return this;
    }

    /**
     * Get the xMsFileParentId property: The x-ms-file-parent-id property.
     * 
     * @return the xMsFileParentId value.
     */
    public String getXMsFileParentId() {
        return this.xMsFileParentId;
    }

    /**
     * Set the xMsFileParentId property: The x-ms-file-parent-id property.
     * 
     * @param xMsFileParentId the xMsFileParentId value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsFileParentId(String xMsFileParentId) {
        this.xMsFileParentId = xMsFileParentId;
        return this;
    }

    /**
     * Get the xMsRequestId property: The x-ms-request-id property.
     * 
     * @return the xMsRequestId value.
     */
    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    /**
     * Set the xMsRequestId property: The x-ms-request-id property.
     * 
     * @param xMsRequestId the xMsRequestId value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    /**
     * Get the xMsFileLastWriteTime property: The x-ms-file-last-write-time property.
     * 
     * @return the xMsFileLastWriteTime value.
     */
    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    /**
     * Set the xMsFileLastWriteTime property: The x-ms-file-last-write-time property.
     * 
     * @param xMsFileLastWriteTime the xMsFileLastWriteTime value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }

    /**
     * Get the xMsOwner property: The x-ms-owner property.
     * 
     * @return the xMsOwner value.
     */
    public String getXMsOwner() {
        return this.xMsOwner;
    }

    /**
     * Set the xMsOwner property: The x-ms-owner property.
     * 
     * @param xMsOwner the xMsOwner value to set.
     * @return the DirectoriesGetPropertiesHeaders object itself.
     */
    public DirectoriesGetPropertiesHeaders setXMsOwner(String xMsOwner) {
        this.xMsOwner = xMsOwner;
        return this;
    }
}
