// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * An enumeration of directories and files.
 */
@Fluent
public final class ListFilesAndDirectoriesSegmentResponse
    implements XmlSerializable<ListFilesAndDirectoriesSegmentResponse> {
    /*
     * The ServiceEndpoint property.
     */
    private String serviceEndpoint;

    /*
     * The ShareName property.
     */
    private String shareName;

    /*
     * The ShareSnapshot property.
     */
    private String shareSnapshot;

    /*
     * The Encoded property.
     */
    private Boolean encoded;

    /*
     * The DirectoryPath property.
     */
    private String directoryPath;

    /*
     * The Prefix property.
     */
    private StringEncoded prefix;

    /*
     * The Marker property.
     */
    private String marker;

    /*
     * The MaxResults property.
     */
    private Integer maxResults;

    /*
     * Abstract for entries that can be listed from Directory.
     */
    private FilesAndDirectoriesListSegment segment;

    /*
     * The NextMarker property.
     */
    private String nextMarker;

    /*
     * The DirectoryId property.
     */
    private String directoryId;

    /**
     * Creates an instance of ListFilesAndDirectoriesSegmentResponse class.
     */
    public ListFilesAndDirectoriesSegmentResponse() {
    }

    /**
     * Get the serviceEndpoint property: The ServiceEndpoint property.
     * 
     * @return the serviceEndpoint value.
     */
    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    /**
     * Set the serviceEndpoint property: The ServiceEndpoint property.
     * 
     * @param serviceEndpoint the serviceEndpoint value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    /**
     * Get the shareName property: The ShareName property.
     * 
     * @return the shareName value.
     */
    public String getShareName() {
        return this.shareName;
    }

    /**
     * Set the shareName property: The ShareName property.
     * 
     * @param shareName the shareName value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    /**
     * Get the shareSnapshot property: The ShareSnapshot property.
     * 
     * @return the shareSnapshot value.
     */
    public String getShareSnapshot() {
        return this.shareSnapshot;
    }

    /**
     * Set the shareSnapshot property: The ShareSnapshot property.
     * 
     * @param shareSnapshot the shareSnapshot value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setShareSnapshot(String shareSnapshot) {
        this.shareSnapshot = shareSnapshot;
        return this;
    }

    /**
     * Get the encoded property: The Encoded property.
     * 
     * @return the encoded value.
     */
    public Boolean isEncoded() {
        return this.encoded;
    }

    /**
     * Set the encoded property: The Encoded property.
     * 
     * @param encoded the encoded value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setEncoded(Boolean encoded) {
        this.encoded = encoded;
        return this;
    }

    /**
     * Get the directoryPath property: The DirectoryPath property.
     * 
     * @return the directoryPath value.
     */
    public String getDirectoryPath() {
        return this.directoryPath;
    }

    /**
     * Set the directoryPath property: The DirectoryPath property.
     * 
     * @param directoryPath the directoryPath value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
        return this;
    }

    /**
     * Get the prefix property: The Prefix property.
     * 
     * @return the prefix value.
     */
    public StringEncoded getPrefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: The Prefix property.
     * 
     * @param prefix the prefix value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setPrefix(StringEncoded prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the marker property: The Marker property.
     * 
     * @return the marker value.
     */
    public String getMarker() {
        return this.marker;
    }

    /**
     * Set the marker property: The Marker property.
     * 
     * @param marker the marker value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setMarker(String marker) {
        this.marker = marker;
        return this;
    }

    /**
     * Get the maxResults property: The MaxResults property.
     * 
     * @return the maxResults value.
     */
    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * Set the maxResults property: The MaxResults property.
     * 
     * @param maxResults the maxResults value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    /**
     * Get the segment property: Abstract for entries that can be listed from Directory.
     * 
     * @return the segment value.
     */
    public FilesAndDirectoriesListSegment getSegment() {
        return this.segment;
    }

    /**
     * Set the segment property: Abstract for entries that can be listed from Directory.
     * 
     * @param segment the segment value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setSegment(FilesAndDirectoriesListSegment segment) {
        this.segment = segment;
        return this;
    }

    /**
     * Get the nextMarker property: The NextMarker property.
     * 
     * @return the nextMarker value.
     */
    public String getNextMarker() {
        return this.nextMarker;
    }

    /**
     * Set the nextMarker property: The NextMarker property.
     * 
     * @param nextMarker the nextMarker value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    /**
     * Get the directoryId property: The DirectoryId property.
     * 
     * @return the directoryId value.
     */
    public String getDirectoryId() {
        return this.directoryId;
    }

    /**
     * Set the directoryId property: The DirectoryId property.
     * 
     * @param directoryId the directoryId value to set.
     * @return the ListFilesAndDirectoriesSegmentResponse object itself.
     */
    public ListFilesAndDirectoriesSegmentResponse setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "EnumerationResults" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringAttribute("ServiceEndpoint", this.serviceEndpoint);
        xmlWriter.writeStringAttribute("ShareName", this.shareName);
        xmlWriter.writeStringAttribute("ShareSnapshot", this.shareSnapshot);
        xmlWriter.writeBooleanAttribute("Encoded", this.encoded);
        xmlWriter.writeStringAttribute("DirectoryPath", this.directoryPath);
        xmlWriter.writeXml(this.prefix, "Prefix");
        xmlWriter.writeStringElement("Marker", this.marker);
        xmlWriter.writeNumberElement("MaxResults", this.maxResults);
        xmlWriter.writeXml(this.segment, "Entries");
        xmlWriter.writeStringElement("NextMarker", this.nextMarker);
        xmlWriter.writeStringElement("DirectoryId", this.directoryId);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of ListFilesAndDirectoriesSegmentResponse from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of ListFilesAndDirectoriesSegmentResponse if the XmlReader was pointing to an instance of it,
     * or null if it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ListFilesAndDirectoriesSegmentResponse.
     */
    public static ListFilesAndDirectoriesSegmentResponse fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of ListFilesAndDirectoriesSegmentResponse from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of ListFilesAndDirectoriesSegmentResponse if the XmlReader was pointing to an instance of it,
     * or null if it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ListFilesAndDirectoriesSegmentResponse.
     */
    public static ListFilesAndDirectoriesSegmentResponse fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "EnumerationResults" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ListFilesAndDirectoriesSegmentResponse deserializedListFilesAndDirectoriesSegmentResponse
                = new ListFilesAndDirectoriesSegmentResponse();
            deserializedListFilesAndDirectoriesSegmentResponse.serviceEndpoint
                = reader.getStringAttribute(null, "ServiceEndpoint");
            deserializedListFilesAndDirectoriesSegmentResponse.shareName = reader.getStringAttribute(null, "ShareName");
            deserializedListFilesAndDirectoriesSegmentResponse.shareSnapshot
                = reader.getStringAttribute(null, "ShareSnapshot");
            deserializedListFilesAndDirectoriesSegmentResponse.encoded
                = reader.getNullableAttribute(null, "Encoded", Boolean::parseBoolean);
            deserializedListFilesAndDirectoriesSegmentResponse.directoryPath
                = reader.getStringAttribute(null, "DirectoryPath");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Prefix".equals(elementName.getLocalPart())) {
                    deserializedListFilesAndDirectoriesSegmentResponse.prefix = StringEncoded.fromXml(reader, "Prefix");
                } else if ("Marker".equals(elementName.getLocalPart())) {
                    deserializedListFilesAndDirectoriesSegmentResponse.marker = reader.getStringElement();
                } else if ("MaxResults".equals(elementName.getLocalPart())) {
                    deserializedListFilesAndDirectoriesSegmentResponse.maxResults
                        = reader.getNullableElement(Integer::parseInt);
                } else if ("Entries".equals(elementName.getLocalPart())) {
                    deserializedListFilesAndDirectoriesSegmentResponse.segment
                        = FilesAndDirectoriesListSegment.fromXml(reader, "Entries");
                } else if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedListFilesAndDirectoriesSegmentResponse.nextMarker = reader.getStringElement();
                } else if ("DirectoryId".equals(elementName.getLocalPart())) {
                    deserializedListFilesAndDirectoriesSegmentResponse.directoryId = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedListFilesAndDirectoriesSegmentResponse;
        });
    }
}
