/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class FileProperty
implements XmlSerializable<FileProperty> {
    private long contentLength;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastAccessTime;
    private OffsetDateTime lastWriteTime;
    private OffsetDateTime changeTime;
    private DateTimeRfc1123 lastModified;
    private String etag;

    public long getContentLength() {
        return this.contentLength;
    }

    public FileProperty setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public FileProperty setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime getLastAccessTime() {
        return this.lastAccessTime;
    }

    public FileProperty setLastAccessTime(OffsetDateTime lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    public OffsetDateTime getLastWriteTime() {
        return this.lastWriteTime;
    }

    public FileProperty setLastWriteTime(OffsetDateTime lastWriteTime) {
        this.lastWriteTime = lastWriteTime;
        return this;
    }

    public OffsetDateTime getChangeTime() {
        return this.changeTime;
    }

    public FileProperty setChangeTime(OffsetDateTime changeTime) {
        this.changeTime = changeTime;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FileProperty setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getEtag() {
        return this.etag;
    }

    public FileProperty setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "FileProperty" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeLongElement("Content-Length", this.contentLength);
        xmlWriter.writeStringElement("CreationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        xmlWriter.writeStringElement("LastAccessTime", this.lastAccessTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastAccessTime));
        xmlWriter.writeStringElement("LastWriteTime", this.lastWriteTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastWriteTime));
        xmlWriter.writeStringElement("ChangeTime", this.changeTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.changeTime));
        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.etag);
        return xmlWriter.writeEndElement();
    }

    public static FileProperty fromXml(XmlReader xmlReader) throws XMLStreamException {
        return FileProperty.fromXml(xmlReader, null);
    }

    public static FileProperty fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "FileProperty" : rootElementName;
        return (FileProperty)xmlReader.readObject(finalRootElementName, reader -> {
            FileProperty deserializedFileProperty = new FileProperty();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Content-Length".equals(elementName.getLocalPart())) {
                    deserializedFileProperty.contentLength = reader.getLongElement();
                    continue;
                }
                if ("CreationTime".equals(elementName.getLocalPart())) {
                    deserializedFileProperty.creationTime = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("LastAccessTime".equals(elementName.getLocalPart())) {
                    deserializedFileProperty.lastAccessTime = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("LastWriteTime".equals(elementName.getLocalPart())) {
                    deserializedFileProperty.lastWriteTime = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("ChangeTime".equals(elementName.getLocalPart())) {
                    deserializedFileProperty.changeTime = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedFileProperty.lastModified = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedFileProperty.etag = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedFileProperty;
        });
    }
}

