/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.azure.storage.file.share.models.ShareProtocols;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareProperties
implements XmlSerializable<ShareProperties> {
    private DateTimeRfc1123 lastModified;
    private String eTag;
    private int quota;
    private Integer provisionedIops;
    private Integer provisionedIngressMBps;
    private Integer provisionedEgressMBps;
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;
    private DateTimeRfc1123 deletedTime;
    private Integer remainingRetentionDays;
    private String accessTier;
    private DateTimeRfc1123 accessTierChangeTime;
    private String accessTierTransitionState;
    private LeaseStatusType leaseStatus;
    private LeaseStateType leaseState;
    private LeaseDurationType leaseDuration;
    private ShareProtocols protocols;
    private ShareRootSquash rootSquash;
    private Map<String, String> metadata;
    private Integer provisionedBandwidthMiBps;
    private Boolean enableSnapshotVirtualDirectoryAccess;
    private Boolean enablePaidBursting;
    private Long paidBurstingMaxIops;
    private Long paidBurstingMaxBandwidthMibps;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public ShareProperties setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public ShareProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public int getQuota() {
        return this.quota;
    }

    public ShareProperties setQuota(int quota) {
        this.quota = quota;
        return this;
    }

    public Integer getProvisionedIops() {
        return this.provisionedIops;
    }

    public ShareProperties setProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    @Deprecated
    public Integer getProvisionedIngressMBps() {
        return this.provisionedIngressMBps;
    }

    @Deprecated
    public ShareProperties setProvisionedIngressMBps(Integer provisionedIngressMBps) {
        this.provisionedIngressMBps = provisionedIngressMBps;
        return this;
    }

    @Deprecated
    public Integer getProvisionedEgressMBps() {
        return this.provisionedEgressMBps;
    }

    @Deprecated
    public ShareProperties setProvisionedEgressMBps(Integer provisionedEgressMBps) {
        this.provisionedEgressMBps = provisionedEgressMBps;
        return this;
    }

    public Integer getProvisionedBandwidthMiBps() {
        return this.provisionedBandwidthMiBps;
    }

    public ShareProperties setProvisionedBandwidthMiBps(Integer provisionedBandwidthMiBps) {
        this.provisionedBandwidthMiBps = provisionedBandwidthMiBps;
        return this;
    }

    public OffsetDateTime getNextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    public ShareProperties setNextAllowedQuotaDowngradeTime(OffsetDateTime nextAllowedQuotaDowngradeTime) {
        this.nextAllowedQuotaDowngradeTime = nextAllowedQuotaDowngradeTime == null ? null : new DateTimeRfc1123(nextAllowedQuotaDowngradeTime);
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public ShareProperties setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public ShareProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public String getAccessTier() {
        return this.accessTier;
    }

    public ShareProperties setAccessTier(String accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    public ShareProperties setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }

    public String getAccessTierTransitionState() {
        return this.accessTierTransitionState;
    }

    public ShareProperties setAccessTierTransitionState(String accessTierTransitionState) {
        this.accessTierTransitionState = accessTierTransitionState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public ShareProperties setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public ShareProperties setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public ShareProperties setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public ShareProtocols getProtocols() {
        return this.protocols;
    }

    public ShareProperties setProtocols(ShareProtocols protocols) {
        this.protocols = protocols;
        return this;
    }

    public ShareRootSquash getRootSquash() {
        return this.rootSquash;
    }

    public ShareProperties setRootSquash(ShareRootSquash rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ShareProperties setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Boolean isSnapshotVirtualDirectoryAccessEnabled() {
        return this.enableSnapshotVirtualDirectoryAccess;
    }

    public ShareProperties setSnapshotVirtualDirectoryAccessEnabled(Boolean enableSnapshotVirtualDirectoryAccess) {
        this.enableSnapshotVirtualDirectoryAccess = enableSnapshotVirtualDirectoryAccess;
        return this;
    }

    public Boolean isPaidBurstingEnabled() {
        return this.enablePaidBursting;
    }

    public ShareProperties setPaidBurstingEnabled(Boolean enablePaidBursting) {
        this.enablePaidBursting = enablePaidBursting;
        return this;
    }

    public Long getPaidBurstingMaxIops() {
        return this.paidBurstingMaxIops;
    }

    public ShareProperties setPaidBurstingMaxIops(Long paidBurstingMaxIops) {
        this.paidBurstingMaxIops = paidBurstingMaxIops;
        return this;
    }

    public Long getPaidBurstingMaxBandwidthMibps() {
        return this.paidBurstingMaxBandwidthMibps;
    }

    public ShareProperties setPaidBurstingMaxBandwidthMibps(Long paidBurstingMaxBandwidthMibps) {
        this.paidBurstingMaxBandwidthMibps = paidBurstingMaxBandwidthMibps;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "ShareProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.eTag);
        xmlWriter.writeIntElement("Quota", this.quota);
        xmlWriter.writeNumberElement("ProvisionedIops", (Number)this.provisionedIops);
        xmlWriter.writeNumberElement("ProvisionedIngressMBps", (Number)this.provisionedIngressMBps);
        xmlWriter.writeNumberElement("ProvisionedEgressMBps", (Number)this.provisionedEgressMBps);
        xmlWriter.writeStringElement("NextAllowedQuotaDowngradeTime", Objects.toString(this.nextAllowedQuotaDowngradeTime, null));
        xmlWriter.writeStringElement("DeletedTime", Objects.toString(this.deletedTime, null));
        xmlWriter.writeNumberElement("RemainingRetentionDays", (Number)this.remainingRetentionDays);
        xmlWriter.writeStringElement("AccessTier", this.accessTier);
        xmlWriter.writeStringElement("AccessTierChangeTime", Objects.toString(this.accessTierChangeTime, null));
        xmlWriter.writeStringElement("AccessTierTransitionState", this.accessTierTransitionState);
        xmlWriter.writeStringElement("LeaseStatus", this.leaseStatus == null ? null : this.leaseStatus.toString());
        xmlWriter.writeStringElement("LeaseState", this.leaseState == null ? null : this.leaseState.toString());
        xmlWriter.writeStringElement("LeaseDuration", this.leaseDuration == null ? null : this.leaseDuration.toString());
        xmlWriter.writeStringElement("EnabledProtocols", Objects.toString(this.protocols, null));
        xmlWriter.writeStringElement("RootSquash", this.rootSquash == null ? null : this.rootSquash.toString());
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static ShareProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareProperties.fromXml(xmlReader, null);
    }

    public static ShareProperties fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "ShareProperties" : rootElementName;
        return (ShareProperties)xmlReader.readObject(finalRootElementName, reader -> {
            ShareProperties deserializedShareProperties = new ShareProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.lastModified = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.eTag = reader.getStringElement();
                    continue;
                }
                if ("Quota".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.quota = reader.getIntElement();
                    continue;
                }
                if ("ProvisionedIops".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.provisionedIops = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("ProvisionedIngressMBps".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.provisionedIngressMBps = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("ProvisionedEgressMBps".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.provisionedEgressMBps = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("ProvisionedBandwidthMiBps".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.provisionedBandwidthMiBps = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("NextAllowedQuotaDowngradeTime".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.nextAllowedQuotaDowngradeTime = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("DeletedTime".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.deletedTime = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("RemainingRetentionDays".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.remainingRetentionDays = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("AccessTier".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.accessTier = reader.getStringElement();
                    continue;
                }
                if ("AccessTierChangeTime".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.accessTierChangeTime = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("AccessTierTransitionState".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.accessTierTransitionState = reader.getStringElement();
                    continue;
                }
                if ("LeaseStatus".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.leaseStatus = LeaseStatusType.fromString(reader.getStringElement());
                    continue;
                }
                if ("LeaseState".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.leaseState = LeaseStateType.fromString(reader.getStringElement());
                    continue;
                }
                if ("LeaseDuration".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.leaseDuration = LeaseDurationType.fromString(reader.getStringElement());
                    continue;
                }
                if ("EnabledProtocols".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.protocols = ModelHelper.parseShareProtocols(reader.getStringElement());
                    continue;
                }
                if ("RootSquash".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.rootSquash = ShareRootSquash.fromString(reader.getStringElement());
                    continue;
                }
                if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedShareProperties.metadata == null) {
                            deserializedShareProperties.metadata = new LinkedHashMap<String, String>();
                        }
                        deserializedShareProperties.metadata.put(reader.getElementName().getLocalPart(), reader.getStringElement());
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareProperties;
        });
    }
}

